import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import java.awt.*; 
import java.awt.image.BufferedImage; 
import java.io.*; 
import java.util.*; 
import javax.swing.*; 
import org.apache.commons.io.FilenameUtils; 
import gifAnimation.*; 
import drop.*; 
import java.awt.Cursor; 
import java.awt.Desktop; 
import java.awt.EventQueue; 
import java.awt.event.MouseAdapter; 
import java.awt.event.MouseEvent; 
import java.io.IOException; 
import java.net.URI; 
import java.net.URISyntaxException; 
import javax.swing.JFrame; 
import javax.swing.JLabel; 
import javax.swing.JPanel; 
import boofcv.processing.*; 
import boofcv.struct.image.*; 
import boofcv.alg.filter.binary.Contour; 
import georegression.struct.point.*; 
import java.util.List; 
import processing.pdf.*; 
import processing.svg.*; 

import gifAnimation.*; 
import boofcv.processing.*; 
import boofcv.*; 
import boofcv.io.*; 
import boofcv.io.calibration.*; 
import boofcv.io.fiducial.*; 
import boofcv.io.geo.*; 
import boofcv.io.image.*; 
import boofcv.io.image.impl.*; 
import boofcv.io.points.*; 
import boofcv.io.points.impl.*; 
import boofcv.io.video.*; 
import boofcv.io.wrapper.*; 
import boofcv.io.wrapper.images.*; 
import boofcv.visualize.*; 
import boofcv.alg.bow.*; 
import boofcv.struct.learning.*; 
import boofcv.abst.fiducial.*; 
import boofcv.abst.fiducial.calib.*; 
import boofcv.abst.scene.*; 
import boofcv.abst.tracker.*; 
import boofcv.alg.drawing.*; 
import boofcv.alg.fiducial.calib.*; 
import boofcv.alg.fiducial.calib.chess.*; 
import boofcv.alg.fiducial.calib.circle.*; 
import boofcv.alg.fiducial.calib.grid.*; 
import boofcv.alg.fiducial.calib.squares.*; 
import boofcv.alg.fiducial.dots.*; 
import boofcv.alg.fiducial.qrcode.*; 
import boofcv.alg.fiducial.square.*; 
import boofcv.alg.scene.*; 
import boofcv.alg.scene.codec.*; 
import boofcv.alg.tracker.circulant.*; 
import boofcv.alg.tracker.meanshift.*; 
import boofcv.alg.tracker.sfot.*; 
import boofcv.alg.tracker.tld.*; 
import boofcv.deepboof.*; 
import boofcv.factory.fiducial.*; 
import boofcv.factory.scene.*; 
import boofcv.factory.tracker.*; 
import boofcv.abst.sfm.*; 
import boofcv.abst.sfm.d2.*; 
import boofcv.abst.sfm.d3.*; 
import boofcv.alg.depth.*; 
import boofcv.alg.feature.associate.*; 
import boofcv.alg.geo.pose.*; 
import boofcv.alg.sfm.*; 
import boofcv.alg.sfm.d2.*; 
import boofcv.alg.sfm.d3.*; 
import boofcv.alg.sfm.d3.direct.*; 
import boofcv.alg.sfm.d3.structure.*; 
import boofcv.alg.sfm.overhead.*; 
import boofcv.alg.sfm.robust.*; 
import boofcv.alg.sfm.structure.*; 
import boofcv.alg.sfm.structure2.*; 
import boofcv.factory.sfm.*; 
import boofcv.struct.sfm.*; 
import boofcv.abst.geo.calibration.*; 
import boofcv.alg.geo.calibration.*; 
import boofcv.alg.geo.calibration.cameras.*; 
import boofcv.alg.geo.selfcalib.*; 
import boofcv.abst.feature.associate.*; 
import boofcv.abst.feature.dense.*; 
import boofcv.abst.feature.describe.*; 
import boofcv.abst.feature.detdesc.*; 
import boofcv.abst.feature.detect.extract.*; 
import boofcv.abst.feature.detect.intensity.*; 
import boofcv.abst.feature.detect.interest.*; 
import boofcv.abst.feature.detect.line.*; 
import boofcv.abst.feature.detect.peak.*; 
import boofcv.abst.feature.disparity.*; 
import boofcv.abst.feature.orientation.*; 
import boofcv.abst.flow.*; 
import boofcv.abst.segmentation.*; 
import boofcv.abst.shapes.polyline.*; 
import boofcv.alg.background.*; 
import boofcv.alg.background.moving.*; 
import boofcv.alg.background.stationary.*; 
import boofcv.alg.descriptor.*; 
import boofcv.alg.feature.color.*; 
import boofcv.alg.feature.dense.*; 
import boofcv.alg.feature.describe.*; 
import boofcv.alg.feature.describe.brief.*; 
import boofcv.alg.feature.describe.impl.*; 
import boofcv.alg.feature.describe.llah.*; 
import boofcv.alg.feature.detdesc.*; 
import boofcv.alg.feature.detect.chess.*; 
import boofcv.alg.feature.detect.edge.*; 
import boofcv.alg.feature.detect.edge.impl.*; 
import boofcv.alg.feature.detect.extract.*; 
import boofcv.alg.feature.detect.intensity.*; 
import boofcv.alg.feature.detect.intensity.impl.*; 
import boofcv.alg.feature.detect.interest.*; 
import boofcv.alg.feature.detect.line.*; 
import boofcv.alg.feature.detect.line.gridline.*; 
import boofcv.alg.feature.detect.peak.*; 
import boofcv.alg.feature.detect.selector.*; 
import boofcv.alg.feature.detect.template.*; 
import boofcv.alg.feature.disparity.*; 
import boofcv.alg.feature.disparity.block.*; 
import boofcv.alg.feature.disparity.block.score.*; 
import boofcv.alg.feature.disparity.block.select.*; 
import boofcv.alg.feature.disparity.sgm.*; 
import boofcv.alg.feature.disparity.sgm.cost.*; 
import boofcv.alg.feature.orientation.*; 
import boofcv.alg.feature.orientation.impl.*; 
import boofcv.alg.flow.*; 
import boofcv.alg.segmentation.*; 
import boofcv.alg.segmentation.fh04.*; 
import boofcv.alg.segmentation.fh04.impl.*; 
import boofcv.alg.segmentation.ms.*; 
import boofcv.alg.segmentation.slic.*; 
import boofcv.alg.segmentation.watershed.*; 
import boofcv.alg.shapes.*; 
import boofcv.alg.shapes.edge.*; 
import boofcv.alg.shapes.ellipse.*; 
import boofcv.alg.shapes.polygon.*; 
import boofcv.alg.shapes.polyline.*; 
import boofcv.alg.shapes.polyline.splitmerge.*; 
import boofcv.alg.tracker.*; 
import boofcv.alg.tracker.combined.*; 
import boofcv.alg.tracker.klt.*; 
import boofcv.factory.background.*; 
import boofcv.factory.feature.associate.*; 
import boofcv.factory.feature.dense.*; 
import boofcv.factory.feature.describe.*; 
import boofcv.factory.feature.detdesc.*; 
import boofcv.factory.feature.detect.edge.*; 
import boofcv.factory.feature.detect.extract.*; 
import boofcv.factory.feature.detect.intensity.*; 
import boofcv.factory.feature.detect.interest.*; 
import boofcv.factory.feature.detect.line.*; 
import boofcv.factory.feature.detect.peak.*; 
import boofcv.factory.feature.detect.selector.*; 
import boofcv.factory.feature.detect.template.*; 
import boofcv.factory.feature.disparity.*; 
import boofcv.factory.feature.orientation.*; 
import boofcv.factory.flow.*; 
import boofcv.factory.segmentation.*; 
import boofcv.factory.shape.*; 
import boofcv.numerics.*; 
import boofcv.struct.*; 
import boofcv.struct.feature.*; 
import boofcv.struct.flow.*; 
import boofcv.abst.geo.*; 
import boofcv.abst.geo.bundle.*; 
import boofcv.abst.geo.f.*; 
import boofcv.abst.geo.fitting.*; 
import boofcv.abst.geo.h.*; 
import boofcv.abst.geo.optimization.*; 
import boofcv.abst.geo.pose.*; 
import boofcv.abst.geo.triangulate.*; 
import boofcv.abst.geo.trifocal.*; 
import boofcv.alg.cloud.*; 
import boofcv.alg.distort.*; 
import boofcv.alg.distort.brown.*; 
import boofcv.alg.distort.pinhole.*; 
import boofcv.alg.distort.spherical.*; 
import boofcv.alg.distort.universal.*; 
import boofcv.alg.geo.*; 
import boofcv.alg.geo.bundle.*; 
import boofcv.alg.geo.bundle.cameras.*; 
import boofcv.alg.geo.bundle.jacobians.*; 
import boofcv.alg.geo.f.*; 
import boofcv.alg.geo.h.*; 
import boofcv.alg.geo.impl.*; 
import boofcv.alg.geo.rectify.*; 
import boofcv.alg.geo.robust.*; 
import boofcv.alg.geo.structure.*; 
import boofcv.alg.geo.triangulate.*; 
import boofcv.alg.geo.trifocal.*; 
import boofcv.alg.nn.*; 
import boofcv.factory.distort.*; 
import boofcv.factory.geo.*; 
import boofcv.struct.calib.*; 
import boofcv.struct.geo.*; 
import boofcv.abst.denoise.*; 
import boofcv.abst.distort.*; 
import boofcv.abst.filter.*; 
import boofcv.abst.filter.binary.*; 
import boofcv.abst.filter.blur.*; 
import boofcv.abst.filter.convolve.*; 
import boofcv.abst.filter.derivative.*; 
import boofcv.abst.filter.interpolate.*; 
import boofcv.abst.transform.census.*; 
import boofcv.abst.transform.fft.*; 
import boofcv.abst.transform.wavelet.*; 
import boofcv.abst.transform.wavelet.impl.*; 
import boofcv.alg.border.*; 
import boofcv.alg.color.*; 
import boofcv.alg.color.impl.*; 
import boofcv.alg.denoise.*; 
import boofcv.alg.denoise.wavelet.*; 
import boofcv.alg.distort.impl.*; 
import boofcv.alg.distort.mls.*; 
import boofcv.alg.enhance.*; 
import boofcv.alg.enhance.impl.*; 
import boofcv.alg.filter.basic.*; 
import boofcv.alg.filter.basic.impl.*; 
import boofcv.alg.filter.binary.*; 
import boofcv.alg.filter.binary.impl.*; 
import boofcv.alg.filter.blur.*; 
import boofcv.alg.filter.blur.impl.*; 
import boofcv.alg.filter.convolve.*; 
import boofcv.alg.filter.convolve.border.*; 
import boofcv.alg.filter.convolve.down.*; 
import boofcv.alg.filter.convolve.noborder.*; 
import boofcv.alg.filter.convolve.normalized.*; 
import boofcv.alg.filter.derivative.*; 
import boofcv.alg.filter.derivative.impl.*; 
import boofcv.alg.filter.kernel.*; 
import boofcv.alg.filter.kernel.impl.*; 
import boofcv.alg.filter.misc.*; 
import boofcv.alg.filter.stat.*; 
import boofcv.alg.interpolate.*; 
import boofcv.alg.interpolate.array.*; 
import boofcv.alg.interpolate.impl.*; 
import boofcv.alg.interpolate.kernel.*; 
import boofcv.alg.misc.*; 
import boofcv.alg.misc.impl.*; 
import boofcv.alg.transform.census.*; 
import boofcv.alg.transform.census.impl.*; 
import boofcv.alg.transform.fft.*; 
import boofcv.alg.transform.ii.*; 
import boofcv.alg.transform.ii.impl.*; 
import boofcv.alg.transform.pyramid.*; 
import boofcv.alg.transform.pyramid.impl.*; 
import boofcv.alg.transform.wavelet.*; 
import boofcv.alg.transform.wavelet.impl.*; 
import boofcv.alg.weights.*; 
import boofcv.core.encoding.*; 
import boofcv.core.encoding.impl.*; 
import boofcv.core.graph.*; 
import boofcv.core.image.*; 
import boofcv.core.image.border.*; 
import boofcv.core.image.impl.*; 
import boofcv.core.image.inst.*; 
import boofcv.factory.denoise.*; 
import boofcv.factory.filter.binary.*; 
import boofcv.factory.filter.blur.*; 
import boofcv.factory.filter.convolve.*; 
import boofcv.factory.filter.derivative.*; 
import boofcv.factory.filter.kernel.*; 
import boofcv.factory.interpolate.*; 
import boofcv.factory.transform.census.*; 
import boofcv.factory.transform.ii.*; 
import boofcv.factory.transform.pyramid.*; 
import boofcv.factory.transform.wavelet.*; 
import boofcv.factory.weights.*; 
import boofcv.misc.*; 
import boofcv.override.*; 
import boofcv.testing.*; 
import boofcv.alg.*; 
import boofcv.concurrency.*; 
import boofcv.factory.*; 
import boofcv.generate.*; 
import boofcv.struct.border.*; 
import boofcv.struct.convolve.*; 
import boofcv.struct.distort.*; 
import boofcv.struct.gss.*; 
import boofcv.struct.image.*; 
import boofcv.struct.lists.*; 
import boofcv.struct.pyramid.*; 
import boofcv.struct.sparse.*; 
import boofcv.struct.wavelet.*; 
import georegression.*; 
import georegression.fitting.*; 
import georegression.fitting.affine.*; 
import georegression.fitting.curves.*; 
import georegression.fitting.cylinder.*; 
import georegression.fitting.homography.*; 
import georegression.fitting.line.*; 
import georegression.fitting.plane.*; 
import georegression.fitting.se.*; 
import georegression.fitting.sphere.*; 
import georegression.geometry.*; 
import georegression.geometry.algs.*; 
import georegression.metric.*; 
import georegression.metric.alg.*; 
import georegression.misc.*; 
import georegression.misc.test.*; 
import georegression.struct.*; 
import georegression.struct.affine.*; 
import georegression.struct.curve.*; 
import georegression.struct.homography.*; 
import georegression.struct.line.*; 
import georegression.struct.plane.*; 
import georegression.struct.point.*; 
import georegression.struct.se.*; 
import georegression.struct.shapes.*; 
import georegression.struct.so.*; 
import georegression.struct.trig.*; 
import georegression.transform.*; 
import georegression.transform.affine.*; 
import georegression.transform.homography.*; 
import georegression.transform.se.*; 
import georegression.transform.twist.*; 
import org.ddogleg.*; 
import org.ddogleg.clustering.*; 
import org.ddogleg.clustering.gmm.*; 
import org.ddogleg.clustering.kmeans.*; 
import org.ddogleg.combinatorics.*; 
import org.ddogleg.fitting.modelset.*; 
import org.ddogleg.fitting.modelset.distance.*; 
import org.ddogleg.fitting.modelset.lmeds.*; 
import org.ddogleg.fitting.modelset.ransac.*; 
import org.ddogleg.graph.*; 
import org.ddogleg.nn.*; 
import org.ddogleg.nn.alg.*; 
import org.ddogleg.nn.alg.distance.*; 
import org.ddogleg.nn.alg.searches.*; 
import org.ddogleg.nn.wrap.*; 
import org.ddogleg.optimization.*; 
import org.ddogleg.optimization.derivative.*; 
import org.ddogleg.optimization.functions.*; 
import org.ddogleg.optimization.lm.*; 
import org.ddogleg.optimization.math.*; 
import org.ddogleg.optimization.quasinewton.*; 
import org.ddogleg.optimization.trustregion.*; 
import org.ddogleg.optimization.wrap.*; 
import org.ddogleg.rand.*; 
import org.ddogleg.solver.*; 
import org.ddogleg.solver.impl.*; 
import org.ddogleg.sorting.*; 
import org.ddogleg.stats.*; 
import org.ddogleg.struct.*; 
import org.ddogleg.util.*; 
import gnu.trove.*; 
import gnu.trove.decorator.*; 
import gnu.trove.function.*; 
import gnu.trove.impl.*; 
import gnu.trove.impl.hash.*; 
import gnu.trove.impl.sync.*; 
import gnu.trove.impl.unmodifiable.*; 
import gnu.trove.iterator.*; 
import gnu.trove.iterator.hash.*; 
import gnu.trove.list.*; 
import gnu.trove.list.array.*; 
import gnu.trove.list.linked.*; 
import gnu.trove.map.*; 
import gnu.trove.map.custom_hash.*; 
import gnu.trove.map.hash.*; 
import gnu.trove.procedure.*; 
import gnu.trove.procedure.array.*; 
import gnu.trove.queue.*; 
import gnu.trove.set.*; 
import gnu.trove.set.hash.*; 
import gnu.trove.stack.*; 
import gnu.trove.stack.array.*; 
import gnu.trove.strategy.*; 
import org.ejml.equation.*; 
import org.ejml.simple.*; 
import org.ejml.simple.ops.*; 
import org.ejml.sparse.csc.*; 
import org.ejml.sparse.csc.decomposition.chol.*; 
import org.ejml.sparse.csc.decomposition.lu.*; 
import org.ejml.sparse.csc.decomposition.qr.*; 
import org.ejml.sparse.csc.factory.*; 
import org.ejml.sparse.csc.linsol.chol.*; 
import org.ejml.sparse.csc.linsol.lu.*; 
import org.ejml.sparse.csc.linsol.qr.*; 
import org.ejml.sparse.csc.misc.*; 
import org.ejml.sparse.csc.mult.*; 
import org.ejml.sparse.triplet.*; 
import org.ejml.dense.block.*; 
import org.ejml.dense.block.decomposition.bidiagonal.*; 
import org.ejml.dense.block.decomposition.chol.*; 
import org.ejml.dense.block.decomposition.hessenberg.*; 
import org.ejml.dense.block.decomposition.qr.*; 
import org.ejml.dense.block.linsol.chol.*; 
import org.ejml.dense.block.linsol.qr.*; 
import org.ejml.dense.fixed.*; 
import org.ejml.dense.row.*; 
import org.ejml.dense.row.decomposition.*; 
import org.ejml.dense.row.decomposition.bidiagonal.*; 
import org.ejml.dense.row.decomposition.chol.*; 
import org.ejml.dense.row.decomposition.eig.*; 
import org.ejml.dense.row.decomposition.eig.symm.*; 
import org.ejml.dense.row.decomposition.eig.watched.*; 
import org.ejml.dense.row.decomposition.hessenberg.*; 
import org.ejml.dense.row.decomposition.lu.*; 
import org.ejml.dense.row.decomposition.qr.*; 
import org.ejml.dense.row.decomposition.svd.*; 
import org.ejml.dense.row.decomposition.svd.implicitqr.*; 
import org.ejml.dense.row.factory.*; 
import org.ejml.dense.row.linsol.*; 
import org.ejml.dense.row.linsol.chol.*; 
import org.ejml.dense.row.linsol.lu.*; 
import org.ejml.dense.row.linsol.qr.*; 
import org.ejml.dense.row.linsol.svd.*; 
import org.ejml.dense.row.misc.*; 
import org.ejml.dense.row.mult.*; 
import org.ejml.generic.*; 
import org.ejml.dense.row.decompose.*; 
import org.ejml.dense.row.decompose.chol.*; 
import org.ejml.dense.row.decompose.hessenberg.*; 
import org.ejml.dense.row.decompose.lu.*; 
import org.ejml.dense.row.decompose.qr.*; 
import org.ejml.*; 
import org.ejml.data.*; 
import org.ejml.interfaces.*; 
import org.ejml.interfaces.decomposition.*; 
import org.ejml.interfaces.linsol.*; 
import org.ejml.ops.*; 
import org.ejml.sparse.*; 
import javax.annotation.*; 
import javax.annotation.concurrent.*; 
import javax.annotation.meta.*; 
import javax.annotation.security.*; 
import org.yaml.snakeyaml.*; 
import org.yaml.snakeyaml.composer.*; 
import org.yaml.snakeyaml.constructor.*; 
import org.yaml.snakeyaml.emitter.*; 
import org.yaml.snakeyaml.error.*; 
import org.yaml.snakeyaml.events.*; 
import org.yaml.snakeyaml.extensions.compactnotation.*; 
import org.yaml.snakeyaml.external.biz.base64Coder.*; 
import org.yaml.snakeyaml.external.com.google.gdata.util.common.base.*; 
import org.yaml.snakeyaml.introspector.*; 
import org.yaml.snakeyaml.nodes.*; 
import org.yaml.snakeyaml.parser.*; 
import org.yaml.snakeyaml.reader.*; 
import org.yaml.snakeyaml.representer.*; 
import org.yaml.snakeyaml.resolver.*; 
import org.yaml.snakeyaml.scanner.*; 
import org.yaml.snakeyaml.serializer.*; 
import org.yaml.snakeyaml.tokens.*; 
import org.yaml.snakeyaml.util.*; 
import org.apache.commons.io.*; 
import org.apache.commons.io.comparator.*; 
import org.apache.commons.io.filefilter.*; 
import org.apache.commons.io.input.*; 
import org.apache.commons.io.monitor.*; 
import org.apache.commons.io.output.*; 
import org.apache.commons.io.serialization.*; 
import deepboof.datasets.*; 
import deepboof.models.*; 
import deepboof.backward.*; 
import deepboof.factory.*; 
import deepboof.graph.*; 
import deepboof.impl.backward.standard.*; 
import deepboof.optim.*; 
import caffe.*; 
import deepboof.io.*; 
import deepboof.io.caffe.*; 
import deepboof.io.torch7.*; 
import deepboof.io.torch7.struct.*; 
import deepboof.net.*; 
import deepboof.*; 
import deepboof.forward.*; 
import deepboof.impl.forward.standard.*; 
import deepboof.misc.*; 
import deepboof.tensors.*; 
import com.google.protobuf.*; 
import org.apache.commons.compress.archivers.*; 
import org.apache.commons.compress.archivers.ar.*; 
import org.apache.commons.compress.archivers.arj.*; 
import org.apache.commons.compress.archivers.cpio.*; 
import org.apache.commons.compress.archivers.dump.*; 
import org.apache.commons.compress.archivers.jar.*; 
import org.apache.commons.compress.archivers.sevenz.*; 
import org.apache.commons.compress.archivers.tar.*; 
import org.apache.commons.compress.archivers.zip.*; 
import org.apache.commons.compress.changes.*; 
import org.apache.commons.compress.compressors.*; 
import org.apache.commons.compress.compressors.bzip2.*; 
import org.apache.commons.compress.compressors.gzip.*; 
import org.apache.commons.compress.compressors.lzma.*; 
import org.apache.commons.compress.compressors.pack200.*; 
import org.apache.commons.compress.compressors.snappy.*; 
import org.apache.commons.compress.compressors.xz.*; 
import org.apache.commons.compress.compressors.z.*; 
import org.apache.commons.compress.compressors.z._internal_.*; 
import org.apache.commons.compress.utils.*; 
import org.rauschig.jarchivelib.*; 
import net.lingala.zip4j.core.*; 
import net.lingala.zip4j.crypto.*; 
import net.lingala.zip4j.crypto.PBKDF2.*; 
import net.lingala.zip4j.crypto.engine.*; 
import net.lingala.zip4j.exception.*; 
import net.lingala.zip4j.io.*; 
import net.lingala.zip4j.model.*; 
import net.lingala.zip4j.progress.*; 
import net.lingala.zip4j.unzip.*; 
import net.lingala.zip4j.util.*; 
import net.lingala.zip4j.zip.*; 
import org.tukaani.xz.*; 
import org.tukaani.xz.check.*; 
import org.tukaani.xz.common.*; 
import org.tukaani.xz.delta.*; 
import org.tukaani.xz.index.*; 
import org.tukaani.xz.lz.*; 
import org.tukaani.xz.lzma.*; 
import org.tukaani.xz.rangecoder.*; 
import org.tukaani.xz.simple.*; 
import drop.*; 
import test.*; 
import org.imgscalr.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class TexTuring extends PApplet {








 GifMaker gifExport;
 SDrop drop; MyDropListener dropListener;

boolean control = false, viewing = false, threshold = true, lastFrameAnimation = false, isRendering = false ;
boolean killRender = false;
boolean synchroScroll = false;
boolean updateViewImg = false, updateMessage = false ;
PImage src ;
int h,w, off, offX, offY, viewSize=100, renderProgress=0 ;
float lastRenderTime;

int lastExportWidth = 0;
String loadedFileName = "";
File lastDirectory = null;

GuiWindow gui ;
Parameters params ;
int listenerWidth, listenerHeight;

public void settings() { size( displayWidth, displayHeight ); }
public void setup() {
  listenerHeight=height; listenerWidth=width;
  frameRate(30);
  params = new Parameters();
  gui = new GuiWindow(); gui.setupGui();
  fileSelected( new File(dataPath("Jaguar.png")) );
  gui.elements.get(0).scroll(4);
  params.loadFile( new File(dataPath("default.texturing")) );
}

public void draw() {
    resizeListener();

    gui.elements.get(9).update(); // diSlider
    if ( synchroScroll ) gui.elements.get(0).dragged();

    if ( viewing || updateViewImg )  gui.elements.get(0).update();
    if ( updateViewImg ) updateViewImg = false;
    if ( updateMessage ) {
        updateMessage = false;
        gui.elements.get(1).update();
        gui.elements.get(21).update(); // update render
    }
}
public void mousePressed (){ gui.injectMousePressed (); }
public void mouseReleased(){ gui.injectMouseReleased(); }
public void mouseMoved()   { gui.injectMouseMoved ();  }
public void mouseDragged() { gui.injectMouseDragged (); }
public void mouseWheel(processing.event.MouseEvent event) { gui.injectMouseWheel(event.getCount()); }
public void keyReleased(){ control = false; }
public void resizeListener(){
  if (listenerWidth!=width || listenerHeight!=height) {  // resize listener
  	if( width<800 ) surface.setSize(800,height);
  	if( height<700 ) surface.setSize(width,700);
    listenerWidth=width; listenerHeight=height;
    gui.resize();
    gui.update();
  }
}

public void exportImage() {
  String[] extention = { ".png     image", ".gif     animation", ".pdf     vectors", ".svg     vectors" };
  JTextField nameField = new JTextField(30); nameField.setText( loadedFileName + "_TexTuring-"+PApplet.parseInt(random(9999)) );
  JTextField widthField = new JTextField(5);
  int advisedWidth = constrain(params.o[2]*src.width/50,2000,20000);
  widthField.setText( ""+ PApplet.parseInt( (advisedWidth>lastExportWidth||lastExportWidth==0)? advisedWidth:lastExportWidth )  );
  JComboBox extField = new JComboBox( new DefaultComboBoxModel(extention) );
  JFileChooser pathField = new JFileChooser();

  if (lastDirectory != null) pathField.setCurrentDirectory( lastDirectory );
  pathField.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

  JPanel p1 = new JPanel(new FlowLayout(FlowLayout.LEFT)); p1.add(pathField);
  JPanel p2 = new JPanel(new FlowLayout(FlowLayout.LEFT));
  JPanel p3 = new JPanel(new FlowLayout(FlowLayout.LEFT));
  p2.setBorder(BorderFactory.createEmptyBorder(50,20,5,5));
  p3.setBorder(BorderFactory.createEmptyBorder(0,20,5,5));
  p2.add(new JLabel("Image width : ")); p2.add(widthField); p2.add(new JLabel(" pixels"));
  p3.add(new JLabel("Image name : ")); p3.add(nameField); p3.add(extField);
  JPanel outer = new JPanel(new BorderLayout());
  outer.add(p1, BorderLayout.NORTH);
  outer.add(p2, BorderLayout.CENTER);
  outer.add(p3, BorderLayout.SOUTH);

  int result = JOptionPane.showConfirmDialog(null, outer, "Select export options", JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE);
  if (result == JOptionPane.OK_OPTION) {

    if( PApplet.parseInt(widthField.getText()) != advisedWidth ){ lastExportWidth = PApplet.parseInt(widthField.getText()); } else { lastExportWidth = 0; } //save width field
    lastDirectory = pathField.getCurrentDirectory();
    String path = pathField.getCurrentDirectory() + File.separator + nameField.getText() ;

    if( split((String)extField.getSelectedItem(),' ')[0].equals(".gif") ) gifExport = new GifMaker(this, path + ".gif" );

    new ExportThread(path, PApplet.parseInt(widthField.getText()), split((String)extField.getSelectedItem(),' ')[0] ).start();
    isRendering = true;
  }
}

class ExportThread extends Thread{
    String path;
    String ext;
    int widthField;

    public ExportThread(String path, int widthField, String ext ){
        this.path = path;
        this.ext = ext;
        this.widthField = widthField;
    }

    public void run(){
        if ( ext.equals(".png") ) {

            if( gui.state == "multiFiles" ){
                if( gui.elements.get(7).isSnaped() )
                params.loadParameters( gui.elements.get(7).savedParams );

                for ( int i=0; i < gui.listOfFiles.size(); ++i ) {
                    src = loadImage( gui.listOfFiles.get(i).getAbsolutePath() );
                    if( gui.elements.get(8).isSnaped() )
                    params.nextFrameAnimation( gui.listOfFiles.size(), gui.elements.get(8).savedParams );
                    saveImage( render(src.get(), widthField, "export"), path + File.separator + gui.listOfFiles.get(i).getName() );
                }
            } else {
                saveImage( render(src.get(), widthField, "export") , path + ".png" );
            }
        }

        if ( ext.equals(".gif") ) {
            // second message box to get gif export infos
            JPanel p3 = new JPanel();
            JPanel p4 = new JPanel();
            JTextField nbrFrameField = new JTextField(4); nbrFrameField.setText( "10" );
            p3.add(nbrFrameField);
            p3.add(new JLabel("<html> frames from <i>begining sample</i> to <i>ending sample</i></html>"));
            JTextField durationField = new JTextField(4); durationField.setText( "0.06" );
            p4.add(durationField);
            p4.add(new JLabel("<html> seconds per frame</html>"));
            JPanel outer2 = new JPanel(new BorderLayout());
            outer2.add(p3, BorderLayout.NORTH);
            outer2.add(p4, BorderLayout.SOUTH);

            int result2 = JOptionPane.showConfirmDialog(null, outer2, "Animation export options", JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE);
            if (result2 == JOptionPane.OK_OPTION) {

                gifExport.setRepeat(0); // infinite
                gifExport.setQuality(10); // default 10

                if( gui.elements.get(7).isSnaped() )
                params.loadParameters( gui.elements.get(7).savedParams );

                // render every frames
                for (int i=0; i < PApplet.parseInt(nbrFrameField.getText()); ++i) {

                    PImage gifImg =  render(src.get(), widthField*3, "export") ;
                    gifImg.resize( widthField,0);
                    gifExport.addFrame( gifImg );
                    gifExport.setDelay( PApplet.parseInt( PApplet.parseFloat( durationField.getText() )*1000 ) ); // convert sec to ms
                    params.nextFrameAnimation( PApplet.parseInt( nbrFrameField.getText() ), gui.elements.get(8).savedParams );
                }
                gifExport.finish();
            }
        }

        if ( ext.equals(".pdf") ) {
            vectorization( render(src.get(), PApplet.parseInt(params.o[2]*src.width/100)*4, "export"), path + ".pdf",1 );
        }
        if ( ext.equals(".svg") ) {
            vectorization( render(src.get(), PApplet.parseInt(params.o[2]*src.width/100)*4, "export"), path + ".svg",2 );
        }
        gui.message(path + ext + "   file saved.");
        isRendering = false;
        ((ViewPort)gui.elements.get(0)).frameAnimation();
    }
}

public void saveImage ( PImage img, String path ) {
  PGraphics pg = null ;
  pg = createGraphics(img.width, img.height);
  pg.beginDraw();
  pg.image(img,0,0);
  pg.endDraw();
  pg.get().save( path );
}

public void fileSelected(File selection) {
  if (selection !=null) {
    loadedFileName =  FilenameUtils.removeExtension( selection.getName() );
    PImage tmp = loadImage( selection.getAbsolutePath() );
    tmp.filter(GRAY);
    src = createImage(tmp.width, tmp.height, ALPHA);
    src.copy(tmp,0,0,src.width, src.height,0,0,src.width, src.height);
    w = src.width;
    h = src.height;
    gui.update();
    gui.elements.get(0).initView();
    viewing = true ;
  }
}
public void folderSelected(File selection) {
  if ( selection !=null ) {

    File viewFile = null;
    File[] files = selection.listFiles();

    for ( File file : files ) {
      if ( file.isFile() && validImageFile( file ) ) {
        gui.listOfFiles.add( file );
        viewFile = file;
      }
    }
    if ( viewFile !=null ){
      fileSelected( viewFile );
      gui.state = "multiFiles";
      gui.message(gui.listOfFiles.size()+" images loaded");
    }
  }
}

public PImage render(PImage img, int widthOut, String state ){

    int imgWidth = PApplet.parseInt( params.o[2]*img.width/100 ); if (imgWidth<5) imgWidth = 5;

    img.resize(imgWidth, 0 );
    algoReactionDiffusion(img, state);

    if ( state.equals("export") || state.equals("animate") ) {
        // load PImage to bufferImage
        BufferedImage scaledImg = Scalr.resize( (BufferedImage)img.getNative(), Scalr.Method.QUALITY, Scalr.Mode.FIT_TO_WIDTH, widthOut);
        img = new PImage(scaledImg);
    }else{
        img.resize( widthOut, 0 );  // may be faster but uglyer (blobs not perfectly round)
    }

    thresholdImg(img);
    return img ;
}
public void thresholdImg(PImage img){
    if (threshold) img.filter(THRESHOLD, map(params.o[1],0,255,0,1) );
}
//////////////////////////////////////////////// reaction - diffusion ///////////////
float uvv, u, v;
float diffU, diffV;
float lapU, lapV;
float[] MINI = { 0.00f, 0.01f, 0.03f, 0.005f };  // F, K, diffU, diffV
float[] MAXI = { 0.15f, 0.08f, 0.11f, 0.05f };  // F, K, diffU, diffV
float NOISE_ZOOM = 0.10f;

public PImage algoReactionDiffusion (PImage img, String state) {
    int W = img.width, H = img.height;
    int[][] offsetW = new int[W][2], offsetH = new int[H][2];
    float[][]  U = new float[W][H],  V = new float[W][H];
    float time = millis();

    //  INITIALISATION
    for (int i = 0; i < W; ++i) {
        for (int j = 0; j < H; ++j) {
            if ( params.iniState == 0 ) { // random
                U[i][j] = 0;
                V[i][j] = random(1) *0.7f ;
            }
            if ( params.iniState == 1 ) { // noise
                U[i][j] = 0; // map( noise( i*NOISE_ZOOM, j*NOISE_ZOOM) , 0,1, slider[0], slider[1]);
                V[i][j] = noise( i*NOISE_ZOOM, j*NOISE_ZOOM) *0.7f ;
            }
            if ( params.iniState == 2 ) { // uniform
                U[i][j] = 0.15f ;
                V[i][j] = 0.7f  ;
            }
        }
    }

    float[][][] fkuv = new float[W][H][4];  // init param grid

    float[] b = new float[5];
    float[] w = new float[5];
    for (int k = 0; k<4; ++k) b[k] = map(params.b[k], 0, 200, MINI[k], MAXI[k]);
    for (int k = 0; k<4; ++k) w[k] = map(params.w[k], 0, 200, MINI[k], MAXI[k]);
    float midU = map( params.b[2]+params.w[2] ,0,400,MINI[2],MAXI[2] );
    float midV = map( params.b[3]+params.w[3] ,0,400,MINI[3],MAXI[3] );

    for (int i = 0; i<W; ++i){
        for (int j = 0; j<H; ++j){

            if ( state.equals("renderMapImg") ) {
                fkuv[i][j][0] = ( map( i, 0, H, MINI[0], MAXI[0] )  );
                fkuv[i][j][1] = ( map( j, 0, W, MAXI[1], MINI[0] )  );
                fkuv[i][j][2] = midU;
                fkuv[i][j][3] = midV;

                } else {
                    for (int k = 0; k<4; ++k){
                        fkuv[i][j][k] = (  map( brightness(img.pixels[j*W+i]),0,255, b[k], w[k]) );
                    }
                }

            }
        }

        //Set up offsets
        for (int i=0; i < W; ++i) { offsetW[i][0] = i-1; offsetW[i][1] = i+1; }
        for (int i=0; i < H; ++i) { offsetH[i][0] = i-1; offsetH[i][1] = i+1; }
        offsetW[0][0] = 0; offsetW[W-1][1] = W-1;
        offsetH[0][0] = 0; offsetH[H-1][1] = H-1;
        int n = 0;
        int nMax = params.o[0];
        for ( n = 0; n< nMax ; ++n){ // nombre d'iterations
        for (int i = 0; i < W; ++i) {
            for (int j = 0; j < H; ++j) {

                lapU = U[offsetW[i][0]][j] + U[offsetW[i][1]][j] + U[i][offsetH[j][0]] + U[i][offsetH[j][1]] -4*U[i][j];
                lapV = V[offsetW[i][0]][j] + V[offsetW[i][1]][j] + V[i][offsetH[j][0]] + V[i][offsetH[j][1]] -4*V[i][j];

                uvv = U[i][j]*V[i][j]*V[i][j];
                U[i][j] += ( fkuv[i][j][2]*lapU - uvv + fkuv[i][j][0]*(1 - U[i][j]) ) * 1.38f ;
                V[i][j] += ( fkuv[i][j][3]*lapV + uvv - (fkuv[i][j][1]+fkuv[i][j][0])*V[i][j] ) * 0.63f ;
            }
        }
        if( (state.equals("export") || state.equals("animate")) && n%PApplet.parseInt((params.o[0])/100+1) == 0 )  {
            renderProgress = PApplet.parseInt( (100*n)/(params.o[0]+1) );
            gui.message("Rendering : "+renderProgress+" %  " );
        }

        if( (state.equals("export") || state.equals("animate")) && n%30 == 3 ){
            ((ViewPort)gui.elements.get(0)).dataAnimation = U ;
            updateViewImg = true;
        }
        if( (state.equals("export") ) && n == params.o[0]-1 ){
            ((ViewPort)gui.elements.get(0)).dataAnimation = U ;
            lastFrameAnimation = true;
            updateViewImg = true;
            gui.message("Saving file ...");
        }
        if( killRender ){ n = params.o[0]-2; killRender = false; }
        if( Thread.currentThread().isInterrupted() ) break;
    }

    if( Thread.currentThread().isInterrupted() ) lastRenderTime = ( nMax / n ) * ( millis()-time ) /1000 ;
    if( Thread.currentThread().isInterrupted() ) return null ;

    writeImg(img, U);
    lastRenderTime = ( millis()-time ) /1000 ;
    return img;
}

public void writeImg(PImage img, float[][] U){
    int pShift;
    for (int i = 0; i < img.width; i++) {
        for (int j = 0; j < img.height; j++) {
            pShift = PApplet.parseInt( U[i][j]*255) ;
            img.pixels[j*img.width+i] = 0xff000000 | (pShift << 16) | (pShift << 8) | pShift  ;
        }
    }
}
class GuiWindow {
  ArrayList<GuiElement> elements;
  String state = "";
  ArrayList<File> listOfFiles;
  GuiWindow() {
    elements = new ArrayList<GuiElement>();
    listOfFiles = new ArrayList<File>();
  }

  public void setupGui(){
    try { UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName()); } catch (Exception e) { e.printStackTrace(); }  //  platform specific UI
    javax.swing.JFrame jframe = (javax.swing.JFrame)((processing.awt.PSurfaceAWT.SmoothCanvas)getSurface().getNative()).getFrame();
    jframe.setLocation(0, 0);
    jframe.setExtendedState(jframe.getExtendedState() | jframe.MAXIMIZED_BOTH);
    surface.setResizable(true);
    surface.setTitle ( "TexTuring" );
    surface.setIcon( loadImage("logo.png") );
    colorMode(HSB); for (int i=0;i<=25;i++) C[i] = color( 133, 270-i*13, 105+i*5 ); // create UI color shades
    colorActive = C[12]; //color(255, 142, 9);
    background( bg );
    noStroke();
    PFont font = loadFont("PixelOperator-16.vlw"); textFont(font, 16);
    initDrop();

    int guiWidth = 350;
    Rect guiRect = new Rect(d, d, 100, 22 );
                          elements.add(new Menu  (new Rect(guiRect), new String[]{ "Parameters", "Save settings", "Load settings" } ));
    guiRect.size.x = 113;
    guiRect.pos.x += 190; elements.add(new Menu  (new Rect(guiRect), new String[]{ "Input  image", "Select file", "Select folder" } ));
    guiRect.pos.x += 118; elements.add(new Menu  (new Rect(guiRect), new String[]{ "Seeding  mode", "random", "noise", "uniform" } ));
    guiRect.pos.x += 118; elements.add(new Button(new Rect(guiRect), "Save  image"));

                          elements.add(0,new ViewPort(new Rect( d+200+350+90 , b+35, width-200-350-90-d-d, height -3*b-35 )));

    guiRect.pos.x = d+200+350+90; elements.add(new Button(new Rect(guiRect) , "Render  preview"));
    guiRect.size.x = 22; guiRect.size.y = 22;
    guiRect.pos.x +=118;  elements.add(new Button(new Rect(guiRect), " +"));
    guiRect.pos.x += 22+5;elements.add(new Button(new Rect(guiRect), " -"));
    guiRect.pos.x += 22+6;
    guiRect.size.x=width-guiRect.pos.x-45-d; elements.add(1,new StatusBar(new Rect(guiRect), "status"));
    guiRect.size.x=45;
    guiRect.pos.x = width-d-45; elements.add(new Button(new Rect(guiRect), "About"));

    guiRect = new Rect( 200, d, guiWidth, 23);
    guiRect.pos.y += 100; elements.add(new Slider(new Rect(guiRect), "iterations","Growing time", 5000));
    guiRect.pos.y += 55; elements.add(new Slider(new Rect(guiRect), "resolution","Size", 255));
    guiRect.pos.y += 55;
    guiRect.size.x-= 30; elements.add(new Slider(new Rect(guiRect), "threshold","Threshold", 255));
    guiRect.pos.x += guiRect.size.x+10;
    guiRect.size.x = 22; elements.add(new CheckBox(new Rect(guiRect), "check threshold"));

    guiRect = new Rect( 200+50, guiRect.pos.y, 250, 250 );
    guiRect.pos.y += 55; elements.add(2,new DiSlider(new Rect(guiRect), "From Growing bay to shades of grey"));

    guiRect.size.x = guiWidth+10; guiRect.size.y = 60; guiRect.pos.x= 200;
    guiRect.pos.y += 304; elements.add(new BiSlider(new Rect(guiRect), "reaction","Feed rate"));
    guiRect.pos.y += 72;  elements.add(new BiSlider(new Rect(guiRect), "diffusion", "Kill rate"));

    for (int i = 0; i<7; i++) {
      elements.add( i+2, new Snap( new Rect( d , d+100+ i*(80+b)  , 100, 80 ) , "snap" ));
    }
    elements.get(7).flag = "beginAnimation";
    elements.get(8).flag = "endAnimation";
    elements.get(16).isSelected = true; // default seeding mode
    // debug : list elements position
    // for (int i = 0; i < gui.elements.size(); ++i) println(i + "---" + gui.elements.get(i).name );
  }

  public void injectMouseMoved()   { for(GuiElement elem:elements){if(                !isRendering||elem.name.equals("Render  preview"))  elem.moved(); } }
  public void injectMouseDragged() { for(GuiElement elem:elements){if(elem.isOver()&&(!isRendering||elem.name.equals("Render  preview"))){elem.dragged();return; }}}
  public void injectMouseReleased(){ for(GuiElement elem:elements){if(elem.isOver()&&(!isRendering||elem.name.equals("Render  preview"))){elem.released();return;}}}
  public void injectMousePressed() { for(GuiElement elem:elements){if(elem.isOver()&&(!isRendering||elem.name.equals("Render  preview"))){elem.pressed();return; }}}
  public void injectMouseWheel(int scroll){ for (GuiElement elem : elements) { if(elem.isOver()&&!isRendering ) { elem.scroll(scroll); return; } } }

  public void update(){
    gui.elements.get(9).updateMapImg();
    viewing = true ;
    for (GuiElement elem : elements)
      elem.update();
    fontColor(); text("Samples", d, d+100 -10 );
  }
  public void resize(){ for (GuiElement elem:elements) elem.resize(); }
  public void message(String msg){ elements.get(1).message(msg); updateMessage = true; }
  public void about(){
    JPanel aboutPane = new JPanel(new BorderLayout());
    JLabel    p1 = new JLabel("<html><h2>TexTuring 2.3</h2>2015-2021 - General Public Licence - GNU GPL<br>Dithering tool based on natural patterns.<br><br> Concept & production :<br></html>");
    SwingLink p2 = new SwingLink("www.ivan-murit.fr", "www.ivan-murit.fr");
    JLabel    p3 = new JLabel("<html><br>Special thanks to the crowd-founders for the initial support !<br><br></html>");
    p1.setFont(new Font("SansSerif", Font.PLAIN, 14));
    p2.setFont(new Font("SansSerif", Font.PLAIN, 14));
    p3.setFont(new Font("SansSerif", Font.PLAIN, 14));
    aboutPane.add( p1 ,BorderLayout.NORTH ); aboutPane.add( p2 ,BorderLayout.CENTER ); aboutPane.add( p3 , BorderLayout.SOUTH );
    // link.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));

    int aboutResult = JOptionPane.showConfirmDialog(null, aboutPane, "About", JOptionPane.DEFAULT_OPTION, JOptionPane.PLAIN_MESSAGE);
  }
}

public void keyPressed(){
  if (key=='+')  gui.elements.get(0).scroll(-1);
  if (key=='-')  gui.elements.get(0).scroll(1);
  if (key==' ')  gui.elements.get(0).renderView();
  if (key==ENTER)  gui.elements.get(0).renderView();
  if ( keyCode == CONTROL) control = true;
}

public void buttonPressed( GuiElement e ){
    if ( e.name == "Select file" ) { selectInput("Select a new image", "fileSelected"); }
    if ( e.name == "Select folder" ) { selectFolder("Select a folder to process:", "folderSelected");}
    if ( e.name == "Save  image" ) { exportImage(); }
    if ( e.name == "Load settings" ) { selectInput( "Select TexTuring settings file", "loadFile"); viewing = true ; }
    if ( e.name == "Save settings" ) { selectOutput("Name your TexTuring settings file", "saveFile"); }
    if ( e.name == "specimen" ) {  }
    if ( e.name == "check threshold" ) { threshold = !threshold ; viewing=true; }
    if ( e.name == "Render  preview"){ gui.elements.get(0).renderView(); }
    if ( e.name == " +" ) {  gui.elements.get(0).scroll(-1); }
    if ( e.name == " -" ) {  gui.elements.get(0).scroll(1); }
    if ( e.name == "About" ) { gui.about(); }
    GuiElement e16 = gui.elements.get(16); GuiElement e17 = gui.elements.get(17); GuiElement e18 = gui.elements.get(18);
    if ( e.name == "random" ){params.iniState=0; viewing=true; synchroScroll=true; e.isSelected=true; e17.isSelected=false; e18.isSelected=false; gui.update(); }
    if ( e.name == "noise"  ){params.iniState=1; viewing=true; synchroScroll=true; e.isSelected=true; e16.isSelected=false; e18.isSelected=false; gui.update(); }
    if ( e.name == "uniform"){params.iniState=2; viewing=true; synchroScroll=true; e.isSelected=true; e16.isSelected=false; e17.isSelected=false; gui.update(); }
    mousePressed = false ;
}

public void loadFile( File _file ){ params.loadFile( _file ); }
public void saveFile( File _file ){ params.saveFile( _file ); }

int[] C = new int[26];
int bg = color(225);
int colorActive ; //color(255, 142, 9);
int a = 200, b = 5, c = 20, d = 10, haut = 60, gauche = 65;
public void styleSelecStroke(){ stroke(C[15]); noFill(); }
public void styleSelec(){ fill(C[15]); noStroke(); }
public void fontColor(){ fill(C[0]); }
class GuiElement {
  Rect coords;
  String name;
  int ref;
  PImage mapImg ;
  PImage viewImg ;
  Rect viewZone ;
  float zoom = 0.5240786f ;
  boolean isOver = false;
  boolean isVisible = true;
  boolean dropState = false;
  boolean isSelected = false;
  Parameters savedParams ;
  String flag = "";

  GuiElement(){
    coords = new Rect();
  }

  GuiElement(Rect _coords, String _name){
    coords = _coords;
    name = _name;
    if (name=="iterations") ref = 0 ;
    if (name=="threshold") ref = 1 ;
    if (name=="resolution") ref = 2 ;
    if (name=="reaction") ref = 2 ;
    if (name=="diffusion") ref = 3 ;
  }

  public boolean isOver() { return coords.isOver(mouseX, mouseY); }

  public void update() {}
  //callbacks for injecting events
  public void moved() { update(); }
  public void pressed() {}
  public void released() {}
  public void dragged() {}
  public void initView() {}
  //helpers to uniformize ways of drawings things
  public void drawRect( Rect r) {             rect(   r.pos.x, r.pos.y, r.size.x, r.size.y ); }
  public void drawImage(PImage i, Rect r) {  image(i, r.pos.x, r.pos.y, r.size.x, r.size.y ); }
  public void drawText( Rect r, String text){ text(text, coords.pos.x + 5, coords.pos.y ); }
  public void renderView() {}
  public void scroll(int scroll) {}
  public void resize() {}
  public boolean isSnaped(){return false;}
  public void updateMapImg(){}
  public void message(String msg) {}
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Menu extends GuiElement {
    String[] names;
    Rect zone;
    Menu(Rect _coords, String[] _names) {
        super(_coords, _names[0]);
        names = new String[_names.length];
        arrayCopy( _names, names );
        for (int i = 1; i<names.length; i++){
            Rect _rect = new Rect( coords );
            _rect.pos.y += coords.size.y * i ;
            gui.elements.add( new Button(_rect, names[i] ) );
        }
        zone = new Rect( coords );
        zone.size.y = coords.size.y * names.length ;
        update();
    }
    public void update(){
        fill( isOver() ? C[14] : C[18] );
        drawRect(coords);
        fill(0);
        text(name, coords.pos.x + 5, coords.pos.y + 15);
        for (int i = 1; i<names.length; i++){
            for (GuiElement _elem : gui.elements) {
                if ( _elem.name == names[i] ){
                    if ( isOver() ) _elem.isVisible = true ;
                    if ( !zone.isOver() ) _elem.isVisible = false ;
                }
            }
        }
    }
    public void pressed() {
        buttonPressed( this );
    }
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Button extends GuiElement {
    Button(Rect _coords, String _name) {
        super(_coords, _name);
        update();
    }
    public void update(){
      if (isVisible){
          if( name.equals("Render  preview") && isRendering ){
              fill( isOver()? C[8] : C[12] ); drawRect(coords);
              fill(C[25]); text("Stop", coords.pos.x + 5, coords.pos.y + 15);
          }else{
              fill( isOver() ? C[15] : C[19] );
              if( isSelected ) fill( C[13] );
              drawRect(coords);
              fill(0); text(name, coords.pos.x + 5, coords.pos.y + 15);
          }
      }else{
          fill(C[24]);
          drawRect(coords);
      }
    }
    public void pressed() {
      buttonPressed( this );
    }
    public void resize(){
      if (name.equals("About")) coords = new Rect( width-d-coords.size.x , coords.pos.y, coords.size.x, coords.size.y );
    }
}
      ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class CheckBox extends GuiElement {
  boolean b = false;
  CheckBox(Rect _coords, String _name) {
    super(_coords, _name);
    update();
  }
  public void update(){
    fill( C[20] ); if(isOver()) fill(C[19]); // fond
    drawRect(coords);
    fill( b ? C[18] : C[14] );
    if(isOver()) fill(colorActive); // fond
    rect(coords.pos.x+4, coords.pos.y+4, coords.size.x-8, coords.size.y-8);
  }
  public void pressed() {
    buttonPressed( this );
    b = !b ;
    gui.elements.get(9).updateMapImg();
    gui.injectMouseMoved();
  }
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class StatusBar extends GuiElement {
  String txt = "";
  StatusBar(Rect _coords, String _name) {
    super(_coords, _name);
    update();
  }
  public void update(){
    fill( 255 ); drawRect(coords);
    fill(C[0]); text(txt, coords.pos.x + 10, coords.pos.y + 15);
    if (isRendering){
        int space = 120;
        fill(bg); rect(coords.pos.x + space-6, coords.pos.y, space+2, coords.size.y);
        fill( ( txt.equals("Saving file ...") && frameCount%15<5 )? C[14] : C[19]);
        rect(coords.pos.x + space, coords.pos.y, 110, coords.size.y);
        fill(C[10]); rect(coords.pos.x + space, coords.pos.y, renderProgress, coords.size.y);
        if (txt.equals("Saving file ...")) updateMessage = true;
    }
  }
  public void message(String msg){
    println("msg: "+msg);
    txt = msg ;
  }
  public void resize(){
    coords = new Rect( coords.pos.x , coords.pos.y, width-coords.pos.x-50-d, coords.size.y );
  }
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Slider extends GuiElement {
  int range;
  float pos;
  boolean press = false;
  PImage sliderTimeBg = loadImage("slider.png");
  PImage sliderTimeBg2 = loadImage("slider2.png");
  String txt;
  Slider(Rect _coords, String _name, String _txt, int _range){
    super(_coords, _name);
    range = _range;
    txt = _txt;
    update();
  }
  public void pressed (){
      pos = mouseX;
      press = true;
  }
  public void released (){
    if (press) gui.elements.get(9).updateMapImg();
    press = false;
  }
  public void dragged () {
      off = (control) ? 2 : 1 ;
      pos += (mouseX - pos)/off ;
      params.o[ref] = (int)constrain( map(pos-coords.pos.x,0, coords.size.x,0,range), 0, range);
      pos = mouseX;
      if( params.o[ref]==0 ) params.o[ref] = 1;

      update();
      viewing = true;
  }

  public void update(){
    float b = map( params.o[ref], 0,range, 0,coords.size.x ) ;

    fill( C[20] );
    drawRect(coords);
    pushMatrix(); translate(coords.pos.x, coords.pos.y);
        if (name=="iterations"||name=="resolution") image(sliderTimeBg, PApplet.parseInt(coords.size.x - sliderTimeBg.width), 0 );  // bg img
        if (!isOver()) fill( C[14] );
        if (isOver()) fill( C[11] );
        if(press) fill(colorActive);
        if (!threshold && ref==1) fill( C[18] );
        rect(0, 0, b, coords.size.y); // Slider
        fontColor();
        text(txt, 0 , -8);
        float textPos = b < coords.size.x-30 ? b+5 : b-30 ;
        text((int)params.o[ref], textPos, coords.size.y-6);  // number display
    popMatrix();
  }
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

PImage renderMin ;
PImage renderMinDone ;
class ViewPort extends GuiElement {
    Thread[] viewZoneThread = new Thread[ constrain(Runtime.getRuntime().availableProcessors(),1,4) ] ; int offThread = 0;
  Rect renderZone ;
  float centerRectX = 0, centerRectY = 0, centerSize ;
  boolean updateViewPort = false ;
  float[][] dataAnimation ;
  ViewPort (Rect _coords) {
    super(_coords, "preview");
    viewZone   = new Rect(0,0,coords.size.x, coords.size.y); // from top left of input src-img
    renderZone = new Rect(coords.pos.x, coords.pos.y, 100, 100);
    viewImg = createImage(PApplet.parseInt(coords.size.x), PApplet.parseInt(coords.size.y), ALPHA);
    renderMin = createImage(50,50,ALPHA);
    renderMinDone = createImage(50,50,ALPHA);
    viewZoneThread[1] = new ViewZoneThread( 10 ); viewZoneThread[0] = new ViewZoneThread( 10 );
    viewZoneThread[2] = new ViewZoneThread( 10 ); viewZoneThread[3] = new ViewZoneThread( 10 );
  }
  public void resize(){
    coords = new Rect( d+200+350+90 , b+35, width-200-350-90-d-d, height -3*b-35 );
    scroll(0);
  }
  public void scroll(int scroll){
    if( src.width/src.height < 1) zoom = constrain(zoom +0.05f*scroll, 0.1f, src.height/coords.size.y);  // src image = portrait
    if( src.width/src.height >= 1) zoom = constrain(zoom +0.05f*scroll, 0.1f, src.width/coords.size.x);  // src image = paysage
    modifyViewZonePos( (viewZone.size.x-zoom*coords.size.x)/2 , (viewZone.size.y-zoom*coords.size.y)/2 ); // keep zooming centered
    viewZone.size.x = coords.size.x*zoom ;
    viewZone.size.y = coords.size.y*zoom ;
    synchroScroll = true ;
  }
  public void moved() {
      if (coords.isOver() ){ cursor(MOVE); }else{ cursor(ARROW); }
  }
  public void dragged() {
    if ( isOver() || synchroScroll ) {
      synchroScroll = false ;
      modifyViewZonePos( pmouseX - mouseX , pmouseY - mouseY );
      updateView(src);
      viewing = true ;
    }
  }
  public void initView() {
      scroll(-1);
      modifyViewZonePos((src.width -viewZone.size.x)/2, (src.height-viewZone.size.y)/2 );
      updateView(src);
      viewing = true ;
  }
  public void modifyViewZonePos(float x, float y) {
      viewZone.pos.x = constrain( viewZone.pos.x+x, 0, (src.width -viewZone.size.x > 0) ? src.width -viewZone.size.x : 0 ) ;
      viewZone.pos.y = constrain( viewZone.pos.y+y, 0, (src.height-viewZone.size.y > 0) ? src.height-viewZone.size.y : 0 ) ;
  }
  public void renderView(){  // render all the viewPort
      if ( isRendering ) {
        killRender = true;
      }else{
          isRendering = true ;
          viewing = false ;
          thread("renderViewThread");
      }
  }

  public void updateView( PImage source ){ // setup viewImg as the viewZone from src
    viewImg = createImage(
      (viewZone.pos.x+viewZone.size.x < src.width )? (int)viewZone.size.x : PApplet.parseInt( src.width  ) ,
      (viewZone.pos.y+viewZone.size.y < src.height)? (int)viewZone.size.y : PApplet.parseInt( src.height ) ,
    ALPHA );
    viewImg.set(-(int)viewZone.pos.x, -(int)viewZone.pos.y, source );
  }

  public void update(){
    fill(bg); rect(coords.pos.x,coords.pos.y,coords.size.x+10,coords.size.y+10); // background

    if( isRendering ){ frameAnimation();
    } else{
        image(viewImg, coords.pos.x, coords.pos.y,
            round((viewZone.pos.x+viewZone.size.x < src.width )? coords.size.x : src.width /zoom),
            round((viewZone.pos.y+viewZone.size.y < src.height )? coords.size.y : src.height /zoom)
       ); // display original image
    }

    if( dropState ) { // drag & drop files indicator
      fill( colorActive,100 );
      rect( coords.pos.x, coords.pos.y, coords.size.x, coords.size.y );
    }

    // render renderZone
    if ( !isRendering && !updateViewPort ) {
      if( viewing ){
        viewing = false ;
        // set renderZone size
        float time = 0.12f;
        if( lastRenderTime <time-0.11f ){ centerSize+=35 ;} else if (lastRenderTime >time+0.11f) { centerSize-=35 ;}
        else if( lastRenderTime <time-0.09f ){ centerSize+=20 ;} else if (lastRenderTime >time+0.09f) { centerSize-=20 ;}
        else if( lastRenderTime <time-0.07f ){ centerSize+=10 ;} else if (lastRenderTime >time+0.07f) { centerSize-=10 ;}
        else if( lastRenderTime <time-0.05f ){ centerSize+=4 ;} else if (lastRenderTime >time+0.05f) { centerSize-=5 ;}
        else if( lastRenderTime <time-0.03f ){ centerSize+=2 ;} else if (lastRenderTime >time+0.03f) { centerSize-=2 ;}
        else if( lastRenderTime <time-0.02f ){ centerSize+=1 ;} else if (lastRenderTime >time+0.02f) { centerSize-=1 ;}
        if( coords.size.x<coords.size.y ) centerSize = constrain( centerSize, 50, coords.size.x*zoom-10 );
        if( coords.size.x>coords.size.y ) centerSize = constrain( centerSize, 50, coords.size.y*zoom-10 );
        // set the renderZone position
        centerRectX = ( coords.size.x - centerSize/zoom )/2 ;
        centerRectY = ( coords.size.y - centerSize/zoom )/2 ;

        renderMin = createImage( PApplet.parseInt(centerSize), PApplet.parseInt(centerSize), ALPHA );
        renderMin.set( PApplet.parseInt(-centerRectX*zoom), PApplet.parseInt(-centerRectY*zoom), viewImg );
        // select a different thread each time (if available)
        offThread = (offThread+1) % viewZoneThread.length ;
        viewZoneThread[offThread].interrupt();
        viewZoneThread[offThread] = new ViewZoneThread( PApplet.parseInt(centerSize/zoom) );
        viewZoneThread[offThread].start();
        delay( PApplet.parseInt( constrain( (1000*time)/viewZoneThread.length, 0, 1000*time ) ) );
      }
      image(renderMinDone,  PApplet.parseInt(coords.pos.x +( coords.size.x - renderMinDone.width )/2), PApplet.parseInt(coords.pos.y +( coords.size.y - renderMinDone.height )/2) ) ;
    }
    if (updateViewPort) updateView(src);
    if (updateViewPort) updateViewPort = false ;
  }
  public void frameAnimation(){ // played during render-thread
    PImage img = createImage(dataAnimation.length, dataAnimation[0].length, ALPHA);
    writeImg(img, dataAnimation);
    img.resize( round( (viewZone.pos.x+viewZone.size.x < src.width )? coords.size.x : src.width /zoom ), 0 );
    thresholdImg(img);
    image(img, coords.pos.x, coords.pos.y);
    fill(150,70);
    if(!lastFrameAnimation) rect(coords.pos.x, coords.pos.y,img.width,img.height);
    lastFrameAnimation = false;
  }
}
class ViewZoneThread extends Thread{
    PImage imgRnd;
    int size;
    public ViewZoneThread ( int size ){
        this.size = size;
    }
    public void run(){
            renderMinDone = render(renderMin, size, "");
            // if(imgRnd != null ) renderMinDone = imgRnd;
            updateViewImg = true;
    }
}

public void renderViewThread(){
    ViewPort vp = ((ViewPort)gui.elements.get(0));
  PImage img = vp.viewImg.get() ;
  img = render(img, (int)  vp.coords.size.x*3, "animate" );
  img.resize(img.width/3,img.height/3);
  vp.viewImg = img.get();
  isRendering = false;
  vp.updateViewPort = true; updateViewImg = true;
  gui.message("Last render in "+ PApplet.parseInt(lastRenderTime) + " sec");
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Snap extends GuiElement {
  PImage snap;
  Rect delete;
  PImage delImg;

  Snap (Rect _coords, String _name) {
    super(_coords, _name);
    savedParams = new Parameters();
    delete = new Rect(coords.pos.x+b, coords.pos.y+b, 20, 20);
    delImg = loadImage("delete.png");
    update();

  }
  public boolean isSnaped(){ if( snap == null ){ return false; }else{ return true; } }
  public void pressed (){
    if( snap == null ) {  // save snap
      savedParams.loadParameters( params );

      snap = loadImage("gradient.png");
      snap.resize((int)coords.size.x,(int)coords.size.y);
      snap = render(snap,(int)coords.size.x*3, "quiet");
      snap.resize((int)coords.size.x,0);

      fill(C[25]); drawRect(coords);
      update();
    }

    if ( snap!=null  ) {
      if ( delete.isOver() ) { snap = null ; }
      else { // load snap
        params.loadParameters( savedParams );
        gui.update();
      }
    }
    viewing = true ;
  }
  public void update(){
    if ( snap == null ) {
      fill( isOver() ? C[20] : C[22] );
      drawRect(coords);
      fill( isOver()? C[10] : C[15] );
      if (flag.equals("beginAnimation")) text("begin animation", coords.pos.x+4, coords.pos.y + coords.size.y-4 );
      if (flag.equals("endAnimation"))   text("end animation",   coords.pos.x+4, coords.pos.y + coords.size.y-4 );
    } else {
      if ( !isOver() ) {
        fill(230); drawRect(coords);
        tint( 255, 80 );
        image(snap, coords.pos.x, coords.pos.y, snap.width, snap.height); noTint();
      } else {
        image(snap, coords.pos.x, coords.pos.y);
        fill( delete.isOver() ? C[12] : C[17] );
        drawRect(delete);
        image(delImg,coords.pos.x+b, coords.pos.y+b);
      }
      fill( C[22] );
      if (flag.equals("beginAnimation")||flag.equals("endAnimation")) rect( (int)coords.pos.x, (int)coords.pos.y + coords.size.y -15, (int)coords.size.x, 15 );
      fill( isOver()? C[10] : C[15] );
      if (flag.equals("beginAnimation")) text("begin animation", coords.pos.x+4, coords.pos.y + coords.size.y-4 );
      if (flag.equals("endAnimation"))   text("end animation",   coords.pos.x+4, coords.pos.y + coords.size.y-4 );
    }
    if( dropState ) { // drag & drop files indicator
      fill( colorActive,100 );
      rect( coords.pos.x, coords.pos.y, coords.size.x, coords.size.y );
    }
  }
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class BiSlider extends GuiElement {
  int m, sh=20;
  float pos1, pos2, pos3, zone;
  Rect handle[] = new Rect[3];
  PImage grad, gradInvert;
  String txt;
  BiSlider(Rect _coords, String _name, String _txt){
    super(_coords, _name);
    txt = _txt;
    grad = loadImage("gradient.png"); gradInvert = loadImage("gradInvert.png");
    update();
  }

  public void pressed (){
    if ( handle[0].isOver() ) { zone=1; pos1=mouseX; } // top
    if ( handle[1].isOver() ) { zone=2; pos2=mouseX; } // bottom
    if ( handle[2].isOver() ) { zone=3; pos3=mouseX; } // center
  }
  public void released (){
    if ( zone!=0 ) {
      gui.elements.get(9).updateMapImg();
    }
    zone = 0;
  }
  public void dragged () {
    if ( zone!=0 ) {
      m   = mouseX ;
      off = (control) ? 20 : 1 ;
      if ( zone==1 ) { // top
        params.b[ref] += (m-pos1)/off;    pos1=m;
        params.b[ref] = constrain(params.b[ref], 0, coords.size.x-10);
      }
      if ( zone==2 ) { // bottom
        params.w[ref] += (m-pos2)/off;  pos2=m;
        params.w[ref] = constrain(params.w[ref], 0, coords.size.x-10);
      }
      if ( zone==3 ) { // center
        params.b[ref] += (m-pos3)/off ;
        params.w[ref] += (m-pos3)/off ;
        params.b[ref] = constrain(params.b[ref], 0, coords.size.x-10);
        params.w[ref] = constrain(params.w[ref], 0, coords.size.x-10);
        pos3 = m;
      }
      update();
      viewing = true ;
    }
  }
  public void update(){
    float b = params.b[ref];
    float w = params.w[ref];
    handle[0] = new Rect( coords.pos.x+b-18, coords.pos.y+0,  36, sh-3 );
    handle[1] = new Rect( coords.pos.x+w-18, coords.pos.y+2*sh+3, 36, sh-3 );
    handle[2] = new Rect( coords.pos.x, coords.pos.y+sh+3, coords.size.x-10, sh-6 );
    fill(bg); rect(coords.pos.x-18,coords.pos.y,coords.size.x+26,3*sh);  //bg
    fill( (handle[2].isOver()||handle[1].isOver()||handle[0].isOver()) ? C[19] : C[20] ); drawRect(handle[2]); // bg bde

    fill( (handle[0].isOver() || handle[2].isOver())? colorActive : C[20]); drawRect(handle[0]); // top cursor
    fill( (handle[1].isOver() || handle[2].isOver())? colorActive : C[20]); drawRect(handle[1]); // bottom

    pushMatrix(); translate(coords.pos.x, coords.pos.y);
        fill( (handle[0].isOver() || handle[2].isOver())? colorActive : C[20]); triangle(b-18, sh-3, b+18, sh-3, b, sh+3); // top cursor
        fill( (handle[1].isOver() || handle[2].isOver())? colorActive : C[20]); triangle(w-18, 2*sh+3, w+18, 2*sh+3, w, 2*sh-3); // bottom
        fontColor(); text(txt, 0 , -2); textAlign(CENTER);
        fill( (handle[0].isOver() || handle[2].isOver())? 0 : C[0]); text(PApplet.parseInt(b), b, sh-3-3);
        fill( (handle[1].isOver() || handle[2].isOver())? 0 : C[0]); text(PApplet.parseInt(w), w, 3*sh-5);
        if(b<w) image(gradInvert, b, sh+3, w-b, sh-6);
        if(b>=w)image(grad,       w, sh+3, b-w, sh-6);
    popMatrix(); textAlign(LEFT);
  }
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class DiSlider extends GuiElement { // slider 2D
  Rect handle[] = new Rect[2];
  float pos1, pos2, pos3, pos11, pos22, pos33, zone ;
  float s, sh, x, y;
  PImage grad, gradInvert;

  DiSlider(Rect _coords, String _name){
    super(_coords, _name);
    x = coords.pos.x; y = coords.pos.y; s = coords.size.x; sh = coords.size.y;  // layout helpers
    mapImg = createImage(PApplet.parseInt(10), PApplet.parseInt(10), ARGB);
    grad = loadImage("gradient.png"); gradInvert = loadImage("gradInvert.png");
  }
  public void moved(){}
  public void pressed (){
    if ( coords.isOver() )    { zone=3; pos1=mouseX; pos11=mouseY; pos2=mouseX; pos22=mouseY; } // center
    if ( handle[0].isOver() ) { zone=1; pos1=mouseX; pos11=mouseY; } // top
    if ( handle[1].isOver() ) { zone=2; pos2=mouseX; pos22=mouseY; } // bottom
  }
  public void released () {
    zone = 0;
  }
  public void dragged () {
    if ( zone!=0 ) {
      float b5 = coords.size.x-params.b[1]; float w5 = coords.size.x-params.w[1];
      off = (control) ? 20 : 1 ;
      if ( zone==1 || zone==3 ) { // top black
        params.b[0] += (mouseX-pos1)/off;    pos1=mouseX;
        params.b[1] -= (mouseY-pos11)/off;   pos11=mouseY;
        params.b[0] = constrain(params.b[0], 0, coords.size.x-20);
        params.b[1] = constrain(params.b[1], 0, coords.size.x-20);
      }
      if ( zone==2 || zone==3 ) { // bottom white
        params.w[0] += (mouseX-pos2)/off;  pos2=mouseX;
        params.w[1] -= (mouseY-pos22)/off; pos22=mouseY;
        params.w[0] = constrain(params.w[0], 0, coords.size.x-20);
        params.w[1] = constrain(params.w[1], 0, coords.size.x-20);
      }
      update();
      viewing = true ;
    }
  }

  public void updateMapImg(){
    mapImg.filter(BLUR, 1.5f);
    thread("renderMapImg");
  }

  public void update () {
    if( frameCount%6==0 || isOver() ) {
      float b5 = s-params.b[1];
      float w5 = s-params.w[1];  // invert 0->200 to 200->0
      handle[0] = new Rect( x+params.b[0]-10, y + map(params.b[1],0,s,s,0)-10, 20, 20 );
      handle[1] = new Rect( x+params.w[0]-10, y + map(params.w[1],0,s,s,0)-10, 20, 20 );

      pushMatrix(); translate(x, y);
        fill(bg); rect(-40,-20,s+60,s+60 ); //bg
        fontColor(); text(name, -50 , 10);
        image(mapImg, 0,20,s-20,s-20);
        fill(240,180); rect(0,20,s-20,s-20);
        strokeWeight( (handle[0].isOver())? 8:5 ); stroke( (handle[0].isOver() || isOver()&&!handle[1].isOver() )? colorActive :C[20] ); ellipse(params.b[0], b5, 15, 15);  // top
        strokeWeight( (handle[1].isOver())? 8:5 ); stroke( (handle[1].isOver() || isOver()&&!handle[0].isOver() )? colorActive :C[20] ); ellipse(params.w[0], w5, 15, 15);  // bottom
        strokeWeight(1); noStroke();
        for (int i = 0; i<=50; i++){
          fill(255/50*i);
          ellipse(params.b[0]+i*(params.w[0]-params.b[0])/50, b5+i*(w5-b5)/50, 10,10);
        }
      popMatrix();
      updateSlider(0, x, y+s+5, s-10);
      updateSlider(1, x+s-15, y+s, s-10);
    }
  }
  public void updateSlider(int ref, float xx, float yy, float s){
    int sh=10 ;
    float b = params.b[ref]; float w = params.w[ref];
    pushMatrix(); translate(xx, yy);
    if(ref==1)rotate(-PI/2);
    fill(C[22]); rect(0,0,s-10,sh-6); // slider rect
    if ( abs(b-w)<36 ) {
      float mid = (b<w) ? b+(w-b)/2 : w+(b-w)/2 ;
      fill(C[20]);
      if (b<w) { triangle(mid, 12, mid-36, 12, b, sh-6); triangle(mid, 12, mid+36, 12, w, sh-6); }
      if (b>=w){ triangle(mid, 12, mid+36, 12, b, sh-6); triangle(mid, 12, mid-36, 12, w, sh-6); }
        rect(mid, 12, -36,15);
        rect(mid, 12,  36,15); // handle rect

        fontColor(); textAlign(CENTER);
      if(b<w){ text(PApplet.parseInt(b), mid-18, 2*sh+3); text(PApplet.parseInt(w), mid+18, 2*sh+2);
      } else { text(PApplet.parseInt(b), mid+18, 2*sh+3); text(PApplet.parseInt(w), mid-18, 2*sh+2); }
      if(b<w) image (gradInvert, b, 0, w-b, sh-6);
      if(b>=w)image (grad,       w, 0, b-w, sh-6);
    } else {
        fill(C[20]);
        triangle ( b-18, 12, b+18, 12, b, sh-6); // top
      triangle ( w-18, 12, w+18, 12, w, sh-6); // bottom
      rect ( b-18, 12, 36, 15 ); // handle rect
      rect ( w-18, 12, 36, 15 );
        fontColor(); textAlign(CENTER);
      text ( PApplet.parseInt(b), b, 22);
      text ( PApplet.parseInt(w), w, 22);
      if(b<w) image(gradInvert, b, 0, w-b, sh-6);
      if(b>=w)image(grad,       w, 0, b-w, sh-6);
    }
    popMatrix(); textAlign(LEFT);
  }
}

public void renderMapImg(){

    PImage mapImg = gui.elements.get(9).mapImg.get() ;
    float s = gui.elements.get(9).coords.size.x ;

    mapImg.resize( PApplet.parseInt((s-20)/1.6f),PApplet.parseInt((s-20)/1.6f) ) ;
    mapImg = algoReactionDiffusion(mapImg, "renderMapImg");
    mapImg.resize( PApplet.parseInt(s-20)*3, 0 );
    thresholdImg(mapImg);
    mapImg.resize( PApplet.parseInt(s-20), 0 );

    gui.elements.get(9).mapImg = mapImg;

}

class Parameters {
  float[] b = {0 ,0 ,0 ,0} ; // R&D black handle
  float[] w = {0 ,0 ,0 ,0} ; // R&D white handle
  int[]   o = {0, 0, 200} ; // iterations, threshold, resolution
  int iniState = 0 ;
  Parameters() {  }

  public void save(String _filePath){
    String[] saveData = new String[8];

    for (int i = 0; i<7; i++){
      if (i<4) saveData[i] = b[i]+" "+w[i] ;
      if (i>3) saveData[i] = o[i-4]+"" ;
    }
    saveData[7] = iniState+"";

    if ( match(_filePath, ".TexTuring") == null ) _filePath += ".TexTuring" ;
    saveStrings( _filePath, saveData) ;
  }

  public void loadFile( File _file ){ if(_file != null) load( loadStrings(_file.getAbsolutePath()) ); }
  public void saveFile( File _file ){ if(_file != null) save( _file.getAbsolutePath() ); }

  public void load( String[] _data ){
      print(_data.length );
      if ( _data.length == 8 ){
          for (int i = 0; i<4; i++) {
              String[] tmp = split(_data[i]," ");
              b[i] = PApplet.parseFloat( tmp[0] );
              w[i] = PApplet.parseFloat( tmp[1] );
          }
          o[0] = PApplet.parseInt(_data[4] );
          o[1] = PApplet.parseInt(_data[5] );
          o[2] = PApplet.parseInt(_data[6] );
          iniState = PApplet.parseInt(_data[7]) ;
          gui.update();
          updateViewImg = true;
      }
  }
  public void loadParameters( Parameters other ) {
    arrayCopy(other.b, b) ;
    arrayCopy(other.w, w) ;
    arrayCopy(other.o, o) ;
    iniState = other.iniState ;
  }
  public void nextFrameAnimation( int fraction, Parameters out){
    for (int i = 0; i<4; i++) {
      b[i] += ( out.b[i]-b[i] ) / fraction ;
      w[i] += ( out.w[i]-w[i] ) / fraction ;
    }
    o[0] += PApplet.parseInt( ( out.o[0]-o[0] ) / fraction ) ;
    o[1] += PApplet.parseInt( ( out.o[1]-o[1] ) / fraction ) ;
    o[2] += PApplet.parseInt( ( out.o[2]-o[2] ) / fraction ) ;
  }
}

class Vector2
{
  float x, y;
  Vector2(float _x, float _y) {
    x=_x;
    y=_y;
  }
  Vector2() {
    x=0;
    y=0;
  }
  Vector2(Vector2 other) {
    this(other.x, other.y);
  }
}

class Rect
{
  Vector2 pos;
  Vector2 size;
  Rect() {
    pos = new Vector2();
    size = new Vector2();
  }
  Rect(Rect other) {
   this(other.pos, other.size);
  }
  Rect(Vector2 _pos, Vector2 _size) {
    pos = new Vector2(_pos);
    size = new Vector2(_size);
  }
  Rect(float posX, float posY, float sizeX, float sizeY) {
    pos = new Vector2(posX, posY);
    size = new Vector2(sizeX, sizeY);
  }
  public boolean isOver() {
   return isOver(new Vector2(mouseX,mouseY));
  }
  public boolean isOver(float x, float y) {
   return isOver(new Vector2(x,y));
  }
  public boolean isOver(Vector2 in) {
    if (in.x >= pos.x && in.x <= pos.x+size.x && in.y >= pos.y && in.y <= pos.y+size.y) {
      return true ;
    } else {
      return false ;
    }
  }
}

/////////////////////////////////////////////////////////////////////////////////
public void initDrop(){
  drop = new SDrop(this);
  dropListener = new MyDropListener();
  drop.addDropListener(dropListener);
}

public void dropEvent(DropEvent event) {}

// a custom DropListener class.
class MyDropListener extends DropListener {

  int myColor;

  MyDropListener() {
    myColor = color(255);
    setTargetRect(20,20,width-40,height-40);
  }

  public void draw() {
    fill(myColor);
    rect(10,10,100,100);
  }
  public void dropEnter() {
    gui.elements.get(0).dropState = true;
    viewing = true;
  }
  public void dropLeave() {
    gui.elements.get(0).dropState = false;
    viewing = true;
  }

  public void dropEvent(DropEvent event) {
    if(event.isFile()) {
      if( event.isImage() )            fileSelected( event.file() );
      if( event.file().isDirectory() ) folderSelected( event.file() );
      if( event.file().getName().toLowerCase().indexOf("texturing") > -1 ) params.loadFile( event.file() );
    }
  }
}
/////////////////////////////////////////////////////////////////////////////////

public boolean isOver (float x, float y, float w, float h) {
  if (mouseX >= x && mouseX <= x+w && mouseY >= y && mouseY <= y+h) { return true ; }
  else { return false ; }
}

public boolean validImageFile(File file){
  boolean isValid = false ;
  String fileName = file.getName().toLowerCase();
  String[] ext = { ".gif", ".jpg", ".tga", ".png" };
  for (String o : ext) {
    if ( fileName.endsWith(o) )
      isValid = true;
  }
  return isValid ;
}


/////////////////////////////////////////////// url link (about)












public class SwingLink extends JLabel {
  private static final long serialVersionUID = 8273875024682878518L;
  private String text;
  private URI uri;

  public SwingLink(String text, URI uri){
    super();
    setup(text,uri);
  }

  public SwingLink(String text, String uri){
    super();
    setup(text,URI.create(uri));
  }

  public void setup(String t, URI u){
    text = t;
    uri = u;
    setText(text);
    setToolTipText(uri.toString());
    addMouseListener(new MouseAdapter() {
      public void mouseClicked(MouseEvent e) {
        open(uri);
      }
      public void mouseEntered(MouseEvent e) {
        setText(text,false);
        setCursor(new Cursor(Cursor.HAND_CURSOR));
      }
      public void mouseExited(MouseEvent e) {
        setText(text,true);
      }
    });
  }

  @Override
  public void setText(String text){
    setText(text,true);
  }

  public void setText(String text, boolean ul){
    String link = ul ? "<u>"+text+"</u>" : text;
    super.setText("<html><span style=\"color: #000099;\">"+
    link+"</span></html>");
    this.text = text;
  }

  public String getRawText(){
    return text;
  }

  private void open(URI uri) {
    if (Desktop.isDesktopSupported()) {
      Desktop desktop = Desktop.getDesktop();
      try {
        desktop.browse(uri);
      } catch (IOException e) {
        JOptionPane.showMessageDialog(null,
            "Failed to launch the link, your computer is likely misconfigured.",
            "Cannot Launch Link",JOptionPane.WARNING_MESSAGE);
      }
    } else {
      JOptionPane.showMessageDialog(null,
          "Java is not able to launch links on your computer.",
          "Cannot Launch Link", JOptionPane.WARNING_MESSAGE);
    }
  }
}









public void vectorization( PImage img, String fileName, int format){
    PGraphics vecto = null;
    if (format==1) vecto = createGraphics( img.width/3, img.height/3, PDF, fileName );
    if (format==2) vecto = createGraphics( img.width/3, img.height/3, SVG, fileName );
    vecto.beginDraw();
    vecto.background(255);
    vecto.noStroke();
    vecto.fill(0);


    SimpleGray gray = Boof.gray(img,ImageDataType.F32); // Convert the image into a simplified BoofCV data type
    ResultsBlob results = gray.threshold(params.o[1],true).contour();

    for( Contour contour : results.contour) {
        vecto.beginShape();

            drawBlob( vecto, contour.external, 4 );

            for( List<Point2D_I32> pts : contour.internal){
                vecto.beginContour();
                drawBlob(vecto, pts, 4 );
                vecto.endContour();
            }

        vecto.endShape(CLOSE);
    }
    vecto.dispose();
    vecto.endDraw();
}

public void drawBlob(PGraphics vecto, List<Point2D_I32> points32, int minimumBlobPoints  ) {

    if ( points32.size() > minimumBlobPoints ){ // delete small blobs
        List<PVector> points = new ArrayList<PVector>();
        for( Point2D_I32 p : points32 ) points.add(new PVector(p.x, p.y) );

        points = smoothLine( points, 5 ); // int == smoothness lvl

        vecto.vertex( points.get(0).x/3, points.get(0).y/3 );
        vecto.curveVertex( points.get(points.size()-1).x/3, points.get(points.size()-1).y/3 );
        for ( int i = 0 ; i < points.size() ; i+=4 )
        vecto.curveVertex( points.get(i).x/3, points.get(i).y/3 );
        vecto.curveVertex( points.get(0).x/3, points.get(0).y/3 );
        vecto.curveVertex( points.get(1).x/3, points.get(1).y/3 );
    }
}

public List<PVector> smoothLine(List<PVector> points, int pointsAdjacents) {
    int p = pointsAdjacents;
    if(points.size() < p*2) return points;

    List<PVector> smoothedPoints = new ArrayList<PVector>();

    for(int i = 0; i < points.size(); i++) {
        List<PVector> tmp = new ArrayList<PVector>();
        for( int j=p; j>=1; j-- ) tmp.add(points.get( (i-j<0)? points.size()+i-j : i-j) );
        tmp.add(points.get(i));
        for( int j=1; j<=p; j++ ) tmp.add(points.get( (i+j>=points.size())? (i+j)-points.size() : i+j) );
        smoothedPoints.add( smoothPoint(tmp) );
    }
    return smoothedPoints;
}


public  PVector smoothPoint(List<PVector> points) {
    float avgX = 0;
    float avgY = 0;
    for(PVector point : points) {
        avgX += point.x;
        avgY += point.y;
    }
    avgX = avgX/points.size();
    avgY = avgY/points.size();

    return new PVector(avgX, avgY);
}
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "TexTuring" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
