/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.alg.misc.ImageStatistics;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import java.util.Random;
import processing.core.PImage;

public class VisualizeProcessing {
    public static PImage labeled(GrayS32 image) {
        int numRegions = ImageStatistics.max((GrayS32)image) + 1;
        int[] colors = new int[numRegions];
        Random rand = new Random(123L);
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = rand.nextInt() | 0xFF000000;
        }
        colors[0] = -16777216;
        return VisualizeProcessing.labeled(image, colors);
    }

    public static PImage colorizeSign(GrayF32 src, float maxAbsValue) {
        PImage out = new PImage(src.width, src.height, 1);
        int indexOut = 0;
        for (int y = 0; y < src.height; ++y) {
            int x = 0;
            while (x < src.width) {
                float v = src.get(x, y);
                int rgb = v > 0.0f ? (int)(255.0f * v / maxAbsValue) << 16 : (int)(-255.0f * v / maxAbsValue) << 8;
                out.pixels[indexOut] = rgb;
                ++x;
                ++indexOut;
            }
        }
        return out;
    }

    public static PImage colorizeSign(GrayI src, int maxAbsValue) {
        PImage out = new PImage(src.width, src.height, 1);
        int indexOut = 0;
        for (int y = 0; y < src.height; ++y) {
            int x = 0;
            while (x < src.width) {
                int v = src.get(x, y);
                int rgb = v > 0 ? 255 * v / maxAbsValue << 16 : -255 * v / maxAbsValue << 8;
                out.pixels[indexOut] = rgb;
                ++x;
                ++indexOut;
            }
        }
        return out;
    }

    public static PImage labeled(GrayS32 image, int[] colors) {
        PImage out = new PImage(image.width, image.height, 1);
        int indexOut = 0;
        for (int y = 0; y < image.height; ++y) {
            int indexImage = image.startIndex + image.stride * y;
            int x = 0;
            while (x < image.width) {
                out.pixels[indexOut] = colors[image.data[indexImage]];
                ++x;
                ++indexImage;
                ++indexOut;
            }
        }
        return out;
    }

    public static PImage gradient(GrayF32 dx, GrayF32 dy) {
        PImage out = new PImage(dx.width, dx.height, 1);
        float maxAbsValue = ImageStatistics.maxAbs((GrayF32)dx);
        if ((maxAbsValue = Math.max(maxAbsValue, ImageStatistics.maxAbs((GrayF32)dy))) == 0.0f) {
            return out;
        }
        int indexOut = 0;
        for (int y = 0; y < dx.height; ++y) {
            int indexX = dx.startIndex + dx.stride * y;
            int indexY = dy.startIndex + dy.stride * y;
            int x = 0;
            while (x < dy.width) {
                float valueX = dx.data[indexX];
                float valueY = dy.data[indexY];
                int r = 0;
                int g = 0;
                int b = 0;
                if (valueX > 0.0f) {
                    r = (int)(255.0f * valueX / maxAbsValue);
                } else {
                    g = (int)(-255.0f * valueX / maxAbsValue);
                }
                if (valueY > 0.0f) {
                    b = (int)(255.0f * valueY / maxAbsValue);
                } else {
                    int v = (int)(-255.0f * valueY / maxAbsValue);
                    g += v;
                    if ((r += v) > 255) {
                        r = 255;
                    }
                    if (g > 255) {
                        g = 255;
                    }
                }
                out.pixels[indexOut] = 0xFF000000 | r << 16 | g << 8 | b;
                ++x;
                ++indexX;
                ++indexY;
                ++indexOut;
            }
        }
        return out;
    }

    public static PImage gradient(GrayS16 dx, GrayS16 dy) {
        PImage out = new PImage(dx.width, dx.height, 1);
        int maxAbsValue = ImageStatistics.maxAbs((GrayS16)dx);
        if ((maxAbsValue = Math.max(maxAbsValue, ImageStatistics.maxAbs((GrayS16)dy))) == 0) {
            return out;
        }
        int indexOut = 0;
        for (int y = 0; y < dx.height; ++y) {
            int indexX = dx.startIndex + dx.stride * y;
            int indexY = dy.startIndex + dy.stride * y;
            int x = 0;
            while (x < dy.width) {
                short valueX = dx.data[indexX];
                short valueY = dy.data[indexY];
                int r = 0;
                int g = 0;
                int b = 0;
                if (valueX > 0) {
                    r = 255 * valueX / maxAbsValue;
                } else {
                    g = -255 * valueX / maxAbsValue;
                }
                if (valueY > 0) {
                    b = 255 * valueY / maxAbsValue;
                } else {
                    int v = -255 * valueY / maxAbsValue;
                    g += v;
                    if ((r += v) > 255) {
                        r = 255;
                    }
                    if (g > 255) {
                        g = 255;
                    }
                }
                out.pixels[indexOut] = 0xFF000000 | r << 16 | g << 8 | b;
                ++x;
                ++indexX;
                ++indexY;
                ++indexOut;
            }
        }
        return out;
    }

    public static PImage denseFlow(ImageFlow flowImage) {
        float maxValue = 0.0f;
        int N = flowImage.width * flowImage.height;
        for (int i = 0; i < N; ++i) {
            ImageFlow.D f = flowImage.data[i];
            float v = Math.max(Math.abs(f.x), Math.abs(f.y));
            if (!(v > maxValue)) continue;
            maxValue = v;
        }
        return VisualizeProcessing.denseFlow(flowImage, maxValue);
    }

    public static PImage denseFlow(ImageFlow flowImage, float maxValue) {
        PImage out = new PImage(flowImage.width, flowImage.height, 1);
        int[] tableSine = new int[360];
        int[] tableCosine = new int[360];
        for (int i = 0; i < 360; ++i) {
            double angle = (double)i * Math.PI / 180.0;
            tableSine[i] = (int)(255.0 * (Math.sin(angle) + 1.0) / 2.0);
            tableCosine[i] = (int)(255.0 * (Math.cos(angle) + 1.0) / 2.0);
        }
        int N = flowImage.width * flowImage.height;
        for (int i = 0; i < N; ++i) {
            ImageFlow.D f = flowImage.data[i];
            if (!f.isValid()) {
                out.pixels[i] = -16777131;
                continue;
            }
            float m = Math.max(Math.abs(f.x), Math.abs(f.y)) / maxValue;
            if (m > 1.0f) {
                m = 1.0f;
            }
            double angle = Math.atan2(f.y, f.x);
            int degree = (int)(180.0 + angle * 179.999 / Math.PI);
            int r = (int)(m * (float)tableSine[degree]);
            int g = (int)(m * (float)tableCosine[degree]);
            out.pixels[i] = 0xFF000000 | r << 16 | g << 8;
        }
        return out;
    }
}

