/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.processing.ConvertProcessing;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import processing.core.PImage;

public class SimpleTrackerPoints {
    PointTracker tracker;
    List<PointTrack> list = new ArrayList<PointTrack>();
    Class imageType;
    ImageGray gray;

    public SimpleTrackerPoints(PointTracker tracker, Class imageType) {
        this.tracker = tracker;
        this.imageType = imageType;
        this.gray = GeneralizedImageOps.createSingleBand((Class)imageType, (int)1, (int)1);
    }

    public void process(PImage image) {
        this.gray.reshape(image.width, image.height);
        if (this.imageType == GrayF32.class) {
            ConvertProcessing.convert_RGB_F32(image, (GrayF32)this.gray);
        } else if (this.imageType == GrayU8.class) {
            ConvertProcessing.convert_RGB_U8(image, (GrayU8)this.gray);
        }
        this.tracker.process((ImageBase)this.gray);
        this.list.clear();
        this.tracker.getActiveTracks(this.list);
    }

    public void spawnTracks() {
        this.tracker.spawnTracks();
        this.list.clear();
        this.tracker.getActiveTracks(this.list);
    }

    void reset() {
        this.tracker.reset();
    }

    public int totalTracks() {
        return this.list.size();
    }

    public Point2D_F64 getLocation(int index) {
        return this.list.get((int)index).pixel;
    }

    public long getTrackID(int index) {
        return this.list.get((int)index).featureId;
    }

    public int getTrackAge(int index) {
        return (int)(this.tracker.getFrameID() - this.list.get((int)index).spawnFrameID);
    }

    public boolean dropTrack(int index) {
        return this.tracker.dropTrack(this.list.get(index));
    }
}

