/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.processing.ConvertProcessing;
import boofcv.struct.image.ImageBase;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import georegression.struct.shapes.Rectangle2D_F64;
import processing.core.PImage;

public class SimpleTrackerObject {
    TrackerObjectQuad tracker;
    ImageBase boofImage;
    Quadrilateral_F64 location = new Quadrilateral_F64();
    Rectangle2D_F64 locationR = new Rectangle2D_F64();

    public SimpleTrackerObject(TrackerObjectQuad tracker) {
        this.tracker = tracker;
        this.boofImage = tracker.getImageType().createImage(1, 1);
    }

    public boolean initialize(PImage image, Quadrilateral_F64 initialLocation) {
        this.boofImage.reshape(image.width, image.height);
        ConvertProcessing.convertFromRGB(image, this.boofImage);
        return this.tracker.initialize(this.boofImage, initialLocation);
    }

    public boolean initialize(PImage image, double x0, double y0, double x1, double y1) {
        Quadrilateral_F64 q = new Quadrilateral_F64();
        q.a.set(x0, y0);
        q.b.set(x1, y0);
        q.c.set(x1, y1);
        q.d.set(x0, y1);
        return this.initialize(image, q);
    }

    public boolean process(PImage image) {
        ConvertProcessing.convertFromRGB(image, this.boofImage);
        return this.tracker.process(this.boofImage, this.location);
    }

    public Quadrilateral_F64 getLocation() {
        return this.location;
    }

    public Rectangle2D_F64 getLocationR() {
        UtilPolygons2D_F64.bounding((Quadrilateral_F64)this.location, (Rectangle2D_F64)this.locationR);
        return this.locationR;
    }
}

