/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.alg.feature.detect.template.TemplateMatching;
import boofcv.processing.ConvertProcessing;
import boofcv.processing.SimpleBinary;
import boofcv.struct.feature.Match;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import processing.core.PImage;

public class SimpleTemplateMatching {
    TemplateMatching<GrayU8> matcher;
    GrayU8 ginput = new GrayU8(1, 1);
    GrayU8 gtemplate = new GrayU8(1, 1);

    public SimpleTemplateMatching(TemplateMatching<GrayU8> matcher) {
        this.matcher = matcher;
    }

    public void setInput(PImage input) {
        ConvertProcessing.convertFromRGB(input, (ImageBase)this.ginput);
        this.matcher.setImage((ImageBase)this.ginput);
    }

    public List<Match> detect(PImage template, int maxMatches) {
        ConvertProcessing.convertFromRGB(template, (ImageBase)this.gtemplate);
        this.matcher.setTemplate((ImageBase)this.gtemplate, null, maxMatches);
        return this.extractResults();
    }

    public List<Match> detect(PImage template, SimpleBinary mask, int maxMatches) {
        ConvertProcessing.convert_RGB_U8(template, this.gtemplate);
        this.matcher.setTemplate((ImageBase)this.gtemplate, (ImageBase)mask.image, maxMatches);
        return this.extractResults();
    }

    private List<Match> extractResults() {
        this.matcher.process();
        List matches = this.matcher.getResults().toList();
        ArrayList<Match> output = new ArrayList<Match>();
        for (int i = 0; i < matches.size(); ++i) {
            Match orig = (Match)matches.get(i);
            Match copy = new Match();
            copy.set((Point2D_I32)orig);
            copy.score = orig.score;
            output.add(copy);
        }
        return output;
    }
}

