/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.abst.fiducial.QrCodeDetector;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeEncoder;
import boofcv.alg.fiducial.qrcode.QrCodeGeneratorImage;
import boofcv.factory.fiducial.ConfigQrCode;
import boofcv.factory.fiducial.FactoryFiducial;
import boofcv.processing.ConvertProcessing;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import java.util.List;
import processing.core.PImage;

public class SimpleQrCode {
    GrayU8 gray = new GrayU8(1, 1);
    QrCodeDetector<GrayU8> detector;

    public static PImage generate(String message, int pixelsPerModule) {
        QrCode qr = new QrCodeEncoder().setError(QrCode.ErrorLevel.M).addAutomatic(message).fixate();
        QrCodeGeneratorImage render = new QrCodeGeneratorImage(pixelsPerModule);
        render.render(qr);
        GrayU8 rendered = render.getGray();
        PImage output = new PImage(rendered.width, rendered.height);
        ConvertProcessing.convert_U8_RGB(rendered, output);
        return output;
    }

    public SimpleQrCode(ConfigQrCode config) {
        this.detector = FactoryFiducial.qrcode((ConfigQrCode)config, GrayU8.class);
    }

    public SimpleQrCode() {
        this(null);
    }

    public List<QrCode> detect(PImage input) {
        this.gray.reshape(input.width, input.height);
        ConvertProcessing.convertFromRGB(input, (ImageBase)this.gray);
        this.detector.process((ImageGray)this.gray);
        return this.detector.getDetections();
    }
}

