/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.alg.background.BackgroundModelStationary;
import boofcv.factory.background.ConfigBackgroundBasic;
import boofcv.factory.background.ConfigBackgroundGmm;
import boofcv.factory.background.FactoryBackgroundModel;
import boofcv.processing.ConvertProcessing;
import boofcv.processing.SimpleBinary;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import processing.core.PImage;

public class SimpleMotionDetection {
    GrayU8 gray = new GrayU8(1, 1);
    SimpleBinary segmented = new SimpleBinary(new GrayU8(1, 1));
    BackgroundModelStationary<GrayU8> background;

    public SimpleMotionDetection(ConfigBackgroundGmm config) {
        this.background = FactoryBackgroundModel.stationaryGmm((ConfigBackgroundGmm)config, (ImageType)ImageType.single(GrayU8.class));
    }

    public SimpleMotionDetection(ConfigBackgroundBasic config) {
        this.background = FactoryBackgroundModel.stationaryBasic((ConfigBackgroundBasic)config, (ImageType)ImageType.single(GrayU8.class));
    }

    public SimpleBinary segment(PImage input) {
        this.gray.reshape(input.width, input.height);
        this.segmented.image.reshape(input.width, input.height);
        ConvertProcessing.convertFromRGB(input, (ImageBase)this.gray);
        this.background.updateBackground((ImageBase)this.gray);
        this.background.segment((ImageBase)this.gray, this.segmented.image);
        return this.segmented;
    }
}

