/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.abst.segmentation.ImageSuperpixels;
import boofcv.processing.ConvertProcessing;
import boofcv.processing.SimpleImage;
import boofcv.processing.SimpleLabeledImage;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import processing.core.PImage;

public class SimpleImageSegmentation {
    ImageBase image;
    SimpleLabeledImage output = new SimpleLabeledImage(new GrayS32(1, 1));
    ImageSuperpixels segmentation;

    public SimpleImageSegmentation(ImageSuperpixels segmentation) {
        this.segmentation = segmentation;
        this.image = segmentation.getImageType().createImage(1, 1);
    }

    public void segment(PImage input) {
        ConvertProcessing.convertFromRGB(input, this.image);
        this.segmentation.segment(this.image, (GrayS32)this.output.getImage());
    }

    public void segment(SimpleImage input) {
        ((GrayS32)this.output.getImage()).reshape(((ImageBase)input.image).width, ((ImageBase)input.image).height);
        this.segmentation.segment(input.getImage(), (GrayS32)this.output.getImage());
    }

    public SimpleLabeledImage getOutput() {
        return this.output;
    }

    public int getTotalSegments() {
        return this.segmentation.getTotalSuperpixels();
    }

    public ConnectRule getRule() {
        return this.segmentation.getRule();
    }
}

