/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.abst.distort.FDistort;
import boofcv.abst.feature.detect.line.DetectLine;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.enhance.EnhanceImageOps;
import boofcv.alg.enhance.GEnhanceImageOps;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.misc.GImageStatistics;
import boofcv.alg.misc.ImageStatistics;
import boofcv.core.image.GConvertImage;
import boofcv.factory.feature.detect.line.ConfigHoughFootSubimage;
import boofcv.factory.feature.detect.line.ConfigHoughGradient;
import boofcv.factory.feature.detect.line.ConfigParamFoot;
import boofcv.factory.feature.detect.line.ConfigParamPolar;
import boofcv.factory.feature.detect.line.FactoryDetectLine;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.processing.ConvertProcessing;
import boofcv.processing.SimpleBinary;
import boofcv.processing.SimpleGradient;
import boofcv.processing.SimpleImage;
import boofcv.processing.VisualizeProcessing;
import boofcv.struct.ConfigLength;
import boofcv.struct.border.BorderType;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrixRMaj;
import org.ejml.ops.ConvertMatrixData;
import processing.core.PImage;

public class SimpleGray<Gray extends ImageGray<Gray>>
extends SimpleImage<Gray> {
    public SimpleGray(Gray image) {
        super(image);
    }

    public SimpleGray blurMean(int radius) {
        return new SimpleGray<ImageGray>((ImageGray)GBlurImageOps.mean((ImageBase)((ImageGray)this.image), null, (int)radius, null, null));
    }

    public SimpleGray blurMedian(int radius) {
        return new SimpleGray<ImageGray>((ImageGray)GBlurImageOps.median((ImageBase)((ImageGray)this.image), null, (int)radius, null));
    }

    public SimpleGray histogramEqualize() {
        if (!(this.image instanceof GrayU8)) {
            throw new RuntimeException("Image must be of type GrayU8 to adjust its histogram");
        }
        GrayU8 adjusted = new GrayU8(((ImageGray)this.image).width, ((ImageGray)this.image).height);
        int[] histogram = new int[256];
        int[] transform = new int[256];
        ImageStatistics.histogram((GrayU8)((GrayU8)this.image), (int)0, (int[])histogram);
        EnhanceImageOps.equalize((int[])histogram, (int[])transform);
        EnhanceImageOps.applyTransform((GrayU8)((GrayU8)this.image), (int[])transform, (GrayU8)adjusted);
        return new SimpleGray<GrayU8>(adjusted);
    }

    public SimpleGray histogramEqualizeLocal(int radius) {
        if (!(this.image instanceof GrayU8)) {
            throw new RuntimeException("Image must be of type GrayU8 to adjust its histogram");
        }
        GrayU8 adjusted = new GrayU8(((ImageGray)this.image).width, ((ImageGray)this.image).height);
        EnhanceImageOps.equalizeLocal((GrayU8)((GrayU8)this.image), (int)radius, (GrayU8)adjusted, (int)256, null);
        return new SimpleGray<GrayU8>(adjusted);
    }

    public SimpleGray enhanceSharpen4() {
        if (!(this.image instanceof GrayU8)) {
            throw new RuntimeException("Image must be of type GrayU8 to adjust its histogram");
        }
        ImageGray adjusted = (ImageGray)((ImageGray)this.image).createNew(((ImageGray)this.image).width, ((ImageGray)this.image).height);
        GEnhanceImageOps.sharpen4((ImageBase)((ImageGray)this.image), (ImageBase)adjusted);
        return new SimpleGray<ImageGray>(adjusted);
    }

    public SimpleGray enhanceSharpen8() {
        if (!(this.image instanceof GrayU8)) {
            throw new RuntimeException("Image must be of type GrayU8 to adjust its histogram");
        }
        ImageGray adjusted = (ImageGray)((ImageGray)this.image).createNew(((ImageGray)this.image).width, ((ImageGray)this.image).height);
        GEnhanceImageOps.sharpen8((ImageBase)((ImageGray)this.image), (ImageBase)adjusted);
        return new SimpleGray<ImageGray>(adjusted);
    }

    public List<LineParametric2D_F32> linesHoughPolar(ConfigHoughGradient configHough, ConfigParamPolar configPolar) {
        Class<?> inputType = ((ImageGray)this.image).getClass();
        Class derivType = GImageDerivativeOps.getDerivativeType(inputType);
        DetectLine detector = FactoryDetectLine.houghLinePolar((ConfigHoughGradient)configHough, (ConfigParamPolar)configPolar, (Class)derivType);
        return detector.detect((ImageGray)this.image);
    }

    public List<LineParametric2D_F32> linesHoughFoot(ConfigHoughGradient configHough, ConfigParamFoot configFoot) {
        Class<?> inputType = ((ImageGray)this.image).getClass();
        Class derivType = GImageDerivativeOps.getDerivativeType(inputType);
        DetectLine detector = FactoryDetectLine.houghLineFoot((ConfigHoughGradient)configHough, (ConfigParamFoot)configFoot, (Class)derivType);
        return detector.detect((ImageGray)this.image);
    }

    public List<LineParametric2D_F32> linesHoughFootSub(ConfigHoughFootSubimage configFoot) {
        Class<?> inputType = ((ImageGray)this.image).getClass();
        Class derivType = GImageDerivativeOps.getDerivativeType(inputType);
        DetectLine detector = FactoryDetectLine.houghLineFootSub((ConfigHoughFootSubimage)configFoot, (Class)derivType);
        return detector.detect((ImageGray)this.image);
    }

    public SimpleGray removePerspective(int outWidth, int outHeight, double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        ImageGray output = (ImageGray)((ImageGray)this.image).createNew(outWidth, outHeight);
        Estimate1ofEpipolar computeHomography = FactoryMultiView.homographyDLT((boolean)true);
        ArrayList<AssociatedPair> associatedPairs = new ArrayList<AssociatedPair>();
        associatedPairs.add(new AssociatedPair(new Point2D_F64(0.0, 0.0), new Point2D_F64(x0, y0)));
        associatedPairs.add(new AssociatedPair(new Point2D_F64((double)(outWidth - 1), 0.0), new Point2D_F64(x1, y1)));
        associatedPairs.add(new AssociatedPair(new Point2D_F64((double)(outWidth - 1), (double)(outHeight - 1)), new Point2D_F64(x2, y2)));
        associatedPairs.add(new AssociatedPair(new Point2D_F64(0.0, (double)(outHeight - 1)), new Point2D_F64(x3, y3)));
        DMatrixRMaj H = new DMatrixRMaj(3, 3);
        computeHomography.process(associatedPairs, (Object)H);
        FMatrixRMaj H32 = new FMatrixRMaj(3, 3);
        ConvertMatrixData.convert((DMatrixRMaj)H, (FMatrixRMaj)H32);
        PointTransformHomography_F32 homography = new PointTransformHomography_F32(H32);
        new FDistort(this.image, (ImageBase)output).transform((PixelTransform)new PointToPixelTransform_F32((Point2Transform2_F32)homography)).border(BorderType.SKIP).apply();
        return new SimpleGray<ImageGray>(output);
    }

    public SimpleGray blurGaussian(double sigma, int radius) {
        return new SimpleGray<ImageGray>((ImageGray)GBlurImageOps.gaussian((ImageBase)((ImageGray)this.image), null, (double)sigma, (int)radius, null));
    }

    public SimpleBinary threshold(double threshold, boolean down) {
        return new SimpleBinary(GThresholdImageOps.threshold((ImageGray)((ImageGray)this.image), null, (double)threshold, (boolean)down));
    }

    public SimpleBinary thresholdOtsu(boolean down) {
        double threshold = GThresholdImageOps.computeOtsu((ImageGray)((ImageGray)this.image), (double)0.0, (double)255.0);
        return new SimpleBinary(GThresholdImageOps.threshold((ImageGray)((ImageGray)this.image), null, (double)threshold, (boolean)down));
    }

    public SimpleBinary thresholdEntropy(boolean down) {
        double threshold = GThresholdImageOps.computeEntropy((ImageGray)((ImageGray)this.image), (double)0.0, (double)255.0);
        return new SimpleBinary(GThresholdImageOps.threshold((ImageGray)((ImageGray)this.image), null, (double)threshold, (boolean)down));
    }

    public SimpleBinary thresholdMean(int width, double bias, boolean down) {
        ConfigLength config = new ConfigLength();
        config.length = width;
        return new SimpleBinary(GThresholdImageOps.localMean((ImageGray)((ImageGray)this.image), null, (ConfigLength)config, (double)bias, (boolean)down, null, null, null));
    }

    public SimpleBinary thresholdGaussian(int Width, double bias, boolean down) {
        ConfigLength config = new ConfigLength();
        config.length = Width;
        return new SimpleBinary(GThresholdImageOps.localGaussian((ImageGray)((ImageGray)this.image), null, (ConfigLength)config, (double)bias, (boolean)down, null, null));
    }

    public SimpleBinary thresholdSauvola(int width, double k, boolean down) {
        ConfigLength config = new ConfigLength();
        config.length = width;
        return new SimpleBinary(GThresholdImageOps.localSauvola((ImageGray)((ImageGray)this.image), null, (ConfigLength)config, (float)((float)k), (boolean)down));
    }

    public SimpleBinary thresholdNick(int width, double k, boolean down) {
        ConfigLength config = new ConfigLength();
        config.length = width;
        return new SimpleBinary(GThresholdImageOps.localNick((ImageGray)((ImageGray)this.image), null, (ConfigLength)config, (float)((float)k), (boolean)down));
    }

    public SimpleBinary thresholdBlockMean(int width, double scale, boolean down) {
        ConfigLength config = new ConfigLength();
        config.length = width;
        return new SimpleBinary(GThresholdImageOps.blockMean((ImageGray)((ImageGray)this.image), null, (ConfigLength)config, (double)scale, (boolean)down));
    }

    public SimpleBinary thresholdBlockMinMax(int width, double scale, boolean down, double textureThreshold) {
        ConfigLength config = new ConfigLength();
        config.length = width;
        return new SimpleBinary(GThresholdImageOps.blockMinMax((ImageGray)((ImageGray)this.image), null, (ConfigLength)config, (double)scale, (boolean)down, (double)textureThreshold));
    }

    public SimpleBinary thresholdBlockOtsu(int width, double scale, boolean down) {
        ConfigLength config = new ConfigLength();
        config.length = width;
        return new SimpleBinary(GThresholdImageOps.blockOtsu((ImageGray)((ImageGray)this.image), null, (boolean)false, (ConfigLength)config, (double)0.0, (double)scale, (boolean)down));
    }

    public SimpleGradient gradientSobel() {
        return this.gradient(FactoryDerivative.sobel(((ImageGray)this.image).getClass(), null));
    }

    public SimpleGradient gradientPrewitt() {
        return this.gradient(FactoryDerivative.prewitt(((ImageGray)this.image).getClass(), null));
    }

    public SimpleGradient gradientThree() {
        return this.gradient(FactoryDerivative.three(((ImageGray)this.image).getClass(), null));
    }

    public SimpleGradient gradientTwo0() {
        return this.gradient(FactoryDerivative.two0(((ImageGray)this.image).getClass(), null));
    }

    public SimpleGradient gradientTwo1() {
        return this.gradient(FactoryDerivative.two1(((ImageGray)this.image).getClass(), null));
    }

    public double mean() {
        return GImageStatistics.mean((ImageBase)this.image);
    }

    public double max() {
        return GImageStatistics.max((ImageBase)this.image);
    }

    public double maxAbs() {
        return GImageStatistics.maxAbs((ImageBase)this.image);
    }

    public double sum() {
        return GImageStatistics.sum((ImageBase)this.image);
    }

    private SimpleGradient gradient(ImageGradient gradient) {
        SimpleGradient ret = new SimpleGradient(gradient.getDerivativeType(), ((ImageGray)this.image).width, ((ImageGray)this.image).height);
        gradient.process(this.image, ret.dx, ret.dy);
        return ret;
    }

    public PImage visualizeSign() {
        if (this.image instanceof GrayF32) {
            float max = ImageStatistics.maxAbs((GrayF32)((GrayF32)this.image));
            return VisualizeProcessing.colorizeSign((GrayF32)this.image, max);
        }
        if (this.image instanceof GrayI) {
            int max = (int)GImageStatistics.maxAbs((ImageBase)this.image);
            return VisualizeProcessing.colorizeSign((GrayI)this.image, max);
        }
        throw new RuntimeException("Unknown image type");
    }

    public PImage convert() {
        PImage out = new PImage(((ImageGray)this.image).width, ((ImageGray)this.image).height, 1);
        if (this.image instanceof GrayF32) {
            ConvertProcessing.convert_F32_RGB((GrayF32)this.image, out);
        } else if (this.image instanceof GrayU8) {
            ConvertProcessing.convert_U8_RGB((GrayU8)this.image, out);
        } else {
            throw new RuntimeException("Unknown image type");
        }
        return out;
    }

    public void convertToF32() {
        if (this.image instanceof GrayF32) {
            return;
        }
        GrayF32 a = new GrayF32(((ImageGray)this.image).width, ((ImageGray)this.image).height);
        GConvertImage.convert((ImageBase)this.image, (ImageBase)a);
        this.image = a;
    }

    public void convertToU8() {
        if (this.image instanceof GrayU8) {
            return;
        }
        GrayU8 a = new GrayU8(((ImageGray)this.image).width, ((ImageGray)this.image).height);
        GConvertImage.convert((ImageBase)this.image, (ImageBase)a);
        this.image = a;
    }
}

