/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.alg.feature.detect.edge.GGradientToEdgeFeatures;
import boofcv.processing.SimpleGray;
import boofcv.processing.VisualizeProcessing;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import processing.core.PImage;

public class SimpleGradient<T extends ImageBase> {
    public T dx;
    public T dy;

    public SimpleGradient(ImageType<T> imageType, int width, int height) {
        this.dx = imageType.createImage(width, height);
        this.dy = imageType.createImage(width, height);
    }

    public SimpleGradient(T dx, T dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public SimpleGray intensityAbs() {
        GrayF32 intensity = new GrayF32(((ImageBase)this.dx).width, ((ImageBase)this.dx).height);
        if (!(this.dx instanceof ImageGray)) {
            throw new RuntimeException("Unknown image type");
        }
        GGradientToEdgeFeatures.intensityAbs((ImageGray)((ImageGray)this.dx), (ImageGray)((ImageGray)this.dy), (GrayF32)intensity);
        return new SimpleGray<GrayF32>(intensity);
    }

    public SimpleGray intensityE() {
        GrayF32 intensity = new GrayF32(((ImageBase)this.dx).width, ((ImageBase)this.dx).height);
        if (!(this.dx instanceof ImageGray)) {
            throw new RuntimeException("Unknown image type");
        }
        GGradientToEdgeFeatures.intensityE((ImageGray)((ImageGray)this.dx), (ImageGray)((ImageGray)this.dy), (GrayF32)intensity);
        return new SimpleGray<GrayF32>(intensity);
    }

    public SimpleGray direction() {
        GrayF32 intensity = new GrayF32(((ImageBase)this.dx).width, ((ImageBase)this.dx).height);
        if (!(this.dx instanceof ImageGray)) {
            throw new RuntimeException("Unknown image type");
        }
        GGradientToEdgeFeatures.direction((ImageGray)((ImageGray)this.dx), (ImageGray)((ImageGray)this.dy), (GrayF32)intensity);
        return new SimpleGray<GrayF32>(intensity);
    }

    public SimpleGray direction2() {
        GrayF32 intensity = new GrayF32(((ImageBase)this.dx).width, ((ImageBase)this.dx).height);
        if (!(this.dx instanceof ImageGray)) {
            throw new RuntimeException("Unknown image type");
        }
        GGradientToEdgeFeatures.direction2((ImageGray)((ImageGray)this.dx), (ImageGray)((ImageGray)this.dy), (GrayF32)intensity);
        return new SimpleGray<GrayF32>(intensity);
    }

    public PImage visualize() {
        if (this.dx instanceof GrayS16) {
            return VisualizeProcessing.gradient((GrayS16)this.dx, (GrayS16)this.dy);
        }
        if (this.dx instanceof GrayF32) {
            return VisualizeProcessing.gradient((GrayF32)this.dx, (GrayF32)this.dy);
        }
        throw new RuntimeException("Unknown image type");
    }

    public SimpleGray dx() {
        if (this.dx instanceof ImageGray) {
            return new SimpleGray<ImageGray>((ImageGray)this.dx);
        }
        throw new RuntimeException("Unknown image type");
    }

    public SimpleGray dy() {
        if (this.dy instanceof ImageGray) {
            return new SimpleGray<ImageGray>((ImageGray)this.dy);
        }
        throw new RuntimeException("Unknown image type");
    }

    public T getRawDx() {
        return this.dx;
    }

    public T getRawDy() {
        return this.dy;
    }
}

