/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.abst.fiducial.FiducialDetector;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.processing.ConvertProcessing;
import boofcv.processing.FiducialFound;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;

public class SimpleFiducial {
    FiducialDetector detector;
    ImageBase boofImage;
    CameraPinholeBrown intrinsic;

    public SimpleFiducial(FiducialDetector detector) {
        this.setDetector(detector);
    }

    protected SimpleFiducial() {
    }

    protected void setDetector(FiducialDetector detector) {
        this.detector = detector;
        this.boofImage = detector.getInputType().createImage(1, 1);
    }

    public void setIntrinsic(CameraPinholeBrown intrinsic) {
        this.detector.setLensDistortion(LensDistortionFactory.narrow((CameraModel)intrinsic), intrinsic.width, intrinsic.height);
        this.intrinsic = intrinsic;
    }

    public void guessCrappyIntrinsic(int width, int height) {
        this.setIntrinsic(PerspectiveOps.createIntrinsic((int)width, (int)height, (double)70.0));
    }

    public List<FiducialFound> detect(PImage image) {
        this.boofImage.reshape(image.width, image.height);
        ConvertProcessing.convertFromRGB(image, this.boofImage);
        this.detector.detect(this.boofImage);
        ArrayList<FiducialFound> found = new ArrayList<FiducialFound>();
        for (int i = 0; i < this.detector.totalFound(); ++i) {
            long id = this.detector.getId(i);
            double width = this.detector.getWidth(i);
            Se3_F64 fiducialToWorld = null;
            if (this.detector.is3D()) {
                fiducialToWorld = new Se3_F64();
                this.detector.getFiducialToCamera(i, fiducialToWorld);
            }
            Point2D_F64 location = new Point2D_F64();
            this.detector.getCenter(i, location);
            found.add(new FiducialFound(id, width, location, fiducialToWorld));
        }
        return found;
    }

    public void render(PApplet p, FiducialFound fiducial) {
        double r = fiducial.getWidth() / 2.0;
        Point3D_F64[] corners = new Point3D_F64[]{new Point3D_F64(-r, -r, 0.0), new Point3D_F64(r, -r, 0.0), new Point3D_F64(r, r, 0.0), new Point3D_F64(-r, r, 0.0), new Point3D_F64(-r, -r, r), new Point3D_F64(r, -r, r), new Point3D_F64(r, r, r), new Point3D_F64(-r, r, r)};
        Se3_F64 targetToCamera = fiducial.getFiducialToCamera();
        Point2D_I32[] pixel = new Point2D_I32[8];
        Point2D_F64 a = new Point2D_F64();
        for (int i = 0; i < 8; ++i) {
            Point3D_F64 c = corners[i];
            SePointOps_F64.transform((Se3_F64)targetToCamera, (Point3D_F64)c, (Point3D_F64)c);
            PerspectiveOps.convertNormToPixel((CameraPinhole)this.intrinsic, (double)(c.x / c.z), (double)(c.y / c.z), (Point2D_F64)a);
            pixel[i] = new Point2D_I32((int)(a.x + 0.5), (int)(a.y + 0.5));
        }
        p.strokeWeight(3.0f);
        p.stroke(255.0f, 0.0f, 0.0f);
        p.line((float)pixel[0].x, (float)pixel[0].y, (float)pixel[1].x, (float)pixel[1].y);
        p.line((float)pixel[1].x, (float)pixel[1].y, (float)pixel[2].x, (float)pixel[2].y);
        p.line((float)pixel[2].x, (float)pixel[2].y, (float)pixel[3].x, (float)pixel[3].y);
        p.line((float)pixel[3].x, (float)pixel[3].y, (float)pixel[0].x, (float)pixel[0].y);
        p.stroke(0.0f, 0.0f, 0.0f);
        p.line((float)pixel[0].x, (float)pixel[0].y, (float)pixel[4].x, (float)pixel[4].y);
        p.line((float)pixel[1].x, (float)pixel[1].y, (float)pixel[5].x, (float)pixel[5].y);
        p.line((float)pixel[2].x, (float)pixel[2].y, (float)pixel[6].x, (float)pixel[6].y);
        p.line((float)pixel[3].x, (float)pixel[3].y, (float)pixel[7].x, (float)pixel[7].y);
        p.stroke(0.0f, 255.0f, 0.0f, 125.0f);
        p.line((float)pixel[4].x, (float)pixel[4].y, (float)pixel[5].x, (float)pixel[5].y);
        p.stroke(192.0f, 16.0f, 192.0f, 125.0f);
        p.line((float)pixel[5].x, (float)pixel[5].y, (float)pixel[6].x, (float)pixel[6].y);
        p.stroke(0.0f, 160.0f, 192.0f, 125.0f);
        p.line((float)pixel[6].x, (float)pixel[6].y, (float)pixel[7].x, (float)pixel[7].y);
        p.stroke(0.0f, 0.0f, 255.0f);
        p.line((float)pixel[7].x, (float)pixel[7].y, (float)pixel[4].x, (float)pixel[4].y);
        Point2D_I32 middle = pixel[0];
        middle.y = 0;
        middle.x = 0;
        for (int i = 4; i < 8; ++i) {
            middle.x += pixel[i].x;
            middle.y += pixel[i].y;
        }
        middle.x /= 4;
        middle.y /= 4;
        PFont f = p.createFont("Arial", 24.0f, true);
        p.textFont(f, 24.0f);
        p.fill(255.0f, 0.0f, 0.0f);
        p.text(fiducial.getId() + "", (float)middle.x, (float)middle.y);
    }
}

