/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.processing.ConvertProcessing;
import boofcv.processing.SimpleImage;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import processing.core.PImage;

public class SimpleDetectDescribePoint<T extends ImageBase<T>, Desc extends TupleDesc> {
    DetectDescribePoint<T, Desc> detectDescribe;
    T input;

    public SimpleDetectDescribePoint(DetectDescribePoint<T, Desc> detectDescribe, ImageType<T> imageType) {
        this.detectDescribe = detectDescribe;
        this.input = imageType.createImage(1, 1);
    }

    public void process(PImage image) {
        this.input.reshape(image.width, image.height);
        ConvertProcessing.convertFromRGB(image, this.input);
        this.detectDescribe.detect(this.input);
    }

    public void process(SimpleImage<T> image) {
        this.detectDescribe.detect(image.image);
    }

    public List<Desc> getDescriptions() {
        ArrayList<TupleDesc> ret = new ArrayList<TupleDesc>();
        for (int i = 0; i < this.detectDescribe.getNumberOfFeatures(); ++i) {
            ret.add(this.detectDescribe.getDescription(i).copy());
        }
        return ret;
    }

    public List<Point2D_F64> getLocations() {
        ArrayList<Point2D_F64> ret = new ArrayList<Point2D_F64>();
        for (int i = 0; i < this.detectDescribe.getNumberOfFeatures(); ++i) {
            ret.add(this.detectDescribe.getLocation(i).copy());
        }
        return ret;
    }

    public DetectDescribePoint<T, Desc> getDetectDescribe() {
        return this.detectDescribe;
    }
}

