/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.abst.flow.DenseOpticalFlow;
import boofcv.processing.ConvertProcessing;
import boofcv.processing.SimpleImage;
import boofcv.processing.VisualizeProcessing;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.ImageBase;
import processing.core.PImage;

public class SimpleDenseOpticalFlow<T extends ImageBase<T>> {
    DenseOpticalFlow<T> alg;
    ImageFlow flow = new ImageFlow(1, 1);
    T source;
    T destination;

    public SimpleDenseOpticalFlow(DenseOpticalFlow<T> alg) {
        this.alg = alg;
        this.source = alg.getInputType().createImage(1, 1);
        this.destination = alg.getInputType().createImage(1, 1);
    }

    public void process(PImage source, PImage destination) {
        this.source.reshape(source.width, source.height);
        this.destination.reshape(destination.width, destination.height);
        this.flow.reshape(source.width, source.height);
        ConvertProcessing.convertFromRGB(source, this.source);
        ConvertProcessing.convertFromRGB(destination, this.destination);
        this.alg.process(this.source, this.destination, this.flow);
    }

    public void process(SimpleImage<T> source, SimpleImage<T> destination) {
        this.flow.reshape(((ImageBase)source.image).width, ((ImageBase)source.image).height);
        this.alg.process(source.image, destination.image, this.flow);
    }

    public ImageFlow getFlow() {
        return this.flow;
    }

    public PImage visualizeFlow() {
        return VisualizeProcessing.denseFlow(this.flow);
    }

    public DenseOpticalFlow<T> getFlowAlgorithm() {
        return this.alg;
    }
}

