/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.processing.SimpleContour;
import georegression.struct.curve.EllipseRotated_F64;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import processing.core.PImage;

public class SimpleContourList {
    List<SimpleContour> contour = new ArrayList<SimpleContour>();
    int width;
    int height;

    public SimpleContourList(List<SimpleContour> contour, int width, int height) {
        this.contour = contour;
        this.width = width;
        this.height = height;
    }

    public List<List<Point2D_I32>> fitPolygons(boolean external, int minimumSideLength, double cornerPenalty) {
        ArrayList<List<Point2D_I32>> polygons = new ArrayList<List<Point2D_I32>>();
        for (int i = 0; i < this.contour.size(); ++i) {
            polygons.addAll(this.contour.get(i).fitPolygon(external, minimumSideLength, cornerPenalty));
        }
        return polygons;
    }

    public List<EllipseRotated_F64> fitEllipses(boolean external) {
        ArrayList<EllipseRotated_F64> ellipses = new ArrayList<EllipseRotated_F64>();
        for (int i = 0; i < this.contour.size(); ++i) {
            ellipses.addAll(this.contour.get(i).fitEllipses(external));
        }
        return ellipses;
    }

    public int size() {
        return this.contour.size();
    }

    public List<SimpleContour> getList() {
        return this.contour;
    }

    public PImage visualize() {
        PImage out = new PImage(this.width, this.height, 1);
        for (SimpleContour sc : this.contour) {
            sc.visualize(out, -65536, -16711936);
        }
        return out;
    }
}

