/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.alg.filter.binary.Contour;
import boofcv.alg.shapes.FitData;
import boofcv.alg.shapes.ShapeFittingOps;
import boofcv.struct.PointIndex_I32;
import georegression.struct.curve.EllipseRotated_F64;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import processing.core.PImage;

public class SimpleContour {
    Contour contour;

    public SimpleContour(Contour contour) {
        this.contour = contour;
    }

    public List<List<Point2D_I32>> fitPolygon(boolean external, int minimumSideLength, double cornerPenalty) {
        ArrayList<List<Point2D_I32>> polygons = new ArrayList<List<Point2D_I32>>();
        if (external) {
            List output = ShapeFittingOps.fitPolygon((List)this.contour.external, (boolean)true, (int)minimumSideLength, (double)cornerPenalty);
            ArrayList<Point2D_I32> poly = new ArrayList<Point2D_I32>();
            for (PointIndex_I32 p : output) {
                poly.add(new Point2D_I32(p.x, p.y));
            }
            polygons.add(poly);
        } else {
            for (List i : this.contour.internal) {
                List output = ShapeFittingOps.fitPolygon((List)i, (boolean)true, (int)minimumSideLength, (double)cornerPenalty);
                ArrayList<Point2D_I32> poly = new ArrayList<Point2D_I32>();
                for (PointIndex_I32 p : output) {
                    poly.add(new Point2D_I32(p.x, p.y));
                }
                polygons.add(poly);
            }
        }
        return polygons;
    }

    public List<EllipseRotated_F64> fitEllipses(boolean external) {
        ArrayList<EllipseRotated_F64> ellipses = new ArrayList<EllipseRotated_F64>();
        if (external) {
            FitData found = ShapeFittingOps.fitEllipse_I32((List)this.contour.external, (int)0, (boolean)false, null);
            ellipses.add((EllipseRotated_F64)found.shape);
        } else {
            for (List i : this.contour.internal) {
                FitData found = ShapeFittingOps.fitEllipse_I32((List)i, (int)0, (boolean)false, null);
                ellipses.add((EllipseRotated_F64)found.shape);
            }
        }
        return ellipses;
    }

    public void visualize(PImage image, int colorExternal, int colorInternal) {
        for (Point2D_I32 p : this.contour.external) {
            int index = p.y * image.width + p.x;
            image.pixels[index] = colorExternal;
        }
        for (List i : this.contour.internal) {
            for (Point2D_I32 p : i) {
                int index = p.y * image.width + p.x;
                image.pixels[index] = colorInternal;
            }
        }
    }

    public Contour getContour() {
        return this.contour;
    }
}

