/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.abst.distort.FDistort;
import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.processing.ConvertProcessing;
import boofcv.processing.SimpleGray;
import boofcv.processing.SimpleImage;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrixRMaj;
import org.ejml.ops.ConvertMatrixData;
import processing.core.PImage;

public class SimpleColor<Gray extends ImageGray<Gray>>
extends SimpleImage<Planar<Gray>> {
    public SimpleColor(Planar<Gray> image) {
        super(image);
    }

    public SimpleColor blurMean(int radius) {
        return new SimpleColor<Gray>((Planar)GBlurImageOps.mean((ImageBase)((Planar)this.image), null, (int)radius, null, null));
    }

    public SimpleColor blurMedian(int radius) {
        return new SimpleColor<Gray>((Planar)GBlurImageOps.median((ImageBase)((Planar)this.image), null, (int)radius, null));
    }

    public SimpleColor removePerspective(int outWidth, int outHeight, double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        Planar output = ((Planar)this.image).createNew(outWidth, outHeight);
        Estimate1ofEpipolar computeHomography = FactoryMultiView.homographyDLT((boolean)true);
        ArrayList<AssociatedPair> associatedPairs = new ArrayList<AssociatedPair>();
        associatedPairs.add(new AssociatedPair(new Point2D_F64(0.0, 0.0), new Point2D_F64(x0, y0)));
        associatedPairs.add(new AssociatedPair(new Point2D_F64((double)(outWidth - 1), 0.0), new Point2D_F64(x1, y1)));
        associatedPairs.add(new AssociatedPair(new Point2D_F64((double)(outWidth - 1), (double)(outHeight - 1)), new Point2D_F64(x2, y2)));
        associatedPairs.add(new AssociatedPair(new Point2D_F64(0.0, (double)(outHeight - 1)), new Point2D_F64(x3, y3)));
        DMatrixRMaj H = new DMatrixRMaj(3, 3);
        computeHomography.process(associatedPairs, (Object)H);
        FMatrixRMaj H32 = new FMatrixRMaj(3, 3);
        ConvertMatrixData.convert((DMatrixRMaj)H, (FMatrixRMaj)H32);
        PointTransformHomography_F32 homography = new PointTransformHomography_F32(H32);
        new FDistort(this.image, (ImageBase)output).transform((PixelTransform)new PointToPixelTransform_F32((Point2Transform2_F32)homography)).apply();
        return new SimpleColor<Gray>(output);
    }

    public SimpleColor blurGaussian(double sigma, int radius) {
        return new SimpleColor<Gray>((Planar)GBlurImageOps.gaussian((ImageBase)((Planar)this.image), null, (double)sigma, (int)radius, null));
    }

    public SimpleGray grayMean() {
        ImageGray out = GeneralizedImageOps.createSingleBand((ImageDataType)((Planar)this.image).imageType.getDataType(), (int)((Planar)this.image).width, (int)((Planar)this.image).height);
        GConvertImage.average((ImageMultiBand)((ImageMultiBand)this.image), (ImageGray)out);
        return new SimpleGray<ImageGray>(out);
    }

    public SimpleGray getBand(int band) {
        return new SimpleGray<ImageGray>(((Planar)this.image).getBand(band));
    }

    public int getNumberOfBands() {
        return ((Planar)this.image).getNumBands();
    }

    public PImage convert() {
        PImage out = new PImage(((Planar)this.image).width, ((Planar)this.image).height, 1);
        if (((Planar)this.image).getBandType() == GrayF32.class) {
            ConvertProcessing.convert_PF32_RGB((Planar<GrayF32>)((Planar)this.image), out);
        } else if (((Planar)this.image).getBandType() == GrayU8.class) {
            ConvertProcessing.convert_PU8_RGB((Planar<GrayU8>)((Planar)this.image), out);
        } else {
            throw new RuntimeException("Unknown image type");
        }
        return out;
    }
}

