/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.processing.ResultsBlob;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import java.util.List;
import processing.core.PImage;

public class SimpleBinary {
    GrayU8 image;

    public SimpleBinary(GrayU8 image) {
        this.image = image;
    }

    public SimpleBinary logicAnd(SimpleBinary imgB) {
        GrayU8 out = new GrayU8(this.image.width, this.image.height);
        BinaryImageOps.logicAnd((GrayU8)this.image, (GrayU8)imgB.image, (GrayU8)out);
        return new SimpleBinary(out);
    }

    public SimpleBinary logicOr(SimpleBinary imgB) {
        GrayU8 out = new GrayU8(this.image.width, this.image.height);
        BinaryImageOps.logicOr((GrayU8)this.image, (GrayU8)imgB.image, (GrayU8)out);
        return new SimpleBinary(out);
    }

    public SimpleBinary logicXor(SimpleBinary imgB) {
        GrayU8 out = new GrayU8(this.image.width, this.image.height);
        BinaryImageOps.logicXor((GrayU8)this.image, (GrayU8)imgB.image, (GrayU8)out);
        return new SimpleBinary(out);
    }

    public SimpleBinary erode4(int numTimes) {
        GrayU8 out = new GrayU8(this.image.width, this.image.height);
        BinaryImageOps.erode4((GrayU8)this.image, (int)numTimes, (GrayU8)out);
        return new SimpleBinary(out);
    }

    public SimpleBinary erode8(int numTimes) {
        GrayU8 out = new GrayU8(this.image.width, this.image.height);
        BinaryImageOps.erode8((GrayU8)this.image, (int)numTimes, (GrayU8)out);
        return new SimpleBinary(out);
    }

    public SimpleBinary dilate4(int numTimes) {
        GrayU8 out = new GrayU8(this.image.width, this.image.height);
        BinaryImageOps.dilate4((GrayU8)this.image, (int)numTimes, (GrayU8)out);
        return new SimpleBinary(out);
    }

    public SimpleBinary dilate8(int numTimes) {
        GrayU8 out = new GrayU8(this.image.width, this.image.height);
        BinaryImageOps.dilate8((GrayU8)this.image, (int)numTimes, (GrayU8)out);
        return new SimpleBinary(out);
    }

    public SimpleBinary edge4() {
        GrayU8 out = new GrayU8(this.image.width, this.image.height);
        BinaryImageOps.edge4((GrayU8)this.image, (GrayU8)out, (boolean)true);
        return new SimpleBinary(out);
    }

    public SimpleBinary edge8() {
        GrayU8 out = new GrayU8(this.image.width, this.image.height);
        BinaryImageOps.edge8((GrayU8)this.image, (GrayU8)out, (boolean)true);
        return new SimpleBinary(out);
    }

    public SimpleBinary removePointNoise() {
        GrayU8 out = new GrayU8(this.image.width, this.image.height);
        BinaryImageOps.removePointNoise((GrayU8)this.image, (GrayU8)out);
        return new SimpleBinary(out);
    }

    public ResultsBlob contour() {
        GrayS32 labeled = new GrayS32(this.image.width, this.image.height);
        List contours = BinaryImageOps.contour((GrayU8)this.image, (ConnectRule)ConnectRule.EIGHT, (GrayS32)labeled);
        return new ResultsBlob(contours, labeled);
    }

    public PImage visualize() {
        PImage out = new PImage(this.image.width, this.image.height, 1);
        int indexOut = 0;
        for (int y = 0; y < this.image.height; ++y) {
            int indexIn = this.image.startIndex + this.image.stride * y;
            int x = 0;
            while (x < this.image.width) {
                out.pixels[indexOut] = this.image.data[indexIn] == 0 ? -16777216 : -1;
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
        return out;
    }

    public GrayU8 getImage() {
        return this.image;
    }
}

