/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.spherical.CameraToEquirectangular_F32;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.processing.ConvertProcessing;
import boofcv.processing.SimpleColor;
import boofcv.struct.border.BorderType;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRMaj;
import org.ejml.ops.ConvertMatrixData;
import processing.core.PImage;

public class EquirectangularToPinhole {
    Planar<GrayU8> equiImage = new Planar(GrayU8.class, 1, 1, 3);
    Planar<GrayU8> pinholeImage = new Planar(GrayU8.class, 1, 1, 3);
    ImageDistort<Planar<GrayU8>, Planar<GrayU8>> distorter;
    CameraPinhole intrinsic;
    CameraToEquirectangular_F32 equiToPinhole = new CameraToEquirectangular_F32();
    boolean pinholeChanged = false;

    public EquirectangularToPinhole() {
        ImageType imageType = ImageType.pl((int)3, GrayU8.class);
        InterpolatePixel interp = FactoryInterpolation.createPixel((double)0.0, (double)255.0, (InterpolationType)InterpolationType.BILINEAR, (BorderType)BorderType.EXTENDED, (ImageType)imageType);
        this.distorter = FactoryDistort.distort((boolean)false, (InterpolatePixel)interp, (ImageType)imageType);
    }

    public void setIntrinsic(int width, int height, double hfov) {
        this.setIntrinsic((CameraPinhole)PerspectiveOps.createIntrinsic((int)width, (int)height, (double)hfov));
    }

    public void setIntrinsic(CameraPinhole intrinsic) {
        this.intrinsic = intrinsic;
        this.pinholeImage.reshape(intrinsic.width, intrinsic.height);
        this.pinholeChanged = true;
    }

    public void setOrientation(DMatrixRMaj R) {
        FMatrixRMaj R32 = new FMatrixRMaj(3, 3);
        ConvertMatrixData.convert((DMatrixRMaj)R, (FMatrixRMaj)R32);
        this.equiToPinhole.getRotation().set((FMatrixD1)R32);
    }

    public void setEquirectangular(PImage image) {
        if (this.equiImage.width != image.width || this.equiImage.height != image.height) {
            this.equiImage.reshape(image.width, image.height);
            this.equiToPinhole.setEquirectangularShape(this.equiImage.width, this.equiImage.height);
        }
        ConvertProcessing.convertFromRGB(image, this.equiImage);
    }

    public SimpleColor render() {
        if (this.intrinsic == null) {
            throw new IllegalArgumentException("Must call setIntrinsic() first");
        }
        if (this.pinholeChanged) {
            this.pinholeChanged = false;
            this.equiToPinhole.setCameraModel(this.intrinsic);
            this.distorter.setModel((PixelTransform)this.equiToPinhole);
        }
        this.distorter.apply(this.equiImage, this.pinholeImage);
        return new SimpleColor<GrayU8>(this.pinholeImage);
    }
}

