/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.Planar;
import processing.core.PImage;

public class ConvertProcessing {
    public static void convertFromRGB(PImage input, ImageBase output) {
        if (output instanceof GrayU8) {
            ConvertProcessing.convert_RGB_U8(input, (GrayU8)output);
        } else if (output instanceof GrayF32) {
            ConvertProcessing.convert_RGB_F32(input, (GrayF32)output);
        } else if (output instanceof Planar) {
            Class bandType = ((Planar)output).getBandType();
            if (bandType == GrayF32.class) {
                ConvertProcessing.convert_RGB_PF32(input, (Planar<GrayF32>)((Planar)output));
            } else if (bandType == GrayU8.class) {
                ConvertProcessing.convert_RGB_PU8(input, (Planar<GrayU8>)((Planar)output));
            }
        }
    }

    public static void convert_RGB_F32(PImage input, GrayF32 output) {
        output.reshape(input.width, input.height);
        int indexInput = 0;
        for (int y = 0; y < input.height; ++y) {
            int indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < input.width) {
                int value = input.pixels[indexInput];
                int r = value >> 16 & 0xFF;
                int g = value >> 8 & 0xFF;
                int b = value & 0xFF;
                output.data[indexOut] = (float)(r + g + b) / 3.0f;
                ++x;
                ++indexInput;
                ++indexOut;
            }
        }
    }

    public static void convert_RGB_U8(PImage input, GrayU8 output) {
        output.reshape(input.width, input.height);
        int indexInput = 0;
        for (int y = 0; y < input.height; ++y) {
            int indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < input.width) {
                int value = input.pixels[indexInput];
                int r = value >> 16 & 0xFF;
                int g = value >> 8 & 0xFF;
                int b = value & 0xFF;
                output.data[indexOut] = (byte)((r + g + b) / 3);
                ++x;
                ++indexInput;
                ++indexOut;
            }
        }
    }

    public static void convert_F32_RGB(GrayF32 input, PImage output) {
        int indexOutput = 0;
        for (int y = 0; y < input.height; ++y) {
            int indexInput = input.startIndex + y * input.stride;
            int x = 0;
            while (x < input.width) {
                int value = (int)input.data[indexInput];
                output.pixels[indexOutput] = 0xFF000000 | value << 16 | value << 8 | value;
                ++x;
                ++indexOutput;
                ++indexInput;
            }
        }
    }

    public static void convert_U8_RGB(GrayU8 input, PImage output) {
        int indexOutput = 0;
        for (int y = 0; y < input.height; ++y) {
            int indexInput = input.startIndex + y * input.stride;
            int x = 0;
            while (x < input.width) {
                int value = input.data[indexInput] & 0xFF;
                output.pixels[indexOutput] = 0xFF000000 | value << 16 | value << 8 | value;
                ++x;
                ++indexOutput;
                ++indexInput;
            }
        }
    }

    public static void convert_PF32_RGB(Planar<GrayF32> input, PImage output) {
        GrayF32 red = (GrayF32)input.getBand(0);
        GrayF32 green = (GrayF32)input.getBand(1);
        GrayF32 blue = (GrayF32)input.getBand(2);
        int indexOutput = 0;
        for (int y = 0; y < input.height; ++y) {
            int indexInput = input.startIndex + y * input.stride;
            int x = 0;
            while (x < input.width) {
                int r = (int)red.data[indexInput];
                int g = (int)green.data[indexInput];
                int b = (int)blue.data[indexInput];
                output.pixels[indexOutput] = 0xFF000000 | r << 16 | g << 8 | b;
                ++x;
                ++indexOutput;
                ++indexInput;
            }
        }
    }

    public static void convert_PU8_RGB(Planar<GrayU8> input, PImage output) {
        GrayU8 red = (GrayU8)input.getBand(0);
        GrayU8 green = (GrayU8)input.getBand(1);
        GrayU8 blue = (GrayU8)input.getBand(2);
        int indexOutput = 0;
        for (int y = 0; y < input.height; ++y) {
            int indexInput = input.startIndex + y * input.stride;
            int x = 0;
            while (x < input.width) {
                int r = red.data[indexInput] & 0xFF;
                int g = green.data[indexInput] & 0xFF;
                int b = blue.data[indexInput] & 0xFF;
                output.pixels[indexOutput] = 0xFF000000 | r << 16 | g << 8 | b;
                ++x;
                ++indexOutput;
                ++indexInput;
            }
        }
    }

    public static void convert_RGB_PF32(PImage input, Planar<GrayF32> output) {
        output.reshape(input.width, input.height);
        GrayF32 red = (GrayF32)output.getBand(0);
        GrayF32 green = (GrayF32)output.getBand(1);
        GrayF32 blue = (GrayF32)output.getBand(2);
        int indexInput = 0;
        for (int y = 0; y < input.height; ++y) {
            int indexOutput = output.startIndex + y * output.stride;
            int x = 0;
            while (x < input.width) {
                int value = input.pixels[indexInput];
                red.data[indexOutput] = value >> 16 & 0xFF;
                green.data[indexOutput] = value >> 8 & 0xFF;
                blue.data[indexOutput] = value & 0xFF;
                ++x;
                ++indexOutput;
                ++indexInput;
            }
        }
    }

    public static void convert_RGB_PU8(PImage input, Planar<GrayU8> output) {
        output.reshape(input.width, input.height);
        GrayU8 red = (GrayU8)output.getBand(0);
        GrayU8 green = (GrayU8)output.getBand(1);
        GrayU8 blue = (GrayU8)output.getBand(2);
        int indexInput = 0;
        for (int y = 0; y < input.height; ++y) {
            int indexOutput = output.startIndex + y * output.stride;
            int x = 0;
            while (x < input.width) {
                int value = input.pixels[indexInput];
                red.data[indexOutput] = (byte)(value >> 16);
                green.data[indexOutput] = (byte)(value >> 8);
                blue.data[indexOutput] = (byte)value;
                ++x;
                ++indexOutput;
                ++indexInput;
            }
        }
    }
}

