/*
 * Decompiled with CFR 0.152.
 */
package boofcv.processing;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.detdesc.ConfigCompleteSift;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.interest.ConfigPointDetector;
import boofcv.abst.fiducial.FiducialDetector;
import boofcv.abst.flow.DenseOpticalFlow;
import boofcv.abst.segmentation.ImageSuperpixels;
import boofcv.abst.tracker.ConfigCirculantTracker;
import boofcv.abst.tracker.ConfigComaniciu2003;
import boofcv.abst.tracker.ConfigTrackerTld;
import boofcv.abst.tracker.PointTracker;
import boofcv.abst.tracker.PointTrackerKltPyramid;
import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.alg.feature.detect.template.TemplateMatching;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.flow.ConfigBroxWarping;
import boofcv.alg.tracker.klt.ConfigPKlt;
import boofcv.alg.tracker.sfot.SfotConfig;
import boofcv.factory.background.ConfigBackgroundBasic;
import boofcv.factory.background.ConfigBackgroundGmm;
import boofcv.factory.feature.associate.ConfigAssociateGreedy;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.factory.feature.detect.template.FactoryTemplateMatching;
import boofcv.factory.feature.detect.template.TemplateScoreType;
import boofcv.factory.fiducial.ConfigFiducialBinary;
import boofcv.factory.fiducial.ConfigFiducialImage;
import boofcv.factory.fiducial.FactoryFiducial;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.factory.flow.ConfigHornSchunck;
import boofcv.factory.flow.ConfigHornSchunckPyramid;
import boofcv.factory.flow.ConfigOpticalFlowBlockPyramid;
import boofcv.factory.flow.FactoryDenseOpticalFlow;
import boofcv.factory.scene.ClassifierAndSource;
import boofcv.factory.scene.FactoryImageClassifier;
import boofcv.factory.segmentation.ConfigFh04;
import boofcv.factory.segmentation.ConfigSegmentMeanShift;
import boofcv.factory.segmentation.ConfigSlic;
import boofcv.factory.segmentation.ConfigWatershed;
import boofcv.factory.segmentation.FactoryImageSegmentation;
import boofcv.factory.tracker.FactoryPointTracker;
import boofcv.factory.tracker.FactoryTrackerObjectQuad;
import boofcv.processing.ConvertProcessing;
import boofcv.processing.EquirectangularToPinhole;
import boofcv.processing.SimpleAssociateDescription;
import boofcv.processing.SimpleColor;
import boofcv.processing.SimpleDenseOpticalFlow;
import boofcv.processing.SimpleDetectDescribePoint;
import boofcv.processing.SimpleFiducial;
import boofcv.processing.SimpleFiducialSquareImage;
import boofcv.processing.SimpleGray;
import boofcv.processing.SimpleImageClassification;
import boofcv.processing.SimpleImageSegmentation;
import boofcv.processing.SimpleMotionDetection;
import boofcv.processing.SimpleQrCode;
import boofcv.processing.SimpleTemplateMatching;
import boofcv.processing.SimpleTrackerObject;
import boofcv.processing.SimpleTrackerPoints;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.EulerType;
import georegression.struct.so.Rodrigues_F64;
import org.ejml.data.DMatrixRMaj;
import processing.core.PImage;

public class Boof {
    public static SimpleGray gray(PImage image, ImageDataType type) {
        if (type == ImageDataType.F32) {
            GrayF32 out = new GrayF32(image.width, image.height);
            switch (image.format) {
                case 1: 
                case 2: {
                    ConvertProcessing.convert_RGB_F32(image, out);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported image type");
                }
            }
            return new SimpleGray<GrayF32>(out);
        }
        if (type == ImageDataType.U8) {
            GrayU8 out = new GrayU8(image.width, image.height);
            switch (image.format) {
                case 1: 
                case 2: {
                    ConvertProcessing.convert_RGB_U8(image, out);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported image type");
                }
            }
            return new SimpleGray<GrayU8>(out);
        }
        throw new RuntimeException("Unsupport type: " + type);
    }

    public static SimpleColor colorMS(PImage image, ImageDataType type) {
        if (type == ImageDataType.F32) {
            Planar out = new Planar(GrayF32.class, image.width, image.height, 3);
            switch (image.format) {
                case 1: 
                case 2: {
                    ConvertProcessing.convert_RGB_PF32(image, (Planar<GrayF32>)out);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported image type");
                }
            }
            return new SimpleColor(out);
        }
        if (type == ImageDataType.U8) {
            Planar out = new Planar(GrayU8.class, image.width, image.height, 3);
            switch (image.format) {
                case 1: 
                case 2: {
                    ConvertProcessing.convert_RGB_PU8(image, (Planar<GrayU8>)out);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported image type");
                }
            }
            return new SimpleColor(out);
        }
        throw new RuntimeException("Unsupport type: " + type);
    }

    public static SimpleTrackerPoints trackerKlt(ConfigPKlt config, ConfigPointDetector configDetect, ImageDataType imageType) {
        Class inputType = ImageDataType.typeToSingleClass((ImageDataType)imageType);
        Class derivType = GImageDerivativeOps.getDerivativeType((Class)inputType);
        PointTrackerKltPyramid tracker = FactoryPointTracker.klt((ConfigPKlt)config, (ConfigPointDetector)configDetect, (Class)inputType, (Class)derivType);
        return new SimpleTrackerPoints((PointTracker)tracker, inputType);
    }

    public static SimpleTrackerObject trackerTld(ConfigTrackerTld config, ImageDataType imageType) {
        Class inputType = ImageDataType.typeToSingleClass((ImageDataType)imageType);
        TrackerObjectQuad tracker = FactoryTrackerObjectQuad.tld((ConfigTrackerTld)config, (Class)inputType);
        return new SimpleTrackerObject(tracker);
    }

    public static SimpleTrackerObject trackerMeanShiftComaniciu(ConfigComaniciu2003 config, ImageType imageType) {
        TrackerObjectQuad tracker = FactoryTrackerObjectQuad.meanShiftComaniciu2003((ConfigComaniciu2003)config, (ImageType)imageType);
        return new SimpleTrackerObject(tracker);
    }

    public static SimpleTrackerObject trackerCirculant(ConfigCirculantTracker config, ImageDataType imageType) {
        Class inputType = ImageDataType.typeToSingleClass((ImageDataType)imageType);
        TrackerObjectQuad tracker = FactoryTrackerObjectQuad.circulant((ConfigCirculantTracker)config, (Class)inputType);
        return new SimpleTrackerObject(tracker);
    }

    public static SimpleTrackerObject trackerSparseFlow(SfotConfig config, ImageDataType imageType) {
        Class inputType = ImageDataType.typeToSingleClass((ImageDataType)imageType);
        Class derivType = GImageDerivativeOps.getDerivativeType((Class)inputType);
        TrackerObjectQuad tracker = FactoryTrackerObjectQuad.sparseFlow((SfotConfig)config, (Class)inputType, (Class)derivType);
        return new SimpleTrackerObject(tracker);
    }

    public static SimpleImageSegmentation segmentMeanShift(ConfigSegmentMeanShift config, ImageType imageType) {
        ImageSuperpixels alg = FactoryImageSegmentation.meanShift((ConfigSegmentMeanShift)config, (ImageType)imageType);
        return new SimpleImageSegmentation(alg);
    }

    public static SimpleImageSegmentation segmentSlic(ConfigSlic config, ImageType imageType) {
        ImageSuperpixels alg = FactoryImageSegmentation.slic((ConfigSlic)config, (ImageType)imageType);
        return new SimpleImageSegmentation(alg);
    }

    public static SimpleImageSegmentation segmentFH04(ConfigFh04 config, ImageType imageType) {
        ImageSuperpixels alg = FactoryImageSegmentation.fh04((ConfigFh04)config, (ImageType)imageType);
        return new SimpleImageSegmentation(alg);
    }

    public static SimpleImageSegmentation segmentWatershed(ConfigWatershed config, ImageType imageType) {
        ImageSuperpixels alg = FactoryImageSegmentation.watershed((ConfigWatershed)config, (ImageType)imageType);
        return new SimpleImageSegmentation(alg);
    }

    public static SimpleDenseOpticalFlow flowKlt(ConfigPKlt configKlt, int radius, ImageDataType imageType) {
        Class inputType = ImageDataType.typeToSingleClass((ImageDataType)imageType);
        Class derivType = GImageDerivativeOps.getDerivativeType((Class)inputType);
        DenseOpticalFlow flow = FactoryDenseOpticalFlow.flowKlt((ConfigPKlt)configKlt, (int)radius, (Class)inputType, (Class)derivType);
        return new SimpleDenseOpticalFlow(flow);
    }

    public static SimpleDenseOpticalFlow flowRegion(ConfigOpticalFlowBlockPyramid config, ImageDataType imageType) {
        Class inputType = ImageDataType.typeToSingleClass((ImageDataType)imageType);
        DenseOpticalFlow flow = FactoryDenseOpticalFlow.region((ConfigOpticalFlowBlockPyramid)config, (Class)inputType);
        return new SimpleDenseOpticalFlow(flow);
    }

    public static SimpleDenseOpticalFlow flowHornSchunck(ConfigHornSchunck config, ImageDataType imageType) {
        Class inputType = ImageDataType.typeToSingleClass((ImageDataType)imageType);
        DenseOpticalFlow flow = FactoryDenseOpticalFlow.hornSchunck((ConfigHornSchunck)config, (Class)inputType);
        return new SimpleDenseOpticalFlow(flow);
    }

    public static SimpleDenseOpticalFlow flowHornSchunckPyramid(ConfigHornSchunckPyramid config, ImageDataType imageType) {
        Class inputType = ImageDataType.typeToSingleClass((ImageDataType)imageType);
        DenseOpticalFlow flow = FactoryDenseOpticalFlow.hornSchunckPyramid((ConfigHornSchunckPyramid)config, (Class)inputType);
        return new SimpleDenseOpticalFlow(flow);
    }

    public static SimpleDenseOpticalFlow flowBroxWarping(ConfigBroxWarping configKlt, ImageDataType imageType) {
        Class inputType = ImageDataType.typeToSingleClass((ImageDataType)imageType);
        DenseOpticalFlow flow = FactoryDenseOpticalFlow.broxWarping((ConfigBroxWarping)configKlt, (Class)inputType);
        return new SimpleDenseOpticalFlow(flow);
    }

    public static SimpleDetectDescribePoint detectSurf(boolean stable, ImageDataType imageType) {
        Class inputType = ImageDataType.typeToSingleClass((ImageDataType)imageType);
        DetectDescribePoint ddp = stable ? FactoryDetectDescribe.surfStable(null, null, null, (Class)inputType) : FactoryDetectDescribe.surfFast(null, null, null, (Class)inputType);
        return new SimpleDetectDescribePoint(ddp, ImageType.single((Class)inputType));
    }

    public static SimpleDetectDescribePoint detectSift(ImageDataType imageType) {
        Class inputType = ImageDataType.typeToSingleClass((ImageDataType)imageType);
        DetectDescribePoint ddp = FactoryDetectDescribe.sift((ConfigCompleteSift)new ConfigCompleteSift(), (Class)inputType);
        return new SimpleDetectDescribePoint(ddp, ImageType.single(GrayF32.class));
    }

    public static SimpleAssociateDescription associateGreedy(ConfigAssociateGreedy configGreedy, SimpleDetectDescribePoint detector) {
        ScoreAssociation score = FactoryAssociation.defaultScore((Class)detector.detectDescribe.getDescriptionType());
        AssociateDescription assoc = FactoryAssociation.greedy((ConfigAssociateGreedy)configGreedy, (ScoreAssociation)score);
        return new SimpleAssociateDescription(assoc);
    }

    public static SimpleFiducial fiducialSquareBinaryRobust(double width) {
        return new SimpleFiducial((FiducialDetector)FactoryFiducial.squareBinary((ConfigFiducialBinary)new ConfigFiducialBinary(width), (ConfigThreshold)ConfigThreshold.local((ThresholdType)ThresholdType.LOCAL_MEAN, (int)15), GrayU8.class));
    }

    public static SimpleFiducialSquareImage fiducialSquareImageRobust() {
        return new SimpleFiducialSquareImage(FactoryFiducial.squareImage((ConfigFiducialImage)new ConfigFiducialImage(), (ConfigThreshold)ConfigThreshold.local((ThresholdType)ThresholdType.LOCAL_MEAN, (int)15), GrayU8.class));
    }

    public static SimpleFiducial fiducialSquareBinary(double width, int threshold) {
        return new SimpleFiducial((FiducialDetector)FactoryFiducial.squareBinary((ConfigFiducialBinary)new ConfigFiducialBinary(width), (ConfigThreshold)ConfigThreshold.fixed((double)threshold), GrayU8.class));
    }

    public static SimpleFiducialSquareImage fiducialSquareImage(int threshold) {
        return new SimpleFiducialSquareImage(FactoryFiducial.squareImage((ConfigFiducialImage)new ConfigFiducialImage(), (ConfigThreshold)ConfigThreshold.fixed((double)threshold), GrayU8.class));
    }

    public static EquirectangularToPinhole equirectangularToPinhole() {
        return new EquirectangularToPinhole();
    }

    public static DMatrixRMaj eulerXYZ(double rotX, double rotY, double rotZ) {
        return ConvertRotation3D_F64.eulerToMatrix((EulerType)EulerType.XYZ, (double)rotX, (double)rotY, (double)rotZ, null);
    }

    public static DMatrixRMaj rodrigues(double angle, double axisX, double axisY, double axisZ) {
        return ConvertRotation3D_F64.rodriguesToMatrix((Rodrigues_F64)new Rodrigues_F64(angle, axisX, axisY, axisZ), null);
    }

    public static DMatrixRMaj quaternion(double w, double x, double y, double z) {
        return ConvertRotation3D_F64.quaternionToMatrix((double)w, (double)x, (double)y, (double)z, null);
    }

    public static SimpleImageClassification imageClassification(String which) {
        ClassifierAndSource cs;
        if (which.compareTo("VGG") == 0) {
            cs = FactoryImageClassifier.vgg_cifar10();
        } else if (which.compareTo("NIN") == 0) {
            cs = FactoryImageClassifier.nin_imagenet();
        } else {
            throw new IllegalArgumentException("Unknown model.  Valid options.  VGG, NIN");
        }
        return new SimpleImageClassification(cs);
    }

    public static SimpleQrCode detectQR() {
        return new SimpleQrCode();
    }

    public static PImage renderQR(String message, int pixelPerModule) {
        return SimpleQrCode.generate(message, pixelPerModule);
    }

    public static SimpleMotionDetection motionDetector(ConfigBackgroundGmm config) {
        return new SimpleMotionDetection(config);
    }

    public static SimpleMotionDetection motionDetector(ConfigBackgroundBasic config) {
        return new SimpleMotionDetection(config);
    }

    public static SimpleTemplateMatching templateMatching(TemplateScoreType type) {
        if (type == null) {
            type = TemplateScoreType.SUM_SQUARE_ERROR;
        }
        TemplateMatching alg = FactoryTemplateMatching.createMatcher((TemplateScoreType)type, GrayU8.class);
        return new SimpleTemplateMatching((TemplateMatching<GrayU8>)alg);
    }
}

