/*
 * Decompiled with CFR 0.152.
 */
import boofcv.alg.filter.binary.Contour;
import boofcv.processing.Boof;
import boofcv.processing.ResultsBlob;
import boofcv.processing.SimpleGray;
import boofcv.struct.image.ImageDataType;
import drop.DropEvent;
import drop.DropListener;
import drop.SDrop;
import georegression.struct.point.Point2D_I32;
import gifAnimation.GifMaker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.apache.commons.io.FilenameUtils;
import org.imgscalr.Scalr;
import processing.awt.PSurfaceAWT;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;

public class TexTuring
extends PApplet {
    GifMaker gifExport;
    SDrop drop;
    MyDropListener dropListener;
    boolean control = false;
    boolean viewing = false;
    boolean threshold = true;
    boolean lastFrameAnimation = false;
    boolean isRendering = false;
    boolean killRender = false;
    boolean synchroScroll = false;
    boolean updateViewImg = false;
    boolean updateMessage = false;
    PImage src;
    int h;
    int w;
    int off;
    int offX;
    int offY;
    int viewSize = 100;
    int renderProgress = 0;
    float lastRenderTime;
    int lastExportWidth = 0;
    String loadedFileName = "";
    File lastDirectory = null;
    GuiWindow gui;
    Parameters params;
    int listenerWidth;
    int listenerHeight;
    float uvv;
    float u;
    float v;
    float diffU;
    float diffV;
    float lapU;
    float lapV;
    float[] MINI = new float[]{0.0f, 0.01f, 0.03f, 0.005f};
    float[] MAXI = new float[]{0.15f, 0.08f, 0.11f, 0.05f};
    float NOISE_ZOOM = 0.1f;
    int[] C = new int[26];
    int bg = this.color(225);
    int colorActive;
    int a = 200;
    int b = 5;
    int c = 20;
    int d = 10;
    int haut = 60;
    int gauche = 65;
    PImage renderMin;
    PImage renderMinDone;

    public void settings() {
        this.size(this.displayWidth, this.displayHeight);
    }

    public void setup() {
        this.listenerHeight = this.height;
        this.listenerWidth = this.width;
        this.frameRate(30.0f);
        this.params = new Parameters();
        this.gui = new GuiWindow();
        this.gui.setupGui();
        this.fileSelected(new File(this.dataPath("Jaguar.png")));
        this.gui.elements.get(0).scroll(4);
        this.params.loadFile(new File(this.dataPath("default.texturing")));
    }

    public void draw() {
        this.resizeListener();
        this.gui.elements.get(9).update();
        if (this.synchroScroll) {
            this.gui.elements.get(0).dragged();
        }
        if (this.viewing || this.updateViewImg) {
            this.gui.elements.get(0).update();
        }
        if (this.updateViewImg) {
            this.updateViewImg = false;
        }
        if (this.updateMessage) {
            this.updateMessage = false;
            this.gui.elements.get(1).update();
            this.gui.elements.get(21).update();
        }
    }

    public void mousePressed() {
        this.gui.injectMousePressed();
    }

    public void mouseReleased() {
        this.gui.injectMouseReleased();
    }

    public void mouseMoved() {
        this.gui.injectMouseMoved();
    }

    public void mouseDragged() {
        this.gui.injectMouseDragged();
    }

    public void mouseWheel(processing.event.MouseEvent event) {
        this.gui.injectMouseWheel(event.getCount());
    }

    public void keyReleased() {
        this.control = false;
    }

    public void resizeListener() {
        if (this.listenerWidth != this.width || this.listenerHeight != this.height) {
            if (this.width < 800) {
                this.surface.setSize(800, this.height);
            }
            if (this.height < 700) {
                this.surface.setSize(this.width, 700);
            }
            this.listenerWidth = this.width;
            this.listenerHeight = this.height;
            this.gui.resize();
            this.gui.update();
        }
    }

    public void exportImage() {
        String[] extention = new String[]{".png     image", ".gif     animation", ".pdf     vectors", ".svg     vectors"};
        JTextField nameField = new JTextField(30);
        nameField.setText(String.valueOf(this.loadedFileName) + "_TexTuring-" + PApplet.parseInt((float)this.random(9999.0f)));
        JTextField widthField = new JTextField(5);
        int advisedWidth = TexTuring.constrain((int)(this.params.o[2] * this.src.width / 50), (int)2000, (int)20000);
        widthField.setText("" + PApplet.parseInt((float)(advisedWidth > this.lastExportWidth || this.lastExportWidth == 0 ? advisedWidth : this.lastExportWidth)));
        JComboBox<String> extField = new JComboBox<String>(new DefaultComboBoxModel<String>(extention));
        JFileChooser pathField = new JFileChooser();
        if (this.lastDirectory != null) {
            pathField.setCurrentDirectory(this.lastDirectory);
        }
        pathField.setFileSelectionMode(1);
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(pathField);
        JPanel p2 = new JPanel(new FlowLayout(0));
        JPanel p3 = new JPanel(new FlowLayout(0));
        p2.setBorder(BorderFactory.createEmptyBorder(50, 20, 5, 5));
        p3.setBorder(BorderFactory.createEmptyBorder(0, 20, 5, 5));
        p2.add(new JLabel("Image width : "));
        p2.add(widthField);
        p2.add(new JLabel(" pixels"));
        p3.add(new JLabel("Image name : "));
        p3.add(nameField);
        p3.add(extField);
        JPanel outer = new JPanel(new BorderLayout());
        outer.add((Component)p1, "North");
        outer.add((Component)p2, "Center");
        outer.add((Component)p3, "South");
        int result = JOptionPane.showConfirmDialog(null, outer, "Select export options", 2, -1);
        if (result == 0) {
            this.lastExportWidth = PApplet.parseInt((String)widthField.getText()) != advisedWidth ? PApplet.parseInt((String)widthField.getText()) : 0;
            this.lastDirectory = pathField.getCurrentDirectory();
            String path = pathField.getCurrentDirectory() + File.separator + nameField.getText();
            if (TexTuring.split((String)((String)extField.getSelectedItem()), (char)' ')[0].equals(".gif")) {
                this.gifExport = new GifMaker((PApplet)this, String.valueOf(path) + ".gif");
            }
            new ExportThread(path, PApplet.parseInt((String)widthField.getText()), TexTuring.split((String)((String)extField.getSelectedItem()), (char)' ')[0]).start();
            this.isRendering = true;
        }
    }

    public void saveImage(PImage img, String path) {
        PGraphics pg = null;
        pg = this.createGraphics(img.width, img.height);
        pg.beginDraw();
        pg.image(img, 0.0f, 0.0f);
        pg.endDraw();
        pg.get().save(path);
    }

    public void fileSelected(File selection) {
        if (selection != null) {
            this.loadedFileName = FilenameUtils.removeExtension((String)selection.getName());
            PImage tmp = this.loadImage(selection.getAbsolutePath());
            tmp.filter(12);
            this.src = this.createImage(tmp.width, tmp.height, 4);
            this.src.copy(tmp, 0, 0, this.src.width, this.src.height, 0, 0, this.src.width, this.src.height);
            this.w = this.src.width;
            this.h = this.src.height;
            this.gui.update();
            this.gui.elements.get(0).initView();
            this.viewing = true;
        }
    }

    public void folderSelected(File selection) {
        if (selection != null) {
            File[] files;
            File viewFile = null;
            File[] fileArray = files = selection.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && this.validImageFile(file)) {
                    this.gui.listOfFiles.add(file);
                    viewFile = file;
                }
                ++n2;
            }
            if (viewFile != null) {
                this.fileSelected(viewFile);
                this.gui.state = "multiFiles";
                this.gui.message(String.valueOf(this.gui.listOfFiles.size()) + " images loaded");
            }
        }
    }

    public PImage render(PImage img, int widthOut, String state) {
        int imgWidth = PApplet.parseInt((float)(this.params.o[2] * img.width / 100));
        if (imgWidth < 5) {
            imgWidth = 5;
        }
        img.resize(imgWidth, 0);
        this.algoReactionDiffusion(img, state);
        if (state.equals("export") || state.equals("animate")) {
            BufferedImage scaledImg = Scalr.resize((BufferedImage)((BufferedImage)img.getNative()), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_TO_WIDTH, (int)widthOut, (BufferedImageOp[])new BufferedImageOp[0]);
            img = new PImage((Image)scaledImg);
        } else {
            img.resize(widthOut, 0);
        }
        this.thresholdImg(img);
        return img;
    }

    public void thresholdImg(PImage img) {
        if (this.threshold) {
            img.filter(16, TexTuring.map((float)this.params.o[1], (float)0.0f, (float)255.0f, (float)0.0f, (float)1.0f));
        }
    }

    public PImage algoReactionDiffusion(PImage img, String state) {
        int W = img.width;
        int H = img.height;
        int[][] offsetW = new int[W][2];
        int[][] offsetH = new int[H][2];
        float[][] U = new float[W][H];
        float[][] V = new float[W][H];
        float time = this.millis();
        int i = 0;
        while (i < W) {
            int j = 0;
            while (j < H) {
                if (this.params.iniState == 0) {
                    U[i][j] = 0.0f;
                    V[i][j] = this.random(1.0f) * 0.7f;
                }
                if (this.params.iniState == 1) {
                    U[i][j] = 0.0f;
                    V[i][j] = this.noise((float)i * this.NOISE_ZOOM, (float)j * this.NOISE_ZOOM) * 0.7f;
                }
                if (this.params.iniState == 2) {
                    U[i][j] = 0.15f;
                    V[i][j] = 0.7f;
                }
                ++j;
            }
            ++i;
        }
        float[][][] fkuv = new float[W][H][4];
        float[] b = new float[5];
        float[] w = new float[5];
        int k = 0;
        while (k < 4) {
            b[k] = TexTuring.map((float)this.params.b[k], (float)0.0f, (float)200.0f, (float)this.MINI[k], (float)this.MAXI[k]);
            ++k;
        }
        k = 0;
        while (k < 4) {
            w[k] = TexTuring.map((float)this.params.w[k], (float)0.0f, (float)200.0f, (float)this.MINI[k], (float)this.MAXI[k]);
            ++k;
        }
        float midU = TexTuring.map((float)(this.params.b[2] + this.params.w[2]), (float)0.0f, (float)400.0f, (float)this.MINI[2], (float)this.MAXI[2]);
        float midV = TexTuring.map((float)(this.params.b[3] + this.params.w[3]), (float)0.0f, (float)400.0f, (float)this.MINI[3], (float)this.MAXI[3]);
        int i2 = 0;
        while (i2 < W) {
            int j = 0;
            while (j < H) {
                if (state.equals("renderMapImg")) {
                    fkuv[i2][j][0] = TexTuring.map((float)i2, (float)0.0f, (float)H, (float)this.MINI[0], (float)this.MAXI[0]);
                    fkuv[i2][j][1] = TexTuring.map((float)j, (float)0.0f, (float)W, (float)this.MAXI[1], (float)this.MINI[0]);
                    fkuv[i2][j][2] = midU;
                    fkuv[i2][j][3] = midV;
                } else {
                    int k2 = 0;
                    while (k2 < 4) {
                        fkuv[i2][j][k2] = TexTuring.map((float)this.brightness(img.pixels[j * W + i2]), (float)0.0f, (float)255.0f, (float)b[k2], (float)w[k2]);
                        ++k2;
                    }
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < W) {
            offsetW[i2][0] = i2 - 1;
            offsetW[i2][1] = i2 + 1;
            ++i2;
        }
        i2 = 0;
        while (i2 < H) {
            offsetH[i2][0] = i2 - 1;
            offsetH[i2][1] = i2 + 1;
            ++i2;
        }
        offsetW[0][0] = 0;
        offsetW[W - 1][1] = W - 1;
        offsetH[0][0] = 0;
        offsetH[H - 1][1] = H - 1;
        int n = 0;
        int nMax = this.params.o[0];
        n = 0;
        while (n < nMax) {
            int i3 = 0;
            while (i3 < W) {
                int j = 0;
                while (j < H) {
                    this.lapU = U[offsetW[i3][0]][j] + U[offsetW[i3][1]][j] + U[i3][offsetH[j][0]] + U[i3][offsetH[j][1]] - 4.0f * U[i3][j];
                    this.lapV = V[offsetW[i3][0]][j] + V[offsetW[i3][1]][j] + V[i3][offsetH[j][0]] + V[i3][offsetH[j][1]] - 4.0f * V[i3][j];
                    this.uvv = U[i3][j] * V[i3][j] * V[i3][j];
                    float[] fArray = U[i3];
                    int n2 = j;
                    fArray[n2] = fArray[n2] + (fkuv[i3][j][2] * this.lapU - this.uvv + fkuv[i3][j][0] * (1.0f - U[i3][j])) * 1.38f;
                    float[] fArray2 = V[i3];
                    int n3 = j;
                    fArray2[n3] = fArray2[n3] + (fkuv[i3][j][3] * this.lapV + this.uvv - (fkuv[i3][j][1] + fkuv[i3][j][0]) * V[i3][j]) * 0.63f;
                    ++j;
                }
                ++i3;
            }
            if ((state.equals("export") || state.equals("animate")) && n % PApplet.parseInt((float)(this.params.o[0] / 100 + 1)) == 0) {
                this.renderProgress = PApplet.parseInt((float)(100 * n / (this.params.o[0] + 1)));
                this.gui.message("Rendering : " + this.renderProgress + " %  ");
            }
            if ((state.equals("export") || state.equals("animate")) && n % 30 == 3) {
                ((ViewPort)this.gui.elements.get((int)0)).dataAnimation = U;
                this.updateViewImg = true;
            }
            if (state.equals("export") && n == this.params.o[0] - 1) {
                ((ViewPort)this.gui.elements.get((int)0)).dataAnimation = U;
                this.lastFrameAnimation = true;
                this.updateViewImg = true;
                this.gui.message("Saving file ...");
            }
            if (this.killRender) {
                n = this.params.o[0] - 2;
                this.killRender = false;
            }
            if (Thread.currentThread().isInterrupted()) break;
            ++n;
        }
        if (Thread.currentThread().isInterrupted()) {
            this.lastRenderTime = (float)(nMax / n) * ((float)this.millis() - time) / 1000.0f;
        }
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        this.writeImg(img, U);
        this.lastRenderTime = ((float)this.millis() - time) / 1000.0f;
        return img;
    }

    public void writeImg(PImage img, float[][] U) {
        int i = 0;
        while (i < img.width) {
            int j = 0;
            while (j < img.height) {
                int pShift = PApplet.parseInt((float)(U[i][j] * 255.0f));
                img.pixels[j * img.width + i] = 0xFF000000 | pShift << 16 | pShift << 8 | pShift;
                ++j;
            }
            ++i;
        }
    }

    public void keyPressed() {
        if (this.key == '+') {
            this.gui.elements.get(0).scroll(-1);
        }
        if (this.key == '-') {
            this.gui.elements.get(0).scroll(1);
        }
        if (this.key == ' ') {
            this.gui.elements.get(0).renderView();
        }
        if (this.key == '\n') {
            this.gui.elements.get(0).renderView();
        }
        if (this.keyCode == 17) {
            this.control = true;
        }
    }

    public void buttonPressed(GuiElement e) {
        if (e.name == "Select file") {
            this.selectInput("Select a new image", "fileSelected");
        }
        if (e.name == "Select folder") {
            this.selectFolder("Select a folder to process:", "folderSelected");
        }
        if (e.name == "Save  image") {
            this.exportImage();
        }
        if (e.name == "Load settings") {
            this.selectInput("Select TexTuring settings file", "loadFile");
            this.viewing = true;
        }
        if (e.name == "Save settings") {
            this.selectOutput("Name your TexTuring settings file", "saveFile");
        }
        String cfr_ignored_0 = e.name;
        if (e.name == "check threshold") {
            this.threshold = !this.threshold;
            this.viewing = true;
        }
        if (e.name == "Render  preview") {
            this.gui.elements.get(0).renderView();
        }
        if (e.name == " +") {
            this.gui.elements.get(0).scroll(-1);
        }
        if (e.name == " -") {
            this.gui.elements.get(0).scroll(1);
        }
        if (e.name == "About") {
            this.gui.about();
        }
        GuiElement e16 = this.gui.elements.get(16);
        GuiElement e17 = this.gui.elements.get(17);
        GuiElement e18 = this.gui.elements.get(18);
        if (e.name == "random") {
            this.params.iniState = 0;
            this.viewing = true;
            this.synchroScroll = true;
            e.isSelected = true;
            e17.isSelected = false;
            e18.isSelected = false;
            this.gui.update();
        }
        if (e.name == "noise") {
            this.params.iniState = 1;
            this.viewing = true;
            this.synchroScroll = true;
            e.isSelected = true;
            e16.isSelected = false;
            e18.isSelected = false;
            this.gui.update();
        }
        if (e.name == "uniform") {
            this.params.iniState = 2;
            this.viewing = true;
            this.synchroScroll = true;
            e.isSelected = true;
            e16.isSelected = false;
            e17.isSelected = false;
            this.gui.update();
        }
        this.mousePressed = false;
    }

    public void loadFile(File _file) {
        this.params.loadFile(_file);
    }

    public void saveFile(File _file) {
        this.params.saveFile(_file);
    }

    public void styleSelecStroke() {
        this.stroke(this.C[15]);
        this.noFill();
    }

    public void styleSelec() {
        this.fill(this.C[15]);
        this.noStroke();
    }

    public void fontColor() {
        this.fill(this.C[0]);
    }

    public void renderViewThread() {
        ViewPort vp = (ViewPort)this.gui.elements.get(0);
        PImage img = vp.viewImg.get();
        img = this.render(img, (int)vp.coords.size.x * 3, "animate");
        img.resize(img.width / 3, img.height / 3);
        vp.viewImg = img.get();
        this.isRendering = false;
        vp.updateViewPort = true;
        this.updateViewImg = true;
        this.gui.message("Last render in " + PApplet.parseInt((float)this.lastRenderTime) + " sec");
    }

    public void renderMapImg() {
        PImage mapImg = this.gui.elements.get((int)9).mapImg.get();
        float s = this.gui.elements.get((int)9).coords.size.x;
        mapImg.resize(PApplet.parseInt((float)((s - 20.0f) / 1.6f)), PApplet.parseInt((float)((s - 20.0f) / 1.6f)));
        mapImg = this.algoReactionDiffusion(mapImg, "renderMapImg");
        mapImg.resize(PApplet.parseInt((float)(s - 20.0f)) * 3, 0);
        this.thresholdImg(mapImg);
        mapImg.resize(PApplet.parseInt((float)(s - 20.0f)), 0);
        this.gui.elements.get((int)9).mapImg = mapImg;
    }

    public void initDrop() {
        this.drop = new SDrop((PApplet)this);
        this.dropListener = new MyDropListener();
        this.drop.addDropListener((DropListener)this.dropListener);
    }

    public void dropEvent(DropEvent event) {
    }

    public boolean isOver(float x, float y, float w, float h) {
        return (float)this.mouseX >= x && (float)this.mouseX <= x + w && (float)this.mouseY >= y && (float)this.mouseY <= y + h;
    }

    public boolean validImageFile(File file) {
        String[] ext;
        boolean isValid = false;
        String fileName = file.getName().toLowerCase();
        String[] stringArray = ext = new String[]{".gif", ".jpg", ".tga", ".png"};
        int n = ext.length;
        int n2 = 0;
        while (n2 < n) {
            String o = stringArray[n2];
            if (fileName.endsWith(o)) {
                isValid = true;
            }
            ++n2;
        }
        return isValid;
    }

    public void vectorization(PImage img, String fileName, int format) {
        PGraphics vecto = null;
        if (format == 1) {
            vecto = this.createGraphics(img.width / 3, img.height / 3, "processing.pdf.PGraphicsPDF", fileName);
        }
        if (format == 2) {
            vecto = this.createGraphics(img.width / 3, img.height / 3, "processing.svg.PGraphicsSVG", fileName);
        }
        vecto.beginDraw();
        vecto.background(255);
        vecto.noStroke();
        vecto.fill(0);
        SimpleGray gray = Boof.gray((PImage)img, (ImageDataType)ImageDataType.F32);
        ResultsBlob results = gray.threshold((double)this.params.o[1], true).contour();
        for (Contour contour : results.contour) {
            vecto.beginShape();
            this.drawBlob(vecto, contour.external, 4);
            for (List pts : contour.internal) {
                vecto.beginContour();
                this.drawBlob(vecto, pts, 4);
                vecto.endContour();
            }
            vecto.endShape(2);
        }
        vecto.dispose();
        vecto.endDraw();
    }

    public void drawBlob(PGraphics vecto, List<Point2D_I32> points32, int minimumBlobPoints) {
        if (points32.size() > minimumBlobPoints) {
            List<PVector> points = new ArrayList<PVector>();
            for (Point2D_I32 p : points32) {
                points.add(new PVector((float)p.x, (float)p.y));
            }
            points = this.smoothLine(points, 5);
            vecto.vertex(points.get((int)0).x / 3.0f, points.get((int)0).y / 3.0f);
            vecto.curveVertex(points.get((int)(points.size() - 1)).x / 3.0f, points.get((int)(points.size() - 1)).y / 3.0f);
            int i = 0;
            while (i < points.size()) {
                vecto.curveVertex(points.get((int)i).x / 3.0f, points.get((int)i).y / 3.0f);
                i += 4;
            }
            vecto.curveVertex(points.get((int)0).x / 3.0f, points.get((int)0).y / 3.0f);
            vecto.curveVertex(points.get((int)1).x / 3.0f, points.get((int)1).y / 3.0f);
        }
    }

    public List<PVector> smoothLine(List<PVector> points, int pointsAdjacents) {
        int p = pointsAdjacents;
        if (points.size() < p * 2) {
            return points;
        }
        ArrayList<PVector> smoothedPoints = new ArrayList<PVector>();
        int i = 0;
        while (i < points.size()) {
            ArrayList<PVector> tmp = new ArrayList<PVector>();
            int j = p;
            while (j >= 1) {
                tmp.add(points.get(i - j < 0 ? points.size() + i - j : i - j));
                --j;
            }
            tmp.add(points.get(i));
            j = 1;
            while (j <= p) {
                tmp.add(points.get(i + j >= points.size() ? i + j - points.size() : i + j));
                ++j;
            }
            smoothedPoints.add(this.smoothPoint(tmp));
            ++i;
        }
        return smoothedPoints;
    }

    public PVector smoothPoint(List<PVector> points) {
        float avgX = 0.0f;
        float avgY = 0.0f;
        for (PVector point : points) {
            avgX += point.x;
            avgY += point.y;
        }
        return new PVector(avgX /= (float)points.size(), avgY /= (float)points.size());
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"TexTuring"};
        if (passedArgs != null) {
            PApplet.main((String[])TexTuring.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class BiSlider
    extends GuiElement {
        int m;
        int sh;
        float pos1;
        float pos2;
        float pos3;
        float zone;
        Rect[] handle;
        PImage grad;
        PImage gradInvert;
        String txt;

        BiSlider(Rect _coords, String _name, String _txt) {
            super(_coords, _name);
            this.sh = 20;
            this.handle = new Rect[3];
            this.txt = _txt;
            this.grad = TexTuring.this.loadImage("gradient.png");
            this.gradInvert = TexTuring.this.loadImage("gradInvert.png");
            this.update();
        }

        @Override
        public void pressed() {
            if (this.handle[0].isOver()) {
                this.zone = 1.0f;
                this.pos1 = TexTuring.this.mouseX;
            }
            if (this.handle[1].isOver()) {
                this.zone = 2.0f;
                this.pos2 = TexTuring.this.mouseX;
            }
            if (this.handle[2].isOver()) {
                this.zone = 3.0f;
                this.pos3 = TexTuring.this.mouseX;
            }
        }

        @Override
        public void released() {
            if (this.zone != 0.0f) {
                TexTuring.this.gui.elements.get(9).updateMapImg();
            }
            this.zone = 0.0f;
        }

        @Override
        public void dragged() {
            if (this.zone != 0.0f) {
                this.m = TexTuring.this.mouseX;
                int n = TexTuring.this.off = TexTuring.this.control ? 20 : 1;
                if (this.zone == 1.0f) {
                    int n2 = this.ref;
                    TexTuring.this.params.b[n2] = TexTuring.this.params.b[n2] + ((float)this.m - this.pos1) / (float)TexTuring.this.off;
                    this.pos1 = this.m;
                    TexTuring.this.params.b[this.ref] = TexTuring.constrain((float)TexTuring.this.params.b[this.ref], (float)0.0f, (float)(this.coords.size.x - 10.0f));
                }
                if (this.zone == 2.0f) {
                    int n3 = this.ref;
                    TexTuring.this.params.w[n3] = TexTuring.this.params.w[n3] + ((float)this.m - this.pos2) / (float)TexTuring.this.off;
                    this.pos2 = this.m;
                    TexTuring.this.params.w[this.ref] = TexTuring.constrain((float)TexTuring.this.params.w[this.ref], (float)0.0f, (float)(this.coords.size.x - 10.0f));
                }
                if (this.zone == 3.0f) {
                    int n4 = this.ref;
                    TexTuring.this.params.b[n4] = TexTuring.this.params.b[n4] + ((float)this.m - this.pos3) / (float)TexTuring.this.off;
                    int n5 = this.ref;
                    TexTuring.this.params.w[n5] = TexTuring.this.params.w[n5] + ((float)this.m - this.pos3) / (float)TexTuring.this.off;
                    TexTuring.this.params.b[this.ref] = TexTuring.constrain((float)TexTuring.this.params.b[this.ref], (float)0.0f, (float)(this.coords.size.x - 10.0f));
                    TexTuring.this.params.w[this.ref] = TexTuring.constrain((float)TexTuring.this.params.w[this.ref], (float)0.0f, (float)(this.coords.size.x - 10.0f));
                    this.pos3 = this.m;
                }
                this.update();
                TexTuring.this.viewing = true;
            }
        }

        @Override
        public void update() {
            float b = TexTuring.this.params.b[this.ref];
            float w = TexTuring.this.params.w[this.ref];
            this.handle[0] = new Rect(this.coords.pos.x + b - 18.0f, this.coords.pos.y + 0.0f, 36.0f, this.sh - 3);
            this.handle[1] = new Rect(this.coords.pos.x + w - 18.0f, this.coords.pos.y + (float)(2 * this.sh) + 3.0f, 36.0f, this.sh - 3);
            this.handle[2] = new Rect(this.coords.pos.x, this.coords.pos.y + (float)this.sh + 3.0f, this.coords.size.x - 10.0f, this.sh - 6);
            TexTuring.this.fill(TexTuring.this.bg);
            TexTuring.this.rect(this.coords.pos.x - 18.0f, this.coords.pos.y, this.coords.size.x + 26.0f, 3 * this.sh);
            TexTuring.this.fill(this.handle[2].isOver() || this.handle[1].isOver() || this.handle[0].isOver() ? TexTuring.this.C[19] : TexTuring.this.C[20]);
            this.drawRect(this.handle[2]);
            TexTuring.this.fill(this.handle[0].isOver() || this.handle[2].isOver() ? TexTuring.this.colorActive : TexTuring.this.C[20]);
            this.drawRect(this.handle[0]);
            TexTuring.this.fill(this.handle[1].isOver() || this.handle[2].isOver() ? TexTuring.this.colorActive : TexTuring.this.C[20]);
            this.drawRect(this.handle[1]);
            TexTuring.this.pushMatrix();
            TexTuring.this.translate(this.coords.pos.x, this.coords.pos.y);
            TexTuring.this.fill(this.handle[0].isOver() || this.handle[2].isOver() ? TexTuring.this.colorActive : TexTuring.this.C[20]);
            TexTuring.this.triangle(b - 18.0f, this.sh - 3, b + 18.0f, this.sh - 3, b, this.sh + 3);
            TexTuring.this.fill(this.handle[1].isOver() || this.handle[2].isOver() ? TexTuring.this.colorActive : TexTuring.this.C[20]);
            TexTuring.this.triangle(w - 18.0f, 2 * this.sh + 3, w + 18.0f, 2 * this.sh + 3, w, 2 * this.sh - 3);
            TexTuring.this.fontColor();
            TexTuring.this.text(this.txt, 0.0f, -2.0f);
            TexTuring.this.textAlign(3);
            TexTuring.this.fill(this.handle[0].isOver() || this.handle[2].isOver() ? 0 : TexTuring.this.C[0]);
            TexTuring.this.text(PApplet.parseInt((float)b), b, this.sh - 3 - 3);
            TexTuring.this.fill(this.handle[1].isOver() || this.handle[2].isOver() ? 0 : TexTuring.this.C[0]);
            TexTuring.this.text(PApplet.parseInt((float)w), w, 3 * this.sh - 5);
            if (b < w) {
                TexTuring.this.image(this.gradInvert, b, this.sh + 3, w - b, this.sh - 6);
            }
            if (b >= w) {
                TexTuring.this.image(this.grad, w, this.sh + 3, b - w, this.sh - 6);
            }
            TexTuring.this.popMatrix();
            TexTuring.this.textAlign(37);
        }
    }

    class Button
    extends GuiElement {
        Button(Rect _coords, String _name) {
            super(_coords, _name);
            this.update();
        }

        @Override
        public void update() {
            if (this.isVisible) {
                if (this.name.equals("Render  preview") && TexTuring.this.isRendering) {
                    TexTuring.this.fill(this.isOver() ? TexTuring.this.C[8] : TexTuring.this.C[12]);
                    this.drawRect(this.coords);
                    TexTuring.this.fill(TexTuring.this.C[25]);
                    TexTuring.this.text("Stop", this.coords.pos.x + 5.0f, this.coords.pos.y + 15.0f);
                } else {
                    TexTuring.this.fill(this.isOver() ? TexTuring.this.C[15] : TexTuring.this.C[19]);
                    if (this.isSelected) {
                        TexTuring.this.fill(TexTuring.this.C[13]);
                    }
                    this.drawRect(this.coords);
                    TexTuring.this.fill(0);
                    TexTuring.this.text(this.name, this.coords.pos.x + 5.0f, this.coords.pos.y + 15.0f);
                }
            } else {
                TexTuring.this.fill(TexTuring.this.C[24]);
                this.drawRect(this.coords);
            }
        }

        @Override
        public void pressed() {
            TexTuring.this.buttonPressed(this);
        }

        @Override
        public void resize() {
            if (this.name.equals("About")) {
                this.coords = new Rect((float)(TexTuring.this.width - TexTuring.this.d) - this.coords.size.x, this.coords.pos.y, this.coords.size.x, this.coords.size.y);
            }
        }
    }

    class CheckBox
    extends GuiElement {
        boolean b;

        CheckBox(Rect _coords, String _name) {
            super(_coords, _name);
            this.b = false;
            this.update();
        }

        @Override
        public void update() {
            TexTuring.this.fill(TexTuring.this.C[20]);
            if (this.isOver()) {
                TexTuring.this.fill(TexTuring.this.C[19]);
            }
            this.drawRect(this.coords);
            TexTuring.this.fill(this.b ? TexTuring.this.C[18] : TexTuring.this.C[14]);
            if (this.isOver()) {
                TexTuring.this.fill(TexTuring.this.colorActive);
            }
            TexTuring.this.rect(this.coords.pos.x + 4.0f, this.coords.pos.y + 4.0f, this.coords.size.x - 8.0f, this.coords.size.y - 8.0f);
        }

        @Override
        public void pressed() {
            TexTuring.this.buttonPressed(this);
            this.b = !this.b;
            TexTuring.this.gui.elements.get(9).updateMapImg();
            TexTuring.this.gui.injectMouseMoved();
        }
    }

    class DiSlider
    extends GuiElement {
        Rect[] handle;
        float pos1;
        float pos2;
        float pos3;
        float pos11;
        float pos22;
        float pos33;
        float zone;
        float s;
        float sh;
        float x;
        float y;
        PImage grad;
        PImage gradInvert;

        DiSlider(Rect _coords, String _name) {
            super(_coords, _name);
            this.handle = new Rect[2];
            this.x = this.coords.pos.x;
            this.y = this.coords.pos.y;
            this.s = this.coords.size.x;
            this.sh = this.coords.size.y;
            this.mapImg = TexTuring.this.createImage(PApplet.parseInt((float)10.0f), PApplet.parseInt((float)10.0f), 2);
            this.grad = TexTuring.this.loadImage("gradient.png");
            this.gradInvert = TexTuring.this.loadImage("gradInvert.png");
        }

        @Override
        public void moved() {
        }

        @Override
        public void pressed() {
            if (this.coords.isOver()) {
                this.zone = 3.0f;
                this.pos1 = TexTuring.this.mouseX;
                this.pos11 = TexTuring.this.mouseY;
                this.pos2 = TexTuring.this.mouseX;
                this.pos22 = TexTuring.this.mouseY;
            }
            if (this.handle[0].isOver()) {
                this.zone = 1.0f;
                this.pos1 = TexTuring.this.mouseX;
                this.pos11 = TexTuring.this.mouseY;
            }
            if (this.handle[1].isOver()) {
                this.zone = 2.0f;
                this.pos2 = TexTuring.this.mouseX;
                this.pos22 = TexTuring.this.mouseY;
            }
        }

        @Override
        public void released() {
            this.zone = 0.0f;
        }

        @Override
        public void dragged() {
            if (this.zone != 0.0f) {
                float cfr_ignored_0 = this.coords.size.x;
                float cfr_ignored_1 = TexTuring.this.params.b[1];
                float cfr_ignored_2 = this.coords.size.x;
                float cfr_ignored_3 = TexTuring.this.params.w[1];
                int n = TexTuring.this.off = TexTuring.this.control ? 20 : 1;
                if (this.zone == 1.0f || this.zone == 3.0f) {
                    TexTuring.this.params.b[0] = TexTuring.this.params.b[0] + ((float)TexTuring.this.mouseX - this.pos1) / (float)TexTuring.this.off;
                    this.pos1 = TexTuring.this.mouseX;
                    TexTuring.this.params.b[1] = TexTuring.this.params.b[1] - ((float)TexTuring.this.mouseY - this.pos11) / (float)TexTuring.this.off;
                    this.pos11 = TexTuring.this.mouseY;
                    TexTuring.this.params.b[0] = TexTuring.constrain((float)TexTuring.this.params.b[0], (float)0.0f, (float)(this.coords.size.x - 20.0f));
                    TexTuring.this.params.b[1] = TexTuring.constrain((float)TexTuring.this.params.b[1], (float)0.0f, (float)(this.coords.size.x - 20.0f));
                }
                if (this.zone == 2.0f || this.zone == 3.0f) {
                    TexTuring.this.params.w[0] = TexTuring.this.params.w[0] + ((float)TexTuring.this.mouseX - this.pos2) / (float)TexTuring.this.off;
                    this.pos2 = TexTuring.this.mouseX;
                    TexTuring.this.params.w[1] = TexTuring.this.params.w[1] - ((float)TexTuring.this.mouseY - this.pos22) / (float)TexTuring.this.off;
                    this.pos22 = TexTuring.this.mouseY;
                    TexTuring.this.params.w[0] = TexTuring.constrain((float)TexTuring.this.params.w[0], (float)0.0f, (float)(this.coords.size.x - 20.0f));
                    TexTuring.this.params.w[1] = TexTuring.constrain((float)TexTuring.this.params.w[1], (float)0.0f, (float)(this.coords.size.x - 20.0f));
                }
                this.update();
                TexTuring.this.viewing = true;
            }
        }

        @Override
        public void updateMapImg() {
            this.mapImg.filter(11, 1.5f);
            TexTuring.this.thread("renderMapImg");
        }

        @Override
        public void update() {
            if (TexTuring.this.frameCount % 6 == 0 || this.isOver()) {
                float b5 = this.s - TexTuring.this.params.b[1];
                float w5 = this.s - TexTuring.this.params.w[1];
                this.handle[0] = new Rect(this.x + TexTuring.this.params.b[0] - 10.0f, this.y + TexTuring.map((float)TexTuring.this.params.b[1], (float)0.0f, (float)this.s, (float)this.s, (float)0.0f) - 10.0f, 20.0f, 20.0f);
                this.handle[1] = new Rect(this.x + TexTuring.this.params.w[0] - 10.0f, this.y + TexTuring.map((float)TexTuring.this.params.w[1], (float)0.0f, (float)this.s, (float)this.s, (float)0.0f) - 10.0f, 20.0f, 20.0f);
                TexTuring.this.pushMatrix();
                TexTuring.this.translate(this.x, this.y);
                TexTuring.this.fill(TexTuring.this.bg);
                TexTuring.this.rect(-40.0f, -20.0f, this.s + 60.0f, this.s + 60.0f);
                TexTuring.this.fontColor();
                TexTuring.this.text(this.name, -50.0f, 10.0f);
                TexTuring.this.image(this.mapImg, 0.0f, 20.0f, this.s - 20.0f, this.s - 20.0f);
                TexTuring.this.fill(240, 180.0f);
                TexTuring.this.rect(0.0f, 20.0f, this.s - 20.0f, this.s - 20.0f);
                TexTuring.this.strokeWeight(this.handle[0].isOver() ? 8 : 5);
                TexTuring.this.stroke(this.handle[0].isOver() || this.isOver() && !this.handle[1].isOver() ? TexTuring.this.colorActive : TexTuring.this.C[20]);
                TexTuring.this.ellipse(TexTuring.this.params.b[0], b5, 15.0f, 15.0f);
                TexTuring.this.strokeWeight(this.handle[1].isOver() ? 8 : 5);
                TexTuring.this.stroke(this.handle[1].isOver() || this.isOver() && !this.handle[0].isOver() ? TexTuring.this.colorActive : TexTuring.this.C[20]);
                TexTuring.this.ellipse(TexTuring.this.params.w[0], w5, 15.0f, 15.0f);
                TexTuring.this.strokeWeight(1.0f);
                TexTuring.this.noStroke();
                int i = 0;
                while (i <= 50) {
                    TexTuring.this.fill(5 * i);
                    TexTuring.this.ellipse(TexTuring.this.params.b[0] + (float)i * (TexTuring.this.params.w[0] - TexTuring.this.params.b[0]) / 50.0f, b5 + (float)i * (w5 - b5) / 50.0f, 10.0f, 10.0f);
                    ++i;
                }
                TexTuring.this.popMatrix();
                this.updateSlider(0, this.x, this.y + this.s + 5.0f, this.s - 10.0f);
                this.updateSlider(1, this.x + this.s - 15.0f, this.y + this.s, this.s - 10.0f);
            }
        }

        public void updateSlider(int ref, float xx, float yy, float s) {
            int sh = 10;
            float b = TexTuring.this.params.b[ref];
            float w = TexTuring.this.params.w[ref];
            TexTuring.this.pushMatrix();
            TexTuring.this.translate(xx, yy);
            if (ref == 1) {
                TexTuring.this.rotate(-1.5707964f);
            }
            TexTuring.this.fill(TexTuring.this.C[22]);
            TexTuring.this.rect(0.0f, 0.0f, s - 10.0f, sh - 6);
            if (TexTuring.abs((float)(b - w)) < 36.0f) {
                float mid = b < w ? b + (w - b) / 2.0f : w + (b - w) / 2.0f;
                TexTuring.this.fill(TexTuring.this.C[20]);
                if (b < w) {
                    TexTuring.this.triangle(mid, 12.0f, mid - 36.0f, 12.0f, b, sh - 6);
                    TexTuring.this.triangle(mid, 12.0f, mid + 36.0f, 12.0f, w, sh - 6);
                }
                if (b >= w) {
                    TexTuring.this.triangle(mid, 12.0f, mid + 36.0f, 12.0f, b, sh - 6);
                    TexTuring.this.triangle(mid, 12.0f, mid - 36.0f, 12.0f, w, sh - 6);
                }
                TexTuring.this.rect(mid, 12.0f, -36.0f, 15.0f);
                TexTuring.this.rect(mid, 12.0f, 36.0f, 15.0f);
                TexTuring.this.fontColor();
                TexTuring.this.textAlign(3);
                if (b < w) {
                    TexTuring.this.text(PApplet.parseInt((float)b), mid - 18.0f, 2 * sh + 3);
                    TexTuring.this.text(PApplet.parseInt((float)w), mid + 18.0f, 2 * sh + 2);
                } else {
                    TexTuring.this.text(PApplet.parseInt((float)b), mid + 18.0f, 2 * sh + 3);
                    TexTuring.this.text(PApplet.parseInt((float)w), mid - 18.0f, 2 * sh + 2);
                }
                if (b < w) {
                    TexTuring.this.image(this.gradInvert, b, 0.0f, w - b, sh - 6);
                }
                if (b >= w) {
                    TexTuring.this.image(this.grad, w, 0.0f, b - w, sh - 6);
                }
            } else {
                TexTuring.this.fill(TexTuring.this.C[20]);
                TexTuring.this.triangle(b - 18.0f, 12.0f, b + 18.0f, 12.0f, b, sh - 6);
                TexTuring.this.triangle(w - 18.0f, 12.0f, w + 18.0f, 12.0f, w, sh - 6);
                TexTuring.this.rect(b - 18.0f, 12.0f, 36.0f, 15.0f);
                TexTuring.this.rect(w - 18.0f, 12.0f, 36.0f, 15.0f);
                TexTuring.this.fontColor();
                TexTuring.this.textAlign(3);
                TexTuring.this.text(PApplet.parseInt((float)b), b, 22.0f);
                TexTuring.this.text(PApplet.parseInt((float)w), w, 22.0f);
                if (b < w) {
                    TexTuring.this.image(this.gradInvert, b, 0.0f, w - b, sh - 6);
                }
                if (b >= w) {
                    TexTuring.this.image(this.grad, w, 0.0f, b - w, sh - 6);
                }
            }
            TexTuring.this.popMatrix();
            TexTuring.this.textAlign(37);
        }
    }

    class ExportThread
    extends Thread {
        String path;
        String ext;
        int widthField;

        public ExportThread(String path, int widthField, String ext) {
            this.path = path;
            this.ext = ext;
            this.widthField = widthField;
        }

        @Override
        public void run() {
            if (this.ext.equals(".png")) {
                if (TexTuring.this.gui.state == "multiFiles") {
                    if (TexTuring.this.gui.elements.get(7).isSnaped()) {
                        TexTuring.this.params.loadParameters(TexTuring.this.gui.elements.get((int)7).savedParams);
                    }
                    int i = 0;
                    while (i < TexTuring.this.gui.listOfFiles.size()) {
                        TexTuring.this.src = TexTuring.this.loadImage(TexTuring.this.gui.listOfFiles.get(i).getAbsolutePath());
                        if (TexTuring.this.gui.elements.get(8).isSnaped()) {
                            TexTuring.this.params.nextFrameAnimation(TexTuring.this.gui.listOfFiles.size(), TexTuring.this.gui.elements.get((int)8).savedParams);
                        }
                        TexTuring.this.saveImage(TexTuring.this.render(TexTuring.this.src.get(), this.widthField, "export"), String.valueOf(this.path) + File.separator + TexTuring.this.gui.listOfFiles.get(i).getName());
                        ++i;
                    }
                } else {
                    TexTuring.this.saveImage(TexTuring.this.render(TexTuring.this.src.get(), this.widthField, "export"), String.valueOf(this.path) + ".png");
                }
            }
            if (this.ext.equals(".gif")) {
                JPanel p3 = new JPanel();
                JPanel p4 = new JPanel();
                JTextField nbrFrameField = new JTextField(4);
                nbrFrameField.setText("10");
                p3.add(nbrFrameField);
                p3.add(new JLabel("<html> frames from <i>begining sample</i> to <i>ending sample</i></html>"));
                JTextField durationField = new JTextField(4);
                durationField.setText("0.06");
                p4.add(durationField);
                p4.add(new JLabel("<html> seconds per frame</html>"));
                JPanel outer2 = new JPanel(new BorderLayout());
                outer2.add((Component)p3, "North");
                outer2.add((Component)p4, "South");
                int result2 = JOptionPane.showConfirmDialog(null, outer2, "Animation export options", 2, -1);
                if (result2 == 0) {
                    TexTuring.this.gifExport.setRepeat(0);
                    TexTuring.this.gifExport.setQuality(10);
                    if (TexTuring.this.gui.elements.get(7).isSnaped()) {
                        TexTuring.this.params.loadParameters(TexTuring.this.gui.elements.get((int)7).savedParams);
                    }
                    int i = 0;
                    while (i < PApplet.parseInt((String)nbrFrameField.getText())) {
                        PImage gifImg = TexTuring.this.render(TexTuring.this.src.get(), this.widthField * 3, "export");
                        gifImg.resize(this.widthField, 0);
                        TexTuring.this.gifExport.addFrame(gifImg);
                        TexTuring.this.gifExport.setDelay(PApplet.parseInt((float)(PApplet.parseFloat((String)durationField.getText()) * 1000.0f)));
                        TexTuring.this.params.nextFrameAnimation(PApplet.parseInt((String)nbrFrameField.getText()), TexTuring.this.gui.elements.get((int)8).savedParams);
                        ++i;
                    }
                    TexTuring.this.gifExport.finish();
                }
            }
            if (this.ext.equals(".pdf")) {
                TexTuring.this.vectorization(TexTuring.this.render(TexTuring.this.src.get(), PApplet.parseInt((float)(TexTuring.this.params.o[2] * TexTuring.this.src.width / 100)) * 4, "export"), String.valueOf(this.path) + ".pdf", 1);
            }
            if (this.ext.equals(".svg")) {
                TexTuring.this.vectorization(TexTuring.this.render(TexTuring.this.src.get(), PApplet.parseInt((float)(TexTuring.this.params.o[2] * TexTuring.this.src.width / 100)) * 4, "export"), String.valueOf(this.path) + ".svg", 2);
            }
            TexTuring.this.gui.message(String.valueOf(this.path) + this.ext + "   file saved.");
            TexTuring.this.isRendering = false;
            ((ViewPort)TexTuring.this.gui.elements.get(0)).frameAnimation();
        }
    }

    class GuiElement {
        Rect coords;
        String name;
        int ref;
        PImage mapImg;
        PImage viewImg;
        Rect viewZone;
        float zoom = 0.5240786f;
        boolean isOver = false;
        boolean isVisible = true;
        boolean dropState = false;
        boolean isSelected = false;
        Parameters savedParams;
        String flag = "";

        GuiElement() {
            this.coords = new Rect();
        }

        GuiElement(Rect _coords, String _name) {
            this.coords = _coords;
            this.name = _name;
            if (this.name == "iterations") {
                this.ref = 0;
            }
            if (this.name == "threshold") {
                this.ref = 1;
            }
            if (this.name == "resolution") {
                this.ref = 2;
            }
            if (this.name == "reaction") {
                this.ref = 2;
            }
            if (this.name == "diffusion") {
                this.ref = 3;
            }
        }

        public boolean isOver() {
            return this.coords.isOver(TexTuring.this.mouseX, TexTuring.this.mouseY);
        }

        public void update() {
        }

        public void moved() {
            this.update();
        }

        public void pressed() {
        }

        public void released() {
        }

        public void dragged() {
        }

        public void initView() {
        }

        public void drawRect(Rect r) {
            TexTuring.this.rect(r.pos.x, r.pos.y, r.size.x, r.size.y);
        }

        public void drawImage(PImage i, Rect r) {
            TexTuring.this.image(i, r.pos.x, r.pos.y, r.size.x, r.size.y);
        }

        public void drawText(Rect r, String text) {
            TexTuring.this.text(text, this.coords.pos.x + 5.0f, this.coords.pos.y);
        }

        public void renderView() {
        }

        public void scroll(int scroll) {
        }

        public void resize() {
        }

        public boolean isSnaped() {
            return false;
        }

        public void updateMapImg() {
        }

        public void message(String msg) {
        }
    }

    class GuiWindow {
        ArrayList<GuiElement> elements = new ArrayList();
        String state = "";
        ArrayList<File> listOfFiles = new ArrayList();

        GuiWindow() {
        }

        public void setupGui() {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            JFrame jframe = (JFrame)((PSurfaceAWT.SmoothCanvas)TexTuring.this.getSurface().getNative()).getFrame();
            jframe.setLocation(0, 0);
            jframe.setExtendedState(jframe.getExtendedState() | 6);
            TexTuring.this.surface.setResizable(true);
            TexTuring.this.surface.setTitle("TexTuring");
            TexTuring.this.surface.setIcon(TexTuring.this.loadImage("logo.png"));
            TexTuring.this.colorMode(3);
            int i = 0;
            while (i <= 25) {
                TexTuring.this.C[i] = TexTuring.this.color(133, 270 - i * 13, 105 + i * 5);
                ++i;
            }
            TexTuring.this.colorActive = TexTuring.this.C[12];
            TexTuring.this.background(TexTuring.this.bg);
            TexTuring.this.noStroke();
            PFont font = TexTuring.this.loadFont("PixelOperator-16.vlw");
            TexTuring.this.textFont(font, 16.0f);
            TexTuring.this.initDrop();
            int guiWidth = 350;
            Rect guiRect = new Rect(TexTuring.this.d, TexTuring.this.d, 100.0f, 22.0f);
            this.elements.add(new Menu(new Rect(guiRect), new String[]{"Parameters", "Save settings", "Load settings"}));
            guiRect.size.x = 113.0f;
            guiRect.pos.x += 190.0f;
            this.elements.add(new Menu(new Rect(guiRect), new String[]{"Input  image", "Select file", "Select folder"}));
            guiRect.pos.x += 118.0f;
            this.elements.add(new Menu(new Rect(guiRect), new String[]{"Seeding  mode", "random", "noise", "uniform"}));
            guiRect.pos.x += 118.0f;
            this.elements.add(new Button(new Rect(guiRect), "Save  image"));
            this.elements.add(0, new ViewPort(new Rect(TexTuring.this.d + 200 + 350 + 90, TexTuring.this.b + 35, TexTuring.this.width - 200 - 350 - 90 - TexTuring.this.d - TexTuring.this.d, TexTuring.this.height - 3 * TexTuring.this.b - 35)));
            guiRect.pos.x = TexTuring.this.d + 200 + 350 + 90;
            this.elements.add(new Button(new Rect(guiRect), "Render  preview"));
            guiRect.size.x = 22.0f;
            guiRect.size.y = 22.0f;
            guiRect.pos.x += 118.0f;
            this.elements.add(new Button(new Rect(guiRect), " +"));
            guiRect.pos.x += 27.0f;
            this.elements.add(new Button(new Rect(guiRect), " -"));
            guiRect.pos.x += 28.0f;
            guiRect.size.x = (float)TexTuring.this.width - guiRect.pos.x - 45.0f - (float)TexTuring.this.d;
            this.elements.add(1, new StatusBar(new Rect(guiRect), "status"));
            guiRect.size.x = 45.0f;
            guiRect.pos.x = TexTuring.this.width - TexTuring.this.d - 45;
            this.elements.add(new Button(new Rect(guiRect), "About"));
            guiRect = new Rect(200.0f, TexTuring.this.d, guiWidth, 23.0f);
            guiRect.pos.y += 100.0f;
            this.elements.add(new Slider(new Rect(guiRect), "iterations", "Growing time", 5000));
            guiRect.pos.y += 55.0f;
            this.elements.add(new Slider(new Rect(guiRect), "resolution", "Size", 255));
            guiRect.pos.y += 55.0f;
            guiRect.size.x -= 30.0f;
            this.elements.add(new Slider(new Rect(guiRect), "threshold", "Threshold", 255));
            guiRect.pos.x += guiRect.size.x + 10.0f;
            guiRect.size.x = 22.0f;
            this.elements.add(new CheckBox(new Rect(guiRect), "check threshold"));
            guiRect = new Rect(250.0f, guiRect.pos.y, 250.0f, 250.0f);
            guiRect.pos.y += 55.0f;
            this.elements.add(2, new DiSlider(new Rect(guiRect), "From Growing bay to shades of grey"));
            guiRect.size.x = guiWidth + 10;
            guiRect.size.y = 60.0f;
            guiRect.pos.x = 200.0f;
            guiRect.pos.y += 304.0f;
            this.elements.add(new BiSlider(new Rect(guiRect), "reaction", "Feed rate"));
            guiRect.pos.y += 72.0f;
            this.elements.add(new BiSlider(new Rect(guiRect), "diffusion", "Kill rate"));
            int i2 = 0;
            while (i2 < 7) {
                this.elements.add(i2 + 2, new Snap(new Rect(TexTuring.this.d, TexTuring.this.d + 100 + i2 * (80 + TexTuring.this.b), 100.0f, 80.0f), "snap"));
                ++i2;
            }
            this.elements.get((int)7).flag = "beginAnimation";
            this.elements.get((int)8).flag = "endAnimation";
            this.elements.get((int)16).isSelected = true;
        }

        public void injectMouseMoved() {
            for (GuiElement elem : this.elements) {
                if (TexTuring.this.isRendering && !elem.name.equals("Render  preview")) continue;
                elem.moved();
            }
        }

        public void injectMouseDragged() {
            for (GuiElement elem : this.elements) {
                if (!elem.isOver() || TexTuring.this.isRendering && !elem.name.equals("Render  preview")) continue;
                elem.dragged();
                return;
            }
        }

        public void injectMouseReleased() {
            for (GuiElement elem : this.elements) {
                if (!elem.isOver() || TexTuring.this.isRendering && !elem.name.equals("Render  preview")) continue;
                elem.released();
                return;
            }
        }

        public void injectMousePressed() {
            for (GuiElement elem : this.elements) {
                if (!elem.isOver() || TexTuring.this.isRendering && !elem.name.equals("Render  preview")) continue;
                elem.pressed();
                return;
            }
        }

        public void injectMouseWheel(int scroll) {
            for (GuiElement elem : this.elements) {
                if (!elem.isOver() || TexTuring.this.isRendering) continue;
                elem.scroll(scroll);
                return;
            }
        }

        public void update() {
            TexTuring.this.gui.elements.get(9).updateMapImg();
            TexTuring.this.viewing = true;
            for (GuiElement elem : this.elements) {
                elem.update();
            }
            TexTuring.this.fontColor();
            TexTuring.this.text("Samples", TexTuring.this.d, TexTuring.this.d + 100 - 10);
        }

        public void resize() {
            for (GuiElement elem : this.elements) {
                elem.resize();
            }
        }

        public void message(String msg) {
            this.elements.get(1).message(msg);
            TexTuring.this.updateMessage = true;
        }

        public void about() {
            JPanel aboutPane = new JPanel(new BorderLayout());
            JLabel p1 = new JLabel("<html><h2>TexTuring 2.3</h2>2015-2021 - General Public Licence - GNU GPL<br>Dithering tool based on natural patterns.<br><br> Concept & production :<br></html>");
            SwingLink p2 = new SwingLink("www.ivan-murit.fr", "www.ivan-murit.fr");
            JLabel p3 = new JLabel("<html><br>Special thanks to the crowd-founders for the initial support !<br><br></html>");
            p1.setFont(new Font("SansSerif", 0, 14));
            p2.setFont(new Font("SansSerif", 0, 14));
            p3.setFont(new Font("SansSerif", 0, 14));
            aboutPane.add((Component)p1, "North");
            aboutPane.add((Component)p2, "Center");
            aboutPane.add((Component)p3, "South");
            JOptionPane.showConfirmDialog(null, aboutPane, "About", -1, -1);
        }
    }

    class Menu
    extends GuiElement {
        String[] names;
        Rect zone;

        Menu(Rect _coords, String[] _names) {
            super(_coords, _names[0]);
            this.names = new String[_names.length];
            TexTuring.arrayCopy((Object)_names, (Object)this.names);
            int i = 1;
            while (i < this.names.length) {
                Rect _rect = new Rect(this.coords);
                _rect.pos.y += this.coords.size.y * (float)i;
                TexTuring.this.gui.elements.add(new Button(_rect, this.names[i]));
                ++i;
            }
            this.zone = new Rect(this.coords);
            this.zone.size.y = this.coords.size.y * (float)this.names.length;
            this.update();
        }

        @Override
        public void update() {
            TexTuring.this.fill(this.isOver() ? TexTuring.this.C[14] : TexTuring.this.C[18]);
            this.drawRect(this.coords);
            TexTuring.this.fill(0);
            TexTuring.this.text(this.name, this.coords.pos.x + 5.0f, this.coords.pos.y + 15.0f);
            int i = 1;
            while (i < this.names.length) {
                for (GuiElement _elem : TexTuring.this.gui.elements) {
                    if (_elem.name != this.names[i]) continue;
                    if (this.isOver()) {
                        _elem.isVisible = true;
                    }
                    if (this.zone.isOver()) continue;
                    _elem.isVisible = false;
                }
                ++i;
            }
        }

        @Override
        public void pressed() {
            TexTuring.this.buttonPressed(this);
        }
    }

    class MyDropListener
    extends DropListener {
        int myColor;

        MyDropListener() {
            this.myColor = TexTuring.this.color(255);
            this.setTargetRect(20.0f, 20.0f, TexTuring.this.width - 40, TexTuring.this.height - 40);
        }

        public void draw() {
            TexTuring.this.fill(this.myColor);
            TexTuring.this.rect(10.0f, 10.0f, 100.0f, 100.0f);
        }

        public void dropEnter() {
            TexTuring.this.gui.elements.get((int)0).dropState = true;
            TexTuring.this.viewing = true;
        }

        public void dropLeave() {
            TexTuring.this.gui.elements.get((int)0).dropState = false;
            TexTuring.this.viewing = true;
        }

        public void dropEvent(DropEvent event) {
            if (event.isFile()) {
                if (event.isImage()) {
                    TexTuring.this.fileSelected(event.file());
                }
                if (event.file().isDirectory()) {
                    TexTuring.this.folderSelected(event.file());
                }
                if (event.file().getName().toLowerCase().indexOf("texturing") > -1) {
                    TexTuring.this.params.loadFile(event.file());
                }
            }
        }
    }

    class Parameters {
        float[] b = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] w = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        int[] o;
        int iniState;

        Parameters() {
            int[] nArray = new int[3];
            nArray[2] = 200;
            this.o = nArray;
            this.iniState = 0;
        }

        public void save(String _filePath) {
            String[] saveData = new String[8];
            int i = 0;
            while (i < 7) {
                if (i < 4) {
                    saveData[i] = String.valueOf(this.b[i]) + " " + this.w[i];
                }
                if (i > 3) {
                    saveData[i] = String.valueOf(this.o[i - 4]);
                }
                ++i;
            }
            saveData[7] = String.valueOf(this.iniState);
            if (TexTuring.match((String)_filePath, (String)".TexTuring") == null) {
                _filePath = String.valueOf(_filePath) + ".TexTuring";
            }
            TexTuring.this.saveStrings(_filePath, saveData);
        }

        public void loadFile(File _file) {
            if (_file != null) {
                this.load(TexTuring.this.loadStrings(_file.getAbsolutePath()));
            }
        }

        public void saveFile(File _file) {
            if (_file != null) {
                this.save(_file.getAbsolutePath());
            }
        }

        public void load(String[] _data) {
            TexTuring.print((int)_data.length);
            if (_data.length == 8) {
                int i = 0;
                while (i < 4) {
                    String[] tmp = TexTuring.split((String)_data[i], (String)" ");
                    this.b[i] = PApplet.parseFloat((String)tmp[0]);
                    this.w[i] = PApplet.parseFloat((String)tmp[1]);
                    ++i;
                }
                this.o[0] = PApplet.parseInt((String)_data[4]);
                this.o[1] = PApplet.parseInt((String)_data[5]);
                this.o[2] = PApplet.parseInt((String)_data[6]);
                this.iniState = PApplet.parseInt((String)_data[7]);
                TexTuring.this.gui.update();
                TexTuring.this.updateViewImg = true;
            }
        }

        public void loadParameters(Parameters other) {
            TexTuring.arrayCopy((Object)other.b, (Object)this.b);
            TexTuring.arrayCopy((Object)other.w, (Object)this.w);
            TexTuring.arrayCopy((Object)other.o, (Object)this.o);
            this.iniState = other.iniState;
        }

        public void nextFrameAnimation(int fraction, Parameters out) {
            int i = 0;
            while (i < 4) {
                int n = i;
                this.b[n] = this.b[n] + (out.b[i] - this.b[i]) / (float)fraction;
                int n2 = i;
                this.w[n2] = this.w[n2] + (out.w[i] - this.w[i]) / (float)fraction;
                ++i;
            }
            this.o[0] = this.o[0] + PApplet.parseInt((float)((out.o[0] - this.o[0]) / fraction));
            this.o[1] = this.o[1] + PApplet.parseInt((float)((out.o[1] - this.o[1]) / fraction));
            this.o[2] = this.o[2] + PApplet.parseInt((float)((out.o[2] - this.o[2]) / fraction));
        }
    }

    class Rect {
        Vector2 pos;
        Vector2 size;

        Rect() {
            this.pos = new Vector2();
            this.size = new Vector2();
        }

        Rect(Rect other) {
            this(other.pos, other.size);
        }

        Rect(Vector2 _pos, Vector2 _size) {
            this.pos = new Vector2(_pos);
            this.size = new Vector2(_size);
        }

        Rect(float posX, float posY, float sizeX, float sizeY) {
            this.pos = new Vector2(posX, posY);
            this.size = new Vector2(sizeX, sizeY);
        }

        public boolean isOver() {
            return this.isOver(new Vector2(TexTuring.this.mouseX, TexTuring.this.mouseY));
        }

        public boolean isOver(float x, float y) {
            return this.isOver(new Vector2(x, y));
        }

        public boolean isOver(Vector2 in) {
            return in.x >= this.pos.x && in.x <= this.pos.x + this.size.x && in.y >= this.pos.y && in.y <= this.pos.y + this.size.y;
        }
    }

    class Slider
    extends GuiElement {
        int range;
        float pos;
        boolean press;
        PImage sliderTimeBg;
        PImage sliderTimeBg2;
        String txt;

        Slider(Rect _coords, String _name, String _txt, int _range) {
            super(_coords, _name);
            this.press = false;
            this.sliderTimeBg = TexTuring.this.loadImage("slider.png");
            this.sliderTimeBg2 = TexTuring.this.loadImage("slider2.png");
            this.range = _range;
            this.txt = _txt;
            this.update();
        }

        @Override
        public void pressed() {
            this.pos = TexTuring.this.mouseX;
            this.press = true;
        }

        @Override
        public void released() {
            if (this.press) {
                TexTuring.this.gui.elements.get(9).updateMapImg();
            }
            this.press = false;
        }

        @Override
        public void dragged() {
            TexTuring.this.off = TexTuring.this.control ? 2 : 1;
            this.pos += ((float)TexTuring.this.mouseX - this.pos) / (float)TexTuring.this.off;
            TexTuring.this.params.o[this.ref] = (int)TexTuring.constrain((float)TexTuring.map((float)(this.pos - this.coords.pos.x), (float)0.0f, (float)this.coords.size.x, (float)0.0f, (float)this.range), (float)0.0f, (float)this.range);
            this.pos = TexTuring.this.mouseX;
            if (TexTuring.this.params.o[this.ref] == 0) {
                TexTuring.this.params.o[this.ref] = 1;
            }
            this.update();
            TexTuring.this.viewing = true;
        }

        @Override
        public void update() {
            float b = TexTuring.map((float)TexTuring.this.params.o[this.ref], (float)0.0f, (float)this.range, (float)0.0f, (float)this.coords.size.x);
            TexTuring.this.fill(TexTuring.this.C[20]);
            this.drawRect(this.coords);
            TexTuring.this.pushMatrix();
            TexTuring.this.translate(this.coords.pos.x, this.coords.pos.y);
            if (this.name == "iterations" || this.name == "resolution") {
                TexTuring.this.image(this.sliderTimeBg, PApplet.parseInt((float)(this.coords.size.x - (float)this.sliderTimeBg.width)), 0.0f);
            }
            if (!this.isOver()) {
                TexTuring.this.fill(TexTuring.this.C[14]);
            }
            if (this.isOver()) {
                TexTuring.this.fill(TexTuring.this.C[11]);
            }
            if (this.press) {
                TexTuring.this.fill(TexTuring.this.colorActive);
            }
            if (!TexTuring.this.threshold && this.ref == 1) {
                TexTuring.this.fill(TexTuring.this.C[18]);
            }
            TexTuring.this.rect(0.0f, 0.0f, b, this.coords.size.y);
            TexTuring.this.fontColor();
            TexTuring.this.text(this.txt, 0.0f, -8.0f);
            float textPos = b < this.coords.size.x - 30.0f ? b + 5.0f : b - 30.0f;
            TexTuring.this.text(TexTuring.this.params.o[this.ref], textPos, this.coords.size.y - 6.0f);
            TexTuring.this.popMatrix();
        }
    }

    class Snap
    extends GuiElement {
        PImage snap;
        Rect delete;
        PImage delImg;

        Snap(Rect _coords, String _name) {
            super(_coords, _name);
            this.savedParams = new Parameters();
            this.delete = new Rect(this.coords.pos.x + (float)TexTuring.this.b, this.coords.pos.y + (float)TexTuring.this.b, 20.0f, 20.0f);
            this.delImg = TexTuring.this.loadImage("delete.png");
            this.update();
        }

        @Override
        public boolean isSnaped() {
            return this.snap != null;
        }

        @Override
        public void pressed() {
            if (this.snap == null) {
                this.savedParams.loadParameters(TexTuring.this.params);
                this.snap = TexTuring.this.loadImage("gradient.png");
                this.snap.resize((int)this.coords.size.x, (int)this.coords.size.y);
                this.snap = TexTuring.this.render(this.snap, (int)this.coords.size.x * 3, "quiet");
                this.snap.resize((int)this.coords.size.x, 0);
                TexTuring.this.fill(TexTuring.this.C[25]);
                this.drawRect(this.coords);
                this.update();
            }
            if (this.snap != null) {
                if (this.delete.isOver()) {
                    this.snap = null;
                } else {
                    TexTuring.this.params.loadParameters(this.savedParams);
                    TexTuring.this.gui.update();
                }
            }
            TexTuring.this.viewing = true;
        }

        @Override
        public void update() {
            if (this.snap == null) {
                TexTuring.this.fill(this.isOver() ? TexTuring.this.C[20] : TexTuring.this.C[22]);
                this.drawRect(this.coords);
                TexTuring.this.fill(this.isOver() ? TexTuring.this.C[10] : TexTuring.this.C[15]);
                if (this.flag.equals("beginAnimation")) {
                    TexTuring.this.text("begin animation", this.coords.pos.x + 4.0f, this.coords.pos.y + this.coords.size.y - 4.0f);
                }
                if (this.flag.equals("endAnimation")) {
                    TexTuring.this.text("end animation", this.coords.pos.x + 4.0f, this.coords.pos.y + this.coords.size.y - 4.0f);
                }
            } else {
                if (!this.isOver()) {
                    TexTuring.this.fill(230);
                    this.drawRect(this.coords);
                    TexTuring.this.tint(255, 80.0f);
                    TexTuring.this.image(this.snap, this.coords.pos.x, this.coords.pos.y, this.snap.width, this.snap.height);
                    TexTuring.this.noTint();
                } else {
                    TexTuring.this.image(this.snap, this.coords.pos.x, this.coords.pos.y);
                    TexTuring.this.fill(this.delete.isOver() ? TexTuring.this.C[12] : TexTuring.this.C[17]);
                    this.drawRect(this.delete);
                    TexTuring.this.image(this.delImg, this.coords.pos.x + (float)TexTuring.this.b, this.coords.pos.y + (float)TexTuring.this.b);
                }
                TexTuring.this.fill(TexTuring.this.C[22]);
                if (this.flag.equals("beginAnimation") || this.flag.equals("endAnimation")) {
                    TexTuring.this.rect((int)this.coords.pos.x, (float)((int)this.coords.pos.y) + this.coords.size.y - 15.0f, (int)this.coords.size.x, 15.0f);
                }
                TexTuring.this.fill(this.isOver() ? TexTuring.this.C[10] : TexTuring.this.C[15]);
                if (this.flag.equals("beginAnimation")) {
                    TexTuring.this.text("begin animation", this.coords.pos.x + 4.0f, this.coords.pos.y + this.coords.size.y - 4.0f);
                }
                if (this.flag.equals("endAnimation")) {
                    TexTuring.this.text("end animation", this.coords.pos.x + 4.0f, this.coords.pos.y + this.coords.size.y - 4.0f);
                }
            }
            if (this.dropState) {
                TexTuring.this.fill(TexTuring.this.colorActive, 100.0f);
                TexTuring.this.rect(this.coords.pos.x, this.coords.pos.y, this.coords.size.x, this.coords.size.y);
            }
        }
    }

    class StatusBar
    extends GuiElement {
        String txt;

        StatusBar(Rect _coords, String _name) {
            super(_coords, _name);
            this.txt = "";
            this.update();
        }

        @Override
        public void update() {
            TexTuring.this.fill(255);
            this.drawRect(this.coords);
            TexTuring.this.fill(TexTuring.this.C[0]);
            TexTuring.this.text(this.txt, this.coords.pos.x + 10.0f, this.coords.pos.y + 15.0f);
            if (TexTuring.this.isRendering) {
                int space = 120;
                TexTuring.this.fill(TexTuring.this.bg);
                TexTuring.this.rect(this.coords.pos.x + (float)space - 6.0f, this.coords.pos.y, space + 2, this.coords.size.y);
                TexTuring.this.fill(this.txt.equals("Saving file ...") && TexTuring.this.frameCount % 15 < 5 ? TexTuring.this.C[14] : TexTuring.this.C[19]);
                TexTuring.this.rect(this.coords.pos.x + (float)space, this.coords.pos.y, 110.0f, this.coords.size.y);
                TexTuring.this.fill(TexTuring.this.C[10]);
                TexTuring.this.rect(this.coords.pos.x + (float)space, this.coords.pos.y, TexTuring.this.renderProgress, this.coords.size.y);
                if (this.txt.equals("Saving file ...")) {
                    TexTuring.this.updateMessage = true;
                }
            }
        }

        @Override
        public void message(String msg) {
            TexTuring.println((String)("msg: " + msg));
            this.txt = msg;
        }

        @Override
        public void resize() {
            this.coords = new Rect(this.coords.pos.x, this.coords.pos.y, (float)TexTuring.this.width - this.coords.pos.x - 50.0f - (float)TexTuring.this.d, this.coords.size.y);
        }
    }

    public class SwingLink
    extends JLabel {
        private static final long serialVersionUID = 8273875024682878518L;
        private String text;
        private URI uri;

        public SwingLink(String text, URI uri) {
            this.setup(text, uri);
        }

        public SwingLink(String text, String uri) {
            this.setup(text, URI.create(uri));
        }

        public void setup(String t, URI u) {
            this.text = t;
            this.uri = u;
            this.setText(this.text);
            this.setToolTipText(this.uri.toString());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SwingLink.this.open(SwingLink.this.uri);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    SwingLink.this.setText(SwingLink.this.text, false);
                    SwingLink.this.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SwingLink.this.setText(SwingLink.this.text, true);
                }
            });
        }

        @Override
        public void setText(String text) {
            this.setText(text, true);
        }

        public void setText(String text, boolean ul) {
            String link = ul ? "<u>" + text + "</u>" : text;
            super.setText("<html><span style=\"color: #000099;\">" + link + "</span></html>");
            this.text = text;
        }

        public String getRawText() {
            return this.text;
        }

        private void open(URI uri) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(uri);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "Failed to launch the link, your computer is likely misconfigured.", "Cannot Launch Link", 2);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Java is not able to launch links on your computer.", "Cannot Launch Link", 2);
            }
        }
    }

    class Vector2 {
        float x;
        float y;

        Vector2(float _x, float _y) {
            this.x = _x;
            this.y = _y;
        }

        Vector2() {
            this.x = 0.0f;
            this.y = 0.0f;
        }

        Vector2(Vector2 other) {
            this(other.x, other.y);
        }
    }

    class ViewPort
    extends GuiElement {
        Thread[] viewZoneThread;
        int offThread;
        Rect renderZone;
        float centerRectX;
        float centerRectY;
        float centerSize;
        boolean updateViewPort;
        float[][] dataAnimation;

        ViewPort(Rect _coords) {
            super(_coords, "preview");
            this.viewZoneThread = new Thread[TexTuring.constrain((int)Runtime.getRuntime().availableProcessors(), (int)1, (int)4)];
            this.offThread = 0;
            this.centerRectX = 0.0f;
            this.centerRectY = 0.0f;
            this.updateViewPort = false;
            this.viewZone = new Rect(0.0f, 0.0f, this.coords.size.x, this.coords.size.y);
            this.renderZone = new Rect(this.coords.pos.x, this.coords.pos.y, 100.0f, 100.0f);
            this.viewImg = TexTuring.this.createImage(PApplet.parseInt((float)this.coords.size.x), PApplet.parseInt((float)this.coords.size.y), 4);
            TexTuring.this.renderMin = TexTuring.this.createImage(50, 50, 4);
            TexTuring.this.renderMinDone = TexTuring.this.createImage(50, 50, 4);
            this.viewZoneThread[1] = new ViewZoneThread(10);
            this.viewZoneThread[0] = new ViewZoneThread(10);
            this.viewZoneThread[2] = new ViewZoneThread(10);
            this.viewZoneThread[3] = new ViewZoneThread(10);
        }

        @Override
        public void resize() {
            this.coords = new Rect(TexTuring.this.d + 200 + 350 + 90, TexTuring.this.b + 35, TexTuring.this.width - 200 - 350 - 90 - TexTuring.this.d - TexTuring.this.d, TexTuring.this.height - 3 * TexTuring.this.b - 35);
            this.scroll(0);
        }

        @Override
        public void scroll(int scroll) {
            if (TexTuring.this.src.width / TexTuring.this.src.height < 1) {
                this.zoom = TexTuring.constrain((float)(this.zoom + 0.05f * (float)scroll), (float)0.1f, (float)((float)TexTuring.this.src.height / this.coords.size.y));
            }
            if (TexTuring.this.src.width / TexTuring.this.src.height >= 1) {
                this.zoom = TexTuring.constrain((float)(this.zoom + 0.05f * (float)scroll), (float)0.1f, (float)((float)TexTuring.this.src.width / this.coords.size.x));
            }
            this.modifyViewZonePos((this.viewZone.size.x - this.zoom * this.coords.size.x) / 2.0f, (this.viewZone.size.y - this.zoom * this.coords.size.y) / 2.0f);
            this.viewZone.size.x = this.coords.size.x * this.zoom;
            this.viewZone.size.y = this.coords.size.y * this.zoom;
            TexTuring.this.synchroScroll = true;
        }

        @Override
        public void moved() {
            if (this.coords.isOver()) {
                TexTuring.this.cursor(13);
            } else {
                TexTuring.this.cursor(0);
            }
        }

        @Override
        public void dragged() {
            if (this.isOver() || TexTuring.this.synchroScroll) {
                TexTuring.this.synchroScroll = false;
                this.modifyViewZonePos(TexTuring.this.pmouseX - TexTuring.this.mouseX, TexTuring.this.pmouseY - TexTuring.this.mouseY);
                this.updateView(TexTuring.this.src);
                TexTuring.this.viewing = true;
            }
        }

        @Override
        public void initView() {
            this.scroll(-1);
            this.modifyViewZonePos(((float)TexTuring.this.src.width - this.viewZone.size.x) / 2.0f, ((float)TexTuring.this.src.height - this.viewZone.size.y) / 2.0f);
            this.updateView(TexTuring.this.src);
            TexTuring.this.viewing = true;
        }

        public void modifyViewZonePos(float x, float y) {
            this.viewZone.pos.x = TexTuring.constrain((float)(this.viewZone.pos.x + x), (float)0.0f, (float)((float)TexTuring.this.src.width - this.viewZone.size.x > 0.0f ? (float)TexTuring.this.src.width - this.viewZone.size.x : 0.0f));
            this.viewZone.pos.y = TexTuring.constrain((float)(this.viewZone.pos.y + y), (float)0.0f, (float)((float)TexTuring.this.src.height - this.viewZone.size.y > 0.0f ? (float)TexTuring.this.src.height - this.viewZone.size.y : 0.0f));
        }

        @Override
        public void renderView() {
            if (TexTuring.this.isRendering) {
                TexTuring.this.killRender = true;
            } else {
                TexTuring.this.isRendering = true;
                TexTuring.this.viewing = false;
                TexTuring.this.thread("renderViewThread");
            }
        }

        public void updateView(PImage source) {
            this.viewImg = TexTuring.this.createImage(this.viewZone.pos.x + this.viewZone.size.x < (float)TexTuring.this.src.width ? (int)this.viewZone.size.x : PApplet.parseInt((float)TexTuring.this.src.width), this.viewZone.pos.y + this.viewZone.size.y < (float)TexTuring.this.src.height ? (int)this.viewZone.size.y : PApplet.parseInt((float)TexTuring.this.src.height), 4);
            this.viewImg.set(-((int)this.viewZone.pos.x), -((int)this.viewZone.pos.y), source);
        }

        @Override
        public void update() {
            TexTuring.this.fill(TexTuring.this.bg);
            TexTuring.this.rect(this.coords.pos.x, this.coords.pos.y, this.coords.size.x + 10.0f, this.coords.size.y + 10.0f);
            if (TexTuring.this.isRendering) {
                this.frameAnimation();
            } else {
                TexTuring.this.image(this.viewImg, this.coords.pos.x, this.coords.pos.y, TexTuring.round((float)(this.viewZone.pos.x + this.viewZone.size.x < (float)TexTuring.this.src.width ? this.coords.size.x : (float)TexTuring.this.src.width / this.zoom)), TexTuring.round((float)(this.viewZone.pos.y + this.viewZone.size.y < (float)TexTuring.this.src.height ? this.coords.size.y : (float)TexTuring.this.src.height / this.zoom)));
            }
            if (this.dropState) {
                TexTuring.this.fill(TexTuring.this.colorActive, 100.0f);
                TexTuring.this.rect(this.coords.pos.x, this.coords.pos.y, this.coords.size.x, this.coords.size.y);
            }
            if (!TexTuring.this.isRendering && !this.updateViewPort) {
                if (TexTuring.this.viewing) {
                    TexTuring.this.viewing = false;
                    float time = 0.12f;
                    if (TexTuring.this.lastRenderTime < time - 0.11f) {
                        this.centerSize += 35.0f;
                    } else if (TexTuring.this.lastRenderTime > time + 0.11f) {
                        this.centerSize -= 35.0f;
                    } else if (TexTuring.this.lastRenderTime < time - 0.09f) {
                        this.centerSize += 20.0f;
                    } else if (TexTuring.this.lastRenderTime > time + 0.09f) {
                        this.centerSize -= 20.0f;
                    } else if (TexTuring.this.lastRenderTime < time - 0.07f) {
                        this.centerSize += 10.0f;
                    } else if (TexTuring.this.lastRenderTime > time + 0.07f) {
                        this.centerSize -= 10.0f;
                    } else if (TexTuring.this.lastRenderTime < time - 0.05f) {
                        this.centerSize += 4.0f;
                    } else if (TexTuring.this.lastRenderTime > time + 0.05f) {
                        this.centerSize -= 5.0f;
                    } else if (TexTuring.this.lastRenderTime < time - 0.03f) {
                        this.centerSize += 2.0f;
                    } else if (TexTuring.this.lastRenderTime > time + 0.03f) {
                        this.centerSize -= 2.0f;
                    } else if (TexTuring.this.lastRenderTime < time - 0.02f) {
                        this.centerSize += 1.0f;
                    } else if (TexTuring.this.lastRenderTime > time + 0.02f) {
                        this.centerSize -= 1.0f;
                    }
                    if (this.coords.size.x < this.coords.size.y) {
                        this.centerSize = TexTuring.constrain((float)this.centerSize, (float)50.0f, (float)(this.coords.size.x * this.zoom - 10.0f));
                    }
                    if (this.coords.size.x > this.coords.size.y) {
                        this.centerSize = TexTuring.constrain((float)this.centerSize, (float)50.0f, (float)(this.coords.size.y * this.zoom - 10.0f));
                    }
                    this.centerRectX = (this.coords.size.x - this.centerSize / this.zoom) / 2.0f;
                    this.centerRectY = (this.coords.size.y - this.centerSize / this.zoom) / 2.0f;
                    TexTuring.this.renderMin = TexTuring.this.createImage(PApplet.parseInt((float)this.centerSize), PApplet.parseInt((float)this.centerSize), 4);
                    TexTuring.this.renderMin.set(PApplet.parseInt((float)(-this.centerRectX * this.zoom)), PApplet.parseInt((float)(-this.centerRectY * this.zoom)), this.viewImg);
                    this.offThread = (this.offThread + 1) % this.viewZoneThread.length;
                    this.viewZoneThread[this.offThread].interrupt();
                    this.viewZoneThread[this.offThread] = new ViewZoneThread(PApplet.parseInt((float)(this.centerSize / this.zoom)));
                    this.viewZoneThread[this.offThread].start();
                    TexTuring.this.delay(PApplet.parseInt((float)TexTuring.constrain((float)(1000.0f * time / (float)this.viewZoneThread.length), (float)0.0f, (float)(1000.0f * time))));
                }
                TexTuring.this.image(TexTuring.this.renderMinDone, PApplet.parseInt((float)(this.coords.pos.x + (this.coords.size.x - (float)TexTuring.this.renderMinDone.width) / 2.0f)), PApplet.parseInt((float)(this.coords.pos.y + (this.coords.size.y - (float)TexTuring.this.renderMinDone.height) / 2.0f)));
            }
            if (this.updateViewPort) {
                this.updateView(TexTuring.this.src);
            }
            if (this.updateViewPort) {
                this.updateViewPort = false;
            }
        }

        public void frameAnimation() {
            PImage img = TexTuring.this.createImage(this.dataAnimation.length, this.dataAnimation[0].length, 4);
            TexTuring.this.writeImg(img, this.dataAnimation);
            img.resize(TexTuring.round((float)(this.viewZone.pos.x + this.viewZone.size.x < (float)TexTuring.this.src.width ? this.coords.size.x : (float)TexTuring.this.src.width / this.zoom)), 0);
            TexTuring.this.thresholdImg(img);
            TexTuring.this.image(img, this.coords.pos.x, this.coords.pos.y);
            TexTuring.this.fill(150, 70.0f);
            if (!TexTuring.this.lastFrameAnimation) {
                TexTuring.this.rect(this.coords.pos.x, this.coords.pos.y, img.width, img.height);
            }
            TexTuring.this.lastFrameAnimation = false;
        }
    }

    class ViewZoneThread
    extends Thread {
        PImage imgRnd;
        int size;

        public ViewZoneThread(int size) {
            this.size = size;
        }

        @Override
        public void run() {
            TexTuring.this.renderMinDone = TexTuring.this.render(TexTuring.this.renderMin, this.size, "");
            TexTuring.this.updateViewImg = true;
        }
    }
}

