/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.ArchiveStream;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.CommonsArchiveStream;
import org.rauschig.jarchivelib.CommonsStreamFactory;
import org.rauschig.jarchivelib.IOUtils;

class CommonsArchiver
implements Archiver {
    private final ArchiveFormat archiveFormat;

    CommonsArchiver(ArchiveFormat archiveFormat) {
        this.archiveFormat = archiveFormat;
    }

    public ArchiveFormat getArchiveFormat() {
        return this.archiveFormat;
    }

    @Override
    public File create(String archive, File destination, File ... sources) throws IOException {
        IOUtils.requireDirectory(destination);
        File archiveFile = this.createNewArchiveFile(archive, this.getFilenameExtension(), destination);
        ArchiveOutputStream outputStream = null;
        try {
            outputStream = CommonsStreamFactory.createArchiveOutputStream(this, archiveFile);
            this.writeToArchive(sources, outputStream);
            outputStream.flush();
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
        finally {
            IOUtils.closeQuietly(outputStream);
        }
        return archiveFile;
    }

    @Override
    public void extract(File archive, File destination) throws IOException {
        if (archive.isDirectory()) {
            throw new IllegalArgumentException("Can not extract " + archive + ". Source is a directory.");
        }
        if (!archive.exists()) {
            throw new FileNotFoundException(archive.getPath());
        }
        if (!archive.canRead()) {
            throw new IllegalArgumentException("Can not extract " + archive + ". Can not read from source.");
        }
        IOUtils.requireDirectory(destination);
        ArchiveInputStream input = null;
        try {
            ArchiveEntry entry;
            input = CommonsStreamFactory.createArchiveInputStream(archive);
            while ((entry = input.getNextEntry()) != null) {
                File file = new File(destination, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                IOUtils.copy((InputStream)input, file);
            }
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    @Override
    public ArchiveStream stream(File archive) throws IOException {
        try {
            return new CommonsArchiveStream(CommonsStreamFactory.createArchiveInputStream(archive));
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getFilenameExtension() {
        return this.getArchiveFormat().getDefaultFileExtension();
    }

    protected File createNewArchiveFile(String archive, String extension, File destination) throws IOException {
        if (!archive.endsWith(extension)) {
            archive = archive + extension;
        }
        File file = new File(destination, archive);
        file.createNewFile();
        return file;
    }

    protected void writeToArchive(File[] sources, ArchiveOutputStream archive) throws IOException {
        for (File source : sources) {
            if (!source.exists()) {
                throw new FileNotFoundException(source.getPath());
            }
            if (!source.canRead()) {
                throw new FileNotFoundException(source.getPath() + " (Permission denied)");
            }
            if (source.isFile()) {
                this.writeToArchive(source.getParentFile(), new File[]{source}, archive);
                continue;
            }
            this.writeToArchive(source, source.listFiles(), archive);
        }
    }

    protected void writeToArchive(File parent, File[] sources, ArchiveOutputStream archive) throws IOException {
        for (File source : sources) {
            String relativePath = IOUtils.relativePath(parent, source);
            this.createArchiveEntry(source, relativePath, archive);
            if (!source.isDirectory()) continue;
            this.writeToArchive(parent, source.listFiles(), archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createArchiveEntry(File file, String entryName, ArchiveOutputStream archive) throws IOException {
        ArchiveEntry entry = archive.createArchiveEntry(file, entryName);
        archive.putArchiveEntry(entry);
        if (!entry.isDirectory()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                IOUtils.copy((InputStream)input, archive);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
            IOUtils.closeQuietly(input);
        }
        archive.closeArchiveEntry();
    }
}

