/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.rauschig.jarchivelib.ArchiveEntry;
import org.rauschig.jarchivelib.ArchiveStream;
import org.rauschig.jarchivelib.IOUtils;

class CommonsArchiveEntry
implements ArchiveEntry {
    private org.apache.commons.compress.archivers.ArchiveEntry entry;
    private ArchiveStream stream;

    CommonsArchiveEntry(ArchiveStream stream, org.apache.commons.compress.archivers.ArchiveEntry entry) {
        this.stream = stream;
        this.entry = entry;
    }

    @Override
    public String getName() {
        this.assertState();
        return this.entry.getName();
    }

    @Override
    public long getSize() {
        this.assertState();
        return this.entry.getSize();
    }

    @Override
    public Date getLastModifiedDate() {
        this.assertState();
        return this.entry.getLastModifiedDate();
    }

    @Override
    public boolean isDirectory() {
        this.assertState();
        return this.entry.isDirectory();
    }

    @Override
    public File extract(File destination) throws IOException, IllegalStateException, IllegalArgumentException {
        this.assertState();
        IOUtils.requireDirectory(destination);
        File file = new File(destination, this.entry.getName());
        if (this.entry.isDirectory()) {
            file.mkdirs();
        } else {
            file.getParentFile().mkdirs();
            IOUtils.copy((InputStream)this.stream, file);
        }
        return file;
    }

    private void assertState() {
        if (this.stream.isClosed()) {
            throw new IllegalStateException("Stream has already been closed");
        }
        if (this != this.stream.getCurrentEntry()) {
            throw new IllegalStateException("Illegal stream pointer");
        }
    }
}

