/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.File;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverCompressorDecorator;
import org.rauschig.jarchivelib.CommonsArchiver;
import org.rauschig.jarchivelib.CommonsCompressor;
import org.rauschig.jarchivelib.CompressionType;
import org.rauschig.jarchivelib.FileType;

public final class ArchiverFactory {
    private ArchiverFactory() {
    }

    public static Archiver createArchiver(File archive) throws IllegalArgumentException {
        FileType fileType = FileType.get(archive);
        if (fileType == FileType.UNKNOWN) {
            throw new IllegalArgumentException("Unknown file extension " + archive.getName());
        }
        return ArchiverFactory.createArchiver(fileType);
    }

    public static Archiver createArchiver(FileType fileType) {
        if (fileType == FileType.UNKNOWN) {
            throw new IllegalArgumentException("Unknown file type");
        }
        if (fileType.isArchive() && fileType.isCompressed()) {
            return ArchiverFactory.createArchiver(fileType.getArchiveFormat(), fileType.getCompressionType());
        }
        if (fileType.isArchive()) {
            return ArchiverFactory.createArchiver(fileType.getArchiveFormat());
        }
        throw new IllegalArgumentException("Unknown archive file extension " + fileType);
    }

    public static Archiver createArchiver(String archiveFormat, String compression) throws IllegalArgumentException {
        if (!ArchiveFormat.isValidArchiveFormat(archiveFormat)) {
            throw new IllegalArgumentException("Unknown archive format " + archiveFormat);
        }
        if (!CompressionType.isValidCompressionType(compression)) {
            throw new IllegalArgumentException("Unknown compression type " + compression);
        }
        return ArchiverFactory.createArchiver(ArchiveFormat.fromString(archiveFormat), CompressionType.fromString(compression));
    }

    public static Archiver createArchiver(ArchiveFormat archiveFormat, CompressionType compression) {
        CommonsArchiver archiver = new CommonsArchiver(archiveFormat);
        CommonsCompressor compressor = new CommonsCompressor(compression);
        return new ArchiverCompressorDecorator(archiver, compressor);
    }

    public static Archiver createArchiver(String archiveFormat) throws IllegalArgumentException {
        if (!ArchiveFormat.isValidArchiveFormat(archiveFormat)) {
            throw new IllegalArgumentException("Unknown archive format " + archiveFormat);
        }
        return ArchiverFactory.createArchiver(ArchiveFormat.fromString(archiveFormat));
    }

    public static Archiver createArchiver(ArchiveFormat archiveFormat) {
        return new CommonsArchiver(archiveFormat);
    }
}

