/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

public enum ArchiveFormat {
    AR("ar", ".ar"),
    CPIO("cpio", ".cpio"),
    DUMP("dump", ".dump"),
    JAR("jar", ".jar"),
    TAR("tar", ".tar"),
    ZIP("zip", ".zip");

    private final String name;
    private final String defaultFileExtension;

    private ArchiveFormat(String name, String defaultFileExtension) {
        this.name = name;
        this.defaultFileExtension = defaultFileExtension;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultFileExtension() {
        return this.defaultFileExtension;
    }

    public static boolean isValidArchiveFormat(String archiveFormat) {
        for (ArchiveFormat format : ArchiveFormat.values()) {
            if (!archiveFormat.trim().equalsIgnoreCase(format.getName())) continue;
            return true;
        }
        return false;
    }

    public static ArchiveFormat fromString(String archiveFormat) {
        for (ArchiveFormat format : ArchiveFormat.values()) {
            if (!archiveFormat.trim().equalsIgnoreCase(format.getName())) continue;
            return format;
        }
        throw new IllegalArgumentException("Unknown archive format " + archiveFormat);
    }
}

