/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.util;

import java.util.Random;

public class PrimitiveArrays {
    public static void fillCounting(int[] array, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            array[i + offset] = i;
        }
    }

    public static int[] fillCounting(int length) {
        int[] array = new int[length];
        PrimitiveArrays.fillCounting(array, 0, length);
        return array;
    }

    public static void shuffle(byte[] array, int offset, int length, Random rand) {
        for (int i = 0; i < length; ++i) {
            int src = rand.nextInt(length - i);
            byte tmp = array[offset + src + i];
            array[offset + src + i] = array[offset + i];
            array[offset + i] = tmp;
        }
    }

    public static void shuffle(short[] array, int offset, int length, Random rand) {
        for (int i = 0; i < length; ++i) {
            int src = rand.nextInt(length - i);
            short tmp = array[offset + src + i];
            array[offset + src + i] = array[offset + i];
            array[offset + i] = tmp;
        }
    }

    public static void shuffle(int[] array, int offset, int length, Random rand) {
        for (int i = 0; i < length; ++i) {
            int src = rand.nextInt(length - i);
            int tmp = array[offset + src + i];
            array[offset + src + i] = array[offset + i];
            array[offset + i] = tmp;
        }
    }

    public static void shuffle(long[] array, int offset, int length, Random rand) {
        for (int i = 0; i < length; ++i) {
            int src = rand.nextInt(length - i);
            long tmp = array[offset + src + i];
            array[offset + src + i] = array[offset + i];
            array[offset + i] = tmp;
        }
    }

    public static void shuffle(float[] array, int offset, int length, Random rand) {
        for (int i = 0; i < length; ++i) {
            int src = rand.nextInt(length - i);
            float tmp = array[offset + src + i];
            array[offset + src + i] = array[offset + i];
            array[offset + i] = tmp;
        }
    }

    public static void shuffle(double[] array, int offset, int length, Random rand) {
        for (int i = 0; i < length; ++i) {
            int src = rand.nextInt(length - i);
            double tmp = array[offset + src + i];
            array[offset + src + i] = array[offset + i];
            array[offset + i] = tmp;
        }
    }

    public static int min(byte[] array, int offset, int length) {
        byte by;
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < length; ++i) {
            byte tmp = array[offset + i];
            if (tmp >= by) continue;
            by = tmp;
        }
        return by;
    }

    public static int min(short[] array, int offset, int length) {
        short s;
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < length; ++i) {
            short tmp = array[offset + i];
            if (tmp >= s) continue;
            s = tmp;
        }
        return s;
    }

    public static int min(int[] array, int offset, int length) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < length; ++i) {
            int tmp = array[offset + i];
            if (tmp >= min) continue;
            min = tmp;
        }
        return min;
    }

    public static long min(long[] array, int offset, int length) {
        long min = Long.MAX_VALUE;
        for (int i = 0; i < length; ++i) {
            long tmp = array[offset + i];
            if (tmp >= min) continue;
            min = tmp;
        }
        return min;
    }

    public static float min(float[] array, int offset, int length) {
        float min = Float.MAX_VALUE;
        for (int i = 0; i < length; ++i) {
            float tmp = array[offset + i];
            if (!(tmp < min)) continue;
            min = tmp;
        }
        return min;
    }

    public static double min(double[] array, int offset, int length) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < length; ++i) {
            double tmp = array[offset + i];
            if (!(tmp < min)) continue;
            min = tmp;
        }
        return min;
    }

    public static int max(byte[] array, int offset, int length) {
        byte by;
        int n = -2147483647;
        for (int i = 0; i < length; ++i) {
            byte tmp = array[offset + i];
            if (tmp <= by) continue;
            by = tmp;
        }
        return by;
    }

    public static int max(short[] array, int offset, int length) {
        short s;
        int n = -2147483647;
        for (int i = 0; i < length; ++i) {
            short tmp = array[offset + i];
            if (tmp <= s) continue;
            s = tmp;
        }
        return s;
    }

    public static int max(int[] array, int offset, int length) {
        int max = -2147483647;
        for (int i = 0; i < length; ++i) {
            int tmp = array[offset + i];
            if (tmp <= max) continue;
            max = tmp;
        }
        return max;
    }

    public static long max(long[] array, int offset, int length) {
        long max = -9223372036854775807L;
        for (int i = 0; i < length; ++i) {
            long tmp = array[offset + i];
            if (tmp <= max) continue;
            max = tmp;
        }
        return max;
    }

    public static float max(float[] array, int offset, int length) {
        float max = -3.4028235E38f;
        for (int i = 0; i < length; ++i) {
            float tmp = array[offset + i];
            if (!(tmp > max)) continue;
            max = tmp;
        }
        return max;
    }

    public static double max(double[] array, int offset, int length) {
        double max = -1.7976931348623157E308;
        for (int i = 0; i < length; ++i) {
            double tmp = array[offset + i];
            if (!(tmp > max)) continue;
            max = tmp;
        }
        return max;
    }

    public static int lowerBound(byte[] array, int offset, int length, int val) {
        int count = length;
        int first = offset;
        while (count > 0) {
            int step = count / 2;
            int idx = first + step;
            if (array[idx] < val) {
                first = idx + 1;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }

    public static int lowerBoundU(byte[] array, int offset, int length, int val) {
        int count = length;
        int first = offset;
        while (count > 0) {
            int step = count / 2;
            int idx = first + step;
            if ((array[idx] & 0xFF) < val) {
                first = idx + 1;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }

    public static int lowerBound(short[] array, int offset, int length, int val) {
        int count = length;
        int first = offset;
        while (count > 0) {
            int step = count / 2;
            int idx = first + step;
            if (array[idx] < val) {
                first = idx + 1;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }

    public static int lowerBound(int[] array, int offset, int length, int val) {
        int count = length;
        int first = offset;
        while (count > 0) {
            int step = count / 2;
            int idx = first + step;
            if (array[idx] < val) {
                first = idx + 1;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }

    public static int lowerBound(float[] array, int offset, int length, float val) {
        int count = length;
        int first = offset;
        while (count > 0) {
            int step = count / 2;
            int idx = first + step;
            if (array[idx] < val) {
                first = idx + 1;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }

    public static int lowerBound(double[] array, int offset, int length, double val) {
        int count = length;
        int first = offset;
        while (count > 0) {
            int step = count / 2;
            int idx = first + step;
            if (array[idx] < val) {
                first = idx + 1;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }
}

