/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;
import org.ddogleg.struct.GrowQueue;

public class GrowQueue_I64
implements GrowQueue<GrowQueue_I64> {
    public long[] data;
    public int size;

    public GrowQueue_I64(int maxSize) {
        this.data = new long[maxSize];
        this.size = 0;
    }

    public GrowQueue_I64() {
        this(10);
    }

    public static GrowQueue_I64 zeros(int length) {
        GrowQueue_I64 out = new GrowQueue_I64(length);
        out.size = length;
        return out;
    }

    public static GrowQueue_I64 array(long ... values) {
        GrowQueue_I64 out = GrowQueue_I64.zeros(values.length);
        for (int i = 0; i < values.length; ++i) {
            out.data[i] = values[i];
        }
        return out;
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    public void addAll(GrowQueue_I64 queue) {
        if (this.size + queue.size > this.data.length) {
            long[] temp = new long[(this.size + queue.size) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(queue.data, 0, this.data, this.size, queue.size);
        this.size += queue.size;
    }

    public void addAll(long[] array, int startIndex, int endIndex) {
        if (endIndex > array.length) {
            throw new IllegalAccessError("endIndex is larger than input array");
        }
        int arraySize = endIndex - startIndex;
        if (this.size + arraySize > this.data.length) {
            long[] temp = new long[(this.size + arraySize) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(array, startIndex, this.data, this.size, arraySize);
        this.size += arraySize;
    }

    public void add(long value) {
        this.push(value);
    }

    public void push(long val) {
        if (this.size == this.data.length) {
            long[] temp = new long[this.size * 2 + 5];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = val;
    }

    public long get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[index];
    }

    public long getTail(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[this.size - index - 1];
    }

    public long getFraction(double fraction) {
        return this.get((int)((double)(this.size - 1) * fraction));
    }

    public long unsafe_get(int index) {
        return this.data[index];
    }

    public void set(int index, long value) {
        this.data[index] = value;
    }

    @Override
    public void setTo(GrowQueue_I64 original) {
        this.resize(original.size);
        System.arraycopy(original.data, 0, this.data, 0, this.size());
    }

    public void setTo(long[] array, int offset, int length) {
        this.resize(length);
        System.arraycopy(array, offset, this.data, 0, length);
    }

    public void remove(int index) {
        for (int i = index + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        --this.size;
    }

    public void remove(int first, int last) {
        if (last < first) {
            throw new IllegalArgumentException("first <= last");
        }
        if (last >= this.size) {
            throw new IllegalArgumentException("last must be less than the max size");
        }
        int delta = last - first + 1;
        for (int i = last + 1; i < this.size; ++i) {
            this.data[i - delta] = this.data[i];
        }
        this.size -= delta;
    }

    public void insert(int index, long value) {
        if (this.size == this.data.length) {
            long[] temp = new long[this.size * 2 + 5];
            System.arraycopy(this.data, 0, temp, 0, index);
            temp[index] = value;
            System.arraycopy(this.data, index, temp, index + 1, this.size - index);
            this.data = temp;
            ++this.size;
        } else {
            ++this.size;
            for (int i = this.size - 1; i > index; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[index] = value;
        }
    }

    public long removeTail() {
        if (this.size > 0) {
            --this.size;
            return this.data[this.size];
        }
        throw new RuntimeException("Size zero, no tail");
    }

    @Override
    public void resize(int size) {
        if (this.data.length < size) {
            this.data = new long[size];
        }
        this.size = size;
    }

    @Override
    public void extend(int size) {
        if (this.data.length < size) {
            long[] tmp = new long[size];
            System.arraycopy(this.data, 0, tmp, 0, this.size);
            this.data = tmp;
        }
        this.size = size;
    }

    public void fill(long value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public boolean contains(long value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setMaxSize(int size) {
        if (this.data.length < size) {
            this.data = new long[size];
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public long pop() {
        return this.data[--this.size];
    }

    @Override
    public void zero() {
        Arrays.fill(this.data, 0, this.size, 0L);
    }

    @Override
    public GrowQueue_I64 copy() {
        GrowQueue_I64 ret = new GrowQueue_I64(this.size);
        ret.setTo(this);
        return ret;
    }

    @Override
    public void flip() {
        if (this.size <= 1) {
            return;
        }
        int D2 = this.size / 2;
        int i = 0;
        int j = this.size - 1;
        while (i < D2) {
            long tmp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = tmp;
            ++i;
            --j;
        }
    }

    public int indexOf(long value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }
}

