/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import org.ddogleg.struct.Factory;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastQueueList;
import org.ddogleg.struct.Process;

public class FastQueue<T>
extends FastAccess<T> {
    private Factory<T> factory;
    private Process<T> reset;
    private FastQueueList<T> list = new FastQueueList(this);

    public FastQueue(Class<T> type, Factory<T> factory) {
        super(type);
        this.init(10, factory);
    }

    public FastQueue(Factory<T> factory) {
        super(factory.newInstance().getClass());
        this.init(10, factory);
    }

    public FastQueue(Factory<T> factory, Process<T> reset) {
        super(factory.newInstance().getClass());
        this.reset = reset;
        this.init(10, factory);
    }

    public FastQueue(int initialMaxSize, Factory<T> factory) {
        super(factory.newInstance().getClass());
        this.init(initialMaxSize, factory);
    }

    protected void init(int initialMaxSize, Factory<T> factory) {
        this.size = 0;
        this.factory = factory;
        if (this.reset == null) {
            this.reset = new Process.DoNothing();
        }
        this.data = (Object[])Array.newInstance(this.type, initialMaxSize);
        if (factory != null) {
            for (int i = 0; i < initialMaxSize; ++i) {
                try {
                    this.data[i] = this.createInstance();
                    continue;
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("declareInstances is true, but createInstance() can't create a new instance.  Maybe override createInstance()?");
                }
            }
        }
    }

    @Override
    public List<T> toList() {
        return this.list;
    }

    public void remove(int[] indexes, int fromIndex, int toIndex, @Nullable List<T> workSpace) {
        int i;
        if (toIndex <= fromIndex) {
            return;
        }
        if (workSpace == null) {
            workSpace = new ArrayList<T>();
        } else {
            workSpace.clear();
        }
        Arrays.sort(indexes, fromIndex, toIndex);
        int target = indexes[fromIndex];
        int count = 0;
        for (i = indexes[fromIndex]; i < this.size; ++i) {
            if (i == target) {
                workSpace.add(this.data[i]);
                if (++count < toIndex - fromIndex) {
                    target = indexes[fromIndex + count];
                    continue;
                }
                target = -1;
                continue;
            }
            this.data[i - count] = this.data[i];
        }
        for (i = 0; i < workSpace.size(); ++i) {
            this.data[this.size - i - 1] = workSpace.get(i);
        }
        this.size -= workSpace.size();
    }

    public T removeTail() {
        if (this.size > 0) {
            --this.size;
            return (T)this.data[this.size];
        }
        throw new IllegalArgumentException("Size is already zero");
    }

    public void reset() {
        this.size = 0;
    }

    public T grow() {
        if (this.size < this.data.length) {
            Object ret = this.data[this.size++];
            this.reset.process(ret);
            return (T)ret;
        }
        this.growArray((this.data.length + 1) * 2);
        return (T)this.data[this.size++];
    }

    public void copyAll(List<T> list, Set<T> setter) {
        this.growArray(this.size() + list.size());
        for (int i = 0; i < list.size(); ++i) {
            T dst = this.grow();
            setter.set(list.get(i), dst);
        }
    }

    @Override
    public T remove(int index) {
        Object removed = this.data[index];
        for (int i = index + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        this.data[this.size - 1] = removed;
        --this.size;
        return (T)removed;
    }

    @Override
    public T removeSwap(int index) {
        Object removed = this.data[index];
        this.data[index] = this.data[this.size - 1];
        this.data[this.size - 1] = removed;
        --this.size;
        return (T)removed;
    }

    public void growArray(int length) {
        if (this.data.length >= length) {
            return;
        }
        Object[] data = (Object[])Array.newInstance(this.type, length);
        System.arraycopy(this.data, 0, data, 0, this.data.length);
        if (this.factory != null) {
            for (int i = this.data.length; i < length; ++i) {
                data[i] = this.createInstance();
            }
        }
        this.data = data;
    }

    public void resize(int length) {
        this.growArray(length);
        for (int i = this.size; i < length; ++i) {
            this.reset.process(this.data[i]);
        }
        this.size = length;
    }

    public boolean contains(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.data[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public void shuffle(Random rand) {
        for (int i = 0; i < this.size; ++i) {
            int selected = rand.nextInt(this.size - i);
            Object tmp = this.data[selected];
            this.data[selected] = this.data[this.size - i - 1];
            this.data[this.size - i - 1] = tmp;
        }
    }

    @Deprecated
    protected T createInstance() {
        T instance = this.factory.newInstance();
        this.reset.process(instance);
        return instance;
    }

    public List<T> copyIntoList(List<T> ret) {
        if (ret == null) {
            ret = new ArrayList<T>(this.size);
        }
        for (int i = 0; i < this.size; ++i) {
            ret.add(this.data[i]);
        }
        return ret;
    }

    public int indexOf(T obj) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.data[i].equals(obj)) continue;
            return i;
        }
        return -1;
    }

    public void flip() {
        if (this.size <= 1) {
            return;
        }
        int D2 = this.size / 2;
        int i = 0;
        int j = this.size - 1;
        while (i < D2) {
            Object tmp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = tmp;
            ++i;
            --j;
        }
    }

    public void swap(int idx0, int idx1) {
        Object tmp = this.data[idx0];
        this.data[idx0] = this.data[idx1];
        this.data[idx1] = tmp;
    }

    public boolean isUnused(T object) {
        Object[] data = this.data;
        for (int i = this.size; i < data.length; ++i) {
            if (data[i] != object) continue;
            return true;
        }
        return false;
    }

    public T[] getData() {
        return this.data;
    }

    public void setData(T[] data) {
        this.data = data;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public final boolean isDeclare() {
        return this.factory != null;
    }

    public Class<T> getType() {
        return this.type;
    }

    public class FactoryClass
    implements Factory<T> {
        Class<T> type;

        public FactoryClass(Class<T> type) {
            this.type = type;
        }

        @Override
        public T newInstance() {
            try {
                return this.type.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface Set<T> {
        public void set(T var1, T var2);
    }
}

