/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.io.Serializable;
import java.util.List;

public abstract class FastAccess<T>
implements Serializable {
    public T[] data;
    public int size;
    public final Class<T> type;

    public FastAccess(Class<T> type) {
        this.type = type;
    }

    public T get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Out of bounds. index=" + index + " max size " + this.size);
        }
        return this.data[index];
    }

    public int getMaxSize() {
        return this.data.length;
    }

    public abstract T remove(int var1);

    public abstract T removeSwap(int var1);

    public int size() {
        return this.size;
    }

    public abstract List<T> toList();

    public T getTail() {
        return this.data[this.size - 1];
    }

    public T getTail(int index) {
        return this.data[this.size - 1 - index];
    }

    public void reverse() {
        for (int i = 0; i < this.size / 2; ++i) {
            T tmp = this.data[i];
            this.data[i] = this.data[this.size - i - 1];
            this.data[this.size - i - 1] = tmp;
        }
    }
}

