/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.stats;

public class UtilGaussian {
    public static double SQRT_2_PI = Math.sqrt(Math.PI * 2);

    public static double computePDF(double mean, double sigma, double sample) {
        double delta = sample - mean;
        return Math.exp(-delta * delta / (2.0 * sigma * sigma)) / (sigma * SQRT_2_PI);
    }

    public static double derivative1(double mean, double sigma, double sample) {
        double delta = sample - mean;
        double a = Math.exp(-delta * delta / (2.0 * sigma * sigma)) / (sigma * SQRT_2_PI);
        double c = -delta / (sigma * sigma);
        return c * a;
    }

    public static double derivative2(double mean, double sigma, double sample) {
        double delta = sample - mean;
        double sigma2 = sigma * sigma;
        double exp = Math.exp(-delta * delta / (2.0 * sigma * sigma)) / (sigma * SQRT_2_PI);
        double c = -delta / sigma2;
        return (c * c - 1.0 / sigma2) * exp;
    }

    public static double derivative3(double mean, double sigma, double sample) {
        double delta = sample - mean;
        double sigma2 = sigma * sigma;
        double exp = Math.exp(-delta * delta / (2.0 * sigma * sigma)) / (sigma * SQRT_2_PI);
        double c = -delta / sigma2;
        return c * (c * c - 3.0 / sigma2) * exp;
    }

    public static double derivative4(double mean, double sigma, double sample) {
        double delta = sample - mean;
        double sigma2 = sigma * sigma;
        double exp = Math.exp(-delta * delta / (2.0 * sigma * sigma)) / (sigma * SQRT_2_PI);
        double c = -delta / sigma2;
        return (3.0 / (sigma2 * sigma2) + c * c * c * c - 6.0 * c * c / sigma2) * exp;
    }
}

