/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.trustregion;

import javax.annotation.Nonnull;
import org.ddogleg.optimization.GaussNewtonBase_F64;
import org.ddogleg.optimization.UnconstrainedLeastSquaresSchur;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.SchurJacobian;
import org.ddogleg.optimization.math.HessianSchurComplement;
import org.ddogleg.optimization.trustregion.ConfigTrustRegion;
import org.ddogleg.optimization.trustregion.TrustRegionBase_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.SpecializedOps_DDRM;

public class UnconLeastSqTrustRegionSchur_F64<S extends DMatrix>
extends TrustRegionBase_F64<S, HessianSchurComplement<S>>
implements UnconstrainedLeastSquaresSchur<S> {
    protected DMatrixRMaj residuals = new DMatrixRMaj(1, 1);
    protected FunctionNtoM functionResiduals;
    protected SchurJacobian<S> functionJacobian;
    protected S jacLeft;
    protected S jacRight;

    public UnconLeastSqTrustRegionSchur_F64(TrustRegionBase_F64.ParameterUpdate<S> update, HessianSchurComplement<S> hessian) {
        super(update, hessian);
        this.jacLeft = hessian.createMatrix();
        this.jacRight = hessian.createMatrix();
    }

    @Override
    public void setFunction(FunctionNtoM function, @Nonnull SchurJacobian<S> jacobian) {
        this.functionResiduals = function;
        this.functionJacobian = jacobian;
        this.residuals.reshape(jacobian.getNumOfOutputsM(), 1);
    }

    @Override
    public void initialize(double[] initial, double ftol, double gtol) {
        this.initialize(initial, this.functionResiduals.getNumOfInputsN(), 0.0);
        ((ConfigTrustRegion)this.config).ftol = ftol;
        ((ConfigTrustRegion)this.config).gtol = gtol;
    }

    @Override
    protected double cost(DMatrixRMaj x) {
        this.functionResiduals.process(x.data, this.residuals.data);
        return 0.5 * SpecializedOps_DDRM.elementSumSq(this.residuals);
    }

    @Override
    protected void functionGradientHessian(DMatrixRMaj x, boolean sameStateAsCost, DMatrixRMaj gradient, HessianSchurComplement<S> hessian) {
        if (!sameStateAsCost) {
            this.functionResiduals.process(x.data, this.residuals.data);
        }
        this.functionJacobian.process(x.data, this.jacLeft, this.jacRight);
        hessian.computeHessian(this.jacLeft, this.jacRight);
        hessian.computeGradient(this.jacLeft, this.jacRight, this.residuals, gradient);
    }

    @Override
    public double[] getParameters() {
        return this.x.data;
    }

    @Override
    public double getFunctionValue() {
        return this.fx;
    }

    @Override
    public boolean isUpdated() {
        return this.mode == GaussNewtonBase_F64.Mode.COMPUTE_DERIVATIVES;
    }

    @Override
    public boolean isConverged() {
        return this.mode == GaussNewtonBase_F64.Mode.CONVERGED;
    }

    public DMatrixRMaj getResiduals() {
        return this.residuals;
    }
}

