/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.math;

import org.ddogleg.optimization.math.HessianMath;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.sparse.csc.CommonOps_DSCC;
import org.ejml.sparse.csc.mult.MatrixVectorMult_DSCC;

public class HessianMath_DSCC
implements HessianMath {
    LinearSolver<DMatrixSparseCSC, DMatrixRMaj> solver;
    DMatrixSparseCSC hessian = new DMatrixSparseCSC(1, 1);

    public HessianMath_DSCC() {
    }

    public HessianMath_DSCC(LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> solver) {
        this.solver = UtilEjml.safe(solver);
    }

    @Override
    public void init(int numParameters) {
        this.hessian.reshape(numParameters, numParameters);
    }

    @Override
    public double innerVectorHessian(DMatrixRMaj v) {
        return MatrixVectorMult_DSCC.innerProduct(v.data, 0, this.hessian, v.data, 0);
    }

    @Override
    public void extractDiagonals(DMatrixRMaj diag) {
        CommonOps_DSCC.extractDiag(this.hessian, diag);
    }

    @Override
    public void setDiagonals(DMatrixRMaj diag) {
        for (int i = 0; i < this.hessian.numRows; ++i) {
            this.hessian.set(i, i, diag.data[i]);
        }
    }

    @Override
    public void divideRowsCols(DMatrixRMaj scaling) {
        CommonOps_DSCC.divideRowsCols(scaling.data, 0, this.hessian, scaling.data, 0);
    }

    @Override
    public boolean initializeSolver() {
        if (this.solver == null) {
            throw new RuntimeException("Solver not set");
        }
        return this.solver.setA(this.hessian);
    }

    @Override
    public boolean solve(DMatrixRMaj Y2, DMatrixRMaj step) {
        this.solver.solve(Y2, step);
        return true;
    }
}

