/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.wrap;

import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeResult;
import org.ddogleg.nn.alg.KdTreeSearch1;
import org.ddogleg.nn.alg.KdTreeSearchN;
import org.ddogleg.struct.FastQueue;

public abstract class KdTreeInternalSearch<P>
implements NearestNeighbor.Search<P> {
    KdTreeSearch1<P> search1;
    KdTreeSearchN<P> searchN;
    FastQueue<KdTreeResult> found = new FastQueue<KdTreeResult>(KdTreeResult::new);

    KdTreeInternalSearch(KdTreeSearch1<P> search1, KdTreeSearchN<P> searchN) {
        this.search1 = search1;
        this.searchN = searchN;
    }

    abstract void setTree();

    @Override
    public boolean findNearest(P point, double maxDistance, NnData<P> result) {
        this.setTree();
        if (maxDistance < 0.0) {
            this.search1.setMaxDistance(Double.MAX_VALUE);
        } else {
            this.search1.setMaxDistance(maxDistance);
        }
        KdTree.Node found = this.search1.findNeighbor(point);
        if (found == null) {
            return false;
        }
        result.point = found.point;
        result.index = found.index;
        result.distance = this.search1.getDistance();
        return true;
    }

    @Override
    public void findNearest(P point, double maxDistance, int numNeighbors, FastQueue<NnData<P>> results) {
        this.setTree();
        results.reset();
        if (maxDistance <= 0.0) {
            this.searchN.setMaxDistance(Double.MAX_VALUE);
        } else {
            this.searchN.setMaxDistance(maxDistance);
        }
        this.found.reset();
        this.searchN.findNeighbor(point, numNeighbors, this.found);
        for (int i = 0; i < this.found.size; ++i) {
            KdTreeResult k = (KdTreeResult)this.found.get(i);
            NnData<P> r = results.grow();
            r.point = k.node.point;
            r.index = k.node.index;
            r.distance = k.distance;
        }
    }
}

