/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg.searches;

import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.nn.alg.KdTreeResult;
import org.ddogleg.nn.alg.KdTreeSearchN;
import org.ddogleg.struct.FastQueue;

public class KdTreeSearchNStandard<P>
implements KdTreeSearchN<P> {
    private KdTree tree;
    private P target;
    private double maxDistanceSq = Double.MAX_VALUE;
    private double mostDistantNeighborSq;
    private int mostDistantNeighborIndex;
    private int searchN;
    KdTreeDistance<P> distance;

    public KdTreeSearchNStandard(KdTreeDistance<P> distance) {
        this.distance = distance;
    }

    @Override
    public void setTree(Object tree) {
        this.tree = (KdTree)tree;
    }

    @Override
    public void setMaxDistance(double maxDistance) {
        this.maxDistanceSq = maxDistance;
    }

    @Override
    public void findNeighbor(P target, int searchN, FastQueue<KdTreeResult> results) {
        if (searchN <= 0) {
            throw new IllegalArgumentException("I'm sorry, but I refuse to search for less than or equal to 0 neighbors.");
        }
        if (this.tree.root == null) {
            return;
        }
        this.searchN = searchN;
        this.target = target;
        this.mostDistantNeighborSq = this.maxDistanceSq;
        this.stepClosest(this.tree.root, results);
    }

    @Override
    public KdTreeSearchN<P> copy() {
        return new KdTreeSearchNStandard<P>(this.distance);
    }

    private void stepClosest(KdTree.Node node, FastQueue<KdTreeResult> neighbors) {
        KdTree.Node further;
        KdTree.Node nearer;
        if (node == null) {
            return;
        }
        this.checkBestDistance(node, neighbors);
        if (node.isLeaf()) {
            return;
        }
        double splitValue = this.distance.valueAt(node.point, node.split);
        double targetAtSplit = this.distance.valueAt(this.target, node.split);
        if (targetAtSplit <= splitValue) {
            nearer = node.left;
            further = node.right;
        } else {
            nearer = node.right;
            further = node.left;
        }
        this.stepClosest(nearer, neighbors);
        double dx = splitValue - targetAtSplit;
        if (dx * dx <= this.mostDistantNeighborSq && (neighbors.size() < this.searchN || dx * dx < this.mostDistantNeighborSq)) {
            this.stepClosest(further, neighbors);
        }
    }

    private void checkBestDistance(KdTree.Node node, FastQueue<KdTreeResult> neighbors) {
        block3: {
            double distSq;
            block4: {
                distSq = this.distance.distance(node.point, this.target);
                if (!(distSq <= this.mostDistantNeighborSq)) break block3;
                if (neighbors.size() >= this.searchN) break block4;
                KdTreeResult r = neighbors.grow();
                r.distance = distSq;
                r.node = node;
                if (neighbors.size() != this.searchN) break block3;
                this.mostDistantNeighborSq = -1.0;
                for (int i = 0; i < this.searchN; ++i) {
                    r = (KdTreeResult)neighbors.get(i);
                    if (!(r.distance > this.mostDistantNeighborSq)) continue;
                    this.mostDistantNeighborSq = r.distance;
                    this.mostDistantNeighborIndex = i;
                }
                break block3;
            }
            for (int i = 0; i < this.searchN; ++i) {
                KdTreeResult r = (KdTreeResult)neighbors.get(i);
                if (!(r.distance > this.mostDistantNeighborSq)) continue;
                throw new RuntimeException("Most distant isn't the most distant");
            }
            KdTreeResult r = (KdTreeResult)neighbors.get(this.mostDistantNeighborIndex);
            r.node = node;
            r.distance = distSq;
            this.mostDistantNeighborSq = -1.0;
            for (int i = 0; i < this.searchN; ++i) {
                r = (KdTreeResult)neighbors.get(i);
                if (!(r.distance > this.mostDistantNeighborSq)) continue;
                this.mostDistantNeighborSq = r.distance;
                this.mostDistantNeighborIndex = i;
            }
        }
    }
}

