/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg.searches;

import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.nn.alg.KdTreeSearch1;
import org.ddogleg.nn.alg.searches.KdTreeSearchBestBinFirst;

public class KdTreeSearch1Bbf<P>
extends KdTreeSearchBestBinFirst<P>
implements KdTreeSearch1<P> {
    private KdTree.Node bestNode;

    public KdTreeSearch1Bbf(KdTreeDistance<P> distance, int maxNodesSearched) {
        super(distance, maxNodesSearched);
    }

    @Override
    public void setTree(Object tree) {
        if (tree instanceof KdTree) {
            this.setTree((KdTree)tree);
        } else {
            this.setTrees((KdTree[])tree);
        }
    }

    @Override
    public KdTree.Node findNeighbor(P target) {
        this.bestNode = null;
        this._findClosest(target);
        return this.bestNode;
    }

    @Override
    public double getDistance() {
        return this.bestDistanceSq;
    }

    @Override
    protected void checkBestDistance(KdTree.Node node, P target) {
        double distanceSq = this.distance.distance(node.point, target);
        if (distanceSq <= this.bestDistanceSq && (this.bestNode == null || distanceSq < this.bestDistanceSq)) {
            this.bestDistanceSq = distanceSq;
            this.bestNode = node;
        }
    }

    @Override
    protected boolean canImprove(double distanceSq) {
        if (distanceSq <= this.bestDistanceSq) {
            return this.bestNode == null || distanceSq < this.bestDistanceSq;
        }
        return false;
    }

    @Override
    public KdTreeSearch1<P> copy() {
        return new KdTreeSearch1Bbf<P>(this.distance, this.maxNodesSearched);
    }
}

