/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import java.util.List;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.GrowQueue_F64;
import org.ddogleg.struct.GrowQueue_I32;

public class ExhaustiveNeighbor<P> {
    List<P> points;
    double bestDistance;
    GrowQueue_F64 distances = new GrowQueue_F64();
    GrowQueue_I32 indexes = new GrowQueue_I32();
    GrowQueue_I32 indexesSort = new GrowQueue_I32();
    KdTreeDistance<P> distance;

    public ExhaustiveNeighbor(KdTreeDistance<P> distance) {
        this.distance = distance;
    }

    public ExhaustiveNeighbor() {
    }

    public void setPoints(List<P> points) {
        this.points = points;
    }

    public int findClosest(P p, double maxDistance) {
        int best = -1;
        this.bestDistance = maxDistance;
        for (int i = 0; i < this.points.size(); ++i) {
            P c = this.points.get(i);
            double distanceC = this.distance.distance(p, c);
            if (!(distanceC <= this.bestDistance)) continue;
            this.bestDistance = distanceC;
            best = i;
        }
        return best;
    }

    public void findClosestN(P p, double maxDistance, int numNeighbors, GrowQueue_I32 outputIndex, GrowQueue_F64 outputDistance) {
        int i;
        this.distances.reset();
        this.indexes.reset();
        for (i = 0; i < this.points.size(); ++i) {
            P c = this.points.get(i);
            double distanceC = this.distance.distance(p, c);
            if (!(distanceC <= maxDistance)) continue;
            this.distances.add(distanceC);
            this.indexes.add(i);
        }
        if ((numNeighbors = Math.min(this.distances.size, numNeighbors)) == 0) {
            return;
        }
        this.indexesSort.resize(this.distances.size);
        QuickSelect.selectIndex(this.distances.data, numNeighbors - 1, this.distances.size, this.indexesSort.data);
        for (i = 0; i < numNeighbors; ++i) {
            int index = this.indexes.get(this.indexesSort.get(i));
            outputIndex.add(index);
            outputDistance.add(this.distances.get(this.indexesSort.get(i)));
        }
    }

    public double getBestDistance() {
        return this.bestDistance;
    }
}

