/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset.ransac;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcherMulti;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ddogleg.struct.FastArray;

public class RansacMulti<Point>
implements ModelMatcherMulti<Point> {
    protected int sampleSize;
    protected Random rand;
    protected long randSeed;
    protected List<Point> candidatePoints = new ArrayList<Point>();
    protected List<Point> bestFitPoints = new ArrayList<Point>();
    protected List<ObjectType> objectTypes;
    protected List<Object> objectParam = new ArrayList<Object>();
    protected List<Object> objectCandidateParam = new ArrayList<Object>();
    protected Object bestFitParam;
    protected int bestFitModelIndex;
    protected List<Point> dataSet = new ArrayList<Point>();
    protected int iteration;
    protected int maxIterations;
    protected FastArray<Point> initialSample;
    protected int[] matchToInput = new int[1];
    protected int[] bestMatchToInput = new int[1];

    public RansacMulti(long randSeed, int maxIterations, List<ObjectType> objectTypes, Class<Point> typePoint) {
        this.randSeed = randSeed;
        this.rand = new Random(randSeed);
        this.maxIterations = maxIterations;
        this.objectTypes = objectTypes;
        this.sampleSize = 0;
        for (int i = 0; i < objectTypes.size(); ++i) {
            ObjectType o = objectTypes.get(i);
            this.objectParam.add(o.modelManager.createModelInstance());
            this.objectCandidateParam.add(o.modelManager.createModelInstance());
            if (o.sampleSize <= 0) {
                o.sampleSize = o.modelGenerator.getMinimumPoints();
            }
            if (o.sampleSize <= this.sampleSize) continue;
            this.sampleSize = o.sampleSize;
        }
        this.initialSample = new FastArray<Point>(typePoint);
    }

    @Override
    public boolean process(List<Point> _dataSet) {
        if (_dataSet.size() < this.sampleSize) {
            return false;
        }
        this.dataSet.clear();
        this.dataSet.addAll(_dataSet);
        this.initialize(this.dataSet);
        this.iteration = 0;
        while (this.checkExitIteration()) {
            this.initialSample.reset();
            Ransac.randomDraw(this.dataSet, this.sampleSize, this.initialSample.toList(), this.rand);
            for (int j = 0; j < this.objectTypes.size(); ++j) {
                ObjectType model = this.objectTypes.get(j);
                Object param = this.objectCandidateParam.get(j);
                this.initialSample.size = model.sampleSize;
                if (!model.modelGenerator.generate(this.initialSample.toList(), param)) continue;
                this.selectMatchSet(_dataSet, model.modelDistance, model.thresholdFit, param);
                if (this.bestFitPoints.size() >= this.candidatePoints.size()) continue;
                this.bestFitModelIndex = j;
                this.objectCandidateParam.set(j, this.objectParam.get(j));
                this.objectParam.set(j, param);
                this.setBestModel(param);
            }
            ++this.iteration;
        }
        return this.bestFitPoints.size() > 0;
    }

    protected boolean checkExitIteration() {
        return this.iteration < this.maxIterations && this.bestFitPoints.size() != this.dataSet.size();
    }

    protected void initialize(List<Point> dataSet) {
        this.bestFitPoints.clear();
        if (dataSet.size() > this.matchToInput.length) {
            this.matchToInput = new int[dataSet.size()];
            this.bestMatchToInput = new int[dataSet.size()];
        }
    }

    protected <Model> void selectMatchSet(List<Point> dataSet, DistanceFromModel<Model, Point> modelDistance, double threshold, Model param) {
        this.candidatePoints.clear();
        modelDistance.setModel(param);
        for (int i = 0; i < dataSet.size(); ++i) {
            Point point = dataSet.get(i);
            double distance = modelDistance.computeDistance(point);
            if (!(distance < threshold)) continue;
            this.matchToInput[this.candidatePoints.size()] = i;
            this.candidatePoints.add(point);
        }
    }

    protected void setBestModel(Object param) {
        List<Point> tempPts = this.candidatePoints;
        this.candidatePoints = this.bestFitPoints;
        this.bestFitPoints = tempPts;
        int[] tempIndex = this.matchToInput;
        this.matchToInput = this.bestMatchToInput;
        this.bestMatchToInput = tempIndex;
        this.bestFitParam = param;
    }

    @Override
    public List<Point> getMatchSet() {
        return this.bestFitPoints;
    }

    @Override
    public int getInputIndex(int matchIndex) {
        return this.bestMatchToInput[matchIndex];
    }

    @Override
    public double getFitQuality() {
        return this.bestFitPoints.size();
    }

    @Override
    public Object getModelParameters() {
        return this.bestFitParam;
    }

    @Override
    public int getModelIndex() {
        return this.bestFitModelIndex;
    }

    public int getInlierSize() {
        return this.bestFitPoints.size();
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    protected List<Point> getCandidatePoints() {
        return this.candidatePoints;
    }

    protected FastArray<Point> getInitialSample() {
        return this.initialSample;
    }

    @Override
    public int getMinimumSize() {
        return this.sampleSize;
    }

    @Override
    public void reset() {
        this.rand = new Random(this.randSeed);
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    public int getIteration() {
        return this.iteration;
    }

    @Override
    public Class<Point> getPointType() {
        return this.initialSample.type;
    }

    @Override
    public Class<Object> getModelType() {
        return Object.class;
    }

    public static class ObjectType<Model, Point> {
        public double thresholdFit;
        public int sampleSize = -1;
        public ModelGenerator<Model, Point> modelGenerator;
        public DistanceFromModel<Model, Point> modelDistance;
        public ModelManager<Model> modelManager;
    }
}

