/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset.distance;

import java.util.Iterator;
import java.util.LinkedList;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.distance.PointIndex;
import org.ddogleg.fitting.modelset.distance.StatisticalFit;
import org.ddogleg.sorting.QuickSort_F64;

public class FitByMedianStatistics<Model, Point>
implements StatisticalFit<Model, Point> {
    private DistanceFromModel<Model, Point> modelError;
    private LinkedList<PointIndex<Point>> allPoints;
    private double pruneThreshold;
    private double medianError;
    private double pruneVal;
    double[] errors = new double[100];
    double[] origErrors = new double[100];
    QuickSort_F64 sorter = new QuickSort_F64();

    public FitByMedianStatistics(double pruneThreshold) {
        if (pruneThreshold < 0.0 || pruneThreshold > 1.0) {
            throw new IllegalArgumentException("The threshold must be between 0 and 1");
        }
        this.pruneThreshold = pruneThreshold;
    }

    @Override
    public void init(DistanceFromModel<Model, Point> modelError, LinkedList<PointIndex<Point>> allPoints) {
        this.modelError = modelError;
        this.allPoints = allPoints;
    }

    @Override
    public void computeStatistics() {
        int size = this.allPoints.size();
        if (this.errors.length < size) {
            this.errors = new double[size * 3 / 2];
            this.origErrors = new double[this.errors.length];
        }
        Iterator iter = this.allPoints.iterator();
        int index = 0;
        while (iter.hasNext()) {
            Object pt = ((PointIndex)iter.next()).data;
            this.errors[index++] = this.modelError.computeDistance(pt);
        }
        System.arraycopy(this.errors, 0, this.origErrors, 0, size);
        int where = (int)((double)size * this.pruneThreshold);
        this.sorter.sort(this.errors, size);
        this.medianError = this.errors[size / 2];
        this.pruneVal = this.errors[where];
    }

    @Override
    public void prune() {
        Iterator iter = this.allPoints.iterator();
        int index = 0;
        while (iter.hasNext()) {
            iter.next();
            int n = index++;
            if (!(this.origErrors[n] >= this.pruneVal)) continue;
            iter.remove();
        }
    }

    @Override
    public double getErrorMetric() {
        return this.medianError;
    }
}

