/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.kmeans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ddogleg.clustering.AssignCluster;
import org.ddogleg.clustering.ComputeClusters;
import org.ddogleg.clustering.kmeans.AssignKMeans_F64;
import org.ddogleg.clustering.kmeans.InitializeKMeans_F64;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class StandardKMeans_F64
implements ComputeClusters<double[]> {
    int N;
    boolean verbose = false;
    int maxIterations;
    int maxConverge;
    double convergeTol;
    InitializeKMeans_F64 seedSelector;
    FastQueue<double[]> clusters;
    GrowQueue_I32 labels = new GrowQueue_I32();
    FastQueue<double[]> workClusters;
    GrowQueue_I32 memberCount = new GrowQueue_I32();
    double bestDistance;
    double sumDistance;
    FastQueue<double[]> bestClusters;
    double bestClusterScore;

    public StandardKMeans_F64(int maxIterations, int maxConverge, double convergeTol, InitializeKMeans_F64 seedSelector) {
        this.maxIterations = maxIterations;
        this.maxConverge = maxConverge;
        this.convergeTol = convergeTol;
        this.seedSelector = seedSelector;
    }

    @Override
    public void init(int pointDimension, long randomSeed) {
        this.seedSelector.init(pointDimension, randomSeed);
        this.N = pointDimension;
        this.clusters = this.createQueue(pointDimension);
        this.workClusters = this.createQueue(pointDimension);
        this.bestClusters = this.createQueue(pointDimension);
        this.memberCount.resize(pointDimension);
    }

    private FastQueue<double[]> createQueue(int pointDimension) {
        return new FastQueue<double[]>(() -> new double[pointDimension]);
    }

    @Override
    public void process(List<double[]> points, int numCluster) {
        if (this.verbose) {
            System.out.println("ENTER standard kmeans process");
        }
        this.clusters.resize(numCluster);
        this.workClusters.resize(numCluster);
        this.bestClusters.resize(numCluster);
        this.memberCount.resize(numCluster);
        this.labels.resize(points.size());
        this.seedSelector.selectSeeds(points, this.clusters.toList());
        this.bestClusterScore = Double.MAX_VALUE;
        double previousSum = Double.MAX_VALUE;
        int lastConverge = 0;
        for (int iteration = 0; iteration < this.maxIterations; ++iteration) {
            int i;
            for (i = 0; i < this.workClusters.size(); ++i) {
                Arrays.fill(((double[][])this.workClusters.data)[i], 0.0);
            }
            this.memberCount.fill(0);
            this.matchPointsToClusters(points);
            if (this.sumDistance < this.bestClusterScore) {
                this.bestClusterScore = this.sumDistance;
                for (i = 0; i < this.clusters.size(); ++i) {
                    System.arraycopy(((double[][])this.clusters.data)[i], 0, ((double[][])this.bestClusters.data)[i], 0, this.N);
                }
                if (this.verbose) {
                    System.out.println(iteration + "  better clusters score: " + this.bestClusterScore);
                }
            }
            boolean reseed = iteration - lastConverge >= this.maxConverge;
            double fractionalChange = 1.0 - this.sumDistance / previousSum;
            if (reseed |= fractionalChange >= 0.0 && fractionalChange <= this.convergeTol) {
                if (this.verbose) {
                    System.out.println(iteration + "  Reseeding: " + this.sumDistance);
                }
                this.seedSelector.selectSeeds(points, this.clusters.toList());
                previousSum = Double.MAX_VALUE;
                lastConverge = iteration;
                continue;
            }
            if (this.verbose && previousSum == Double.MAX_VALUE) {
                System.out.println(iteration + "  first iteration: " + this.sumDistance);
            }
            previousSum = this.sumDistance;
            this.updateClusterCenters();
        }
        if (this.verbose) {
            System.out.println("EXIT standard kmeans process");
        }
    }

    protected void matchPointsToClusters(List<double[]> points) {
        this.sumDistance = 0.0;
        for (int i = 0; i < points.size(); ++i) {
            double[] p = points.get(i);
            int bestCluster = this.findBestMatch(p);
            double[] c = (double[])this.workClusters.get(bestCluster);
            for (int j = 0; j < c.length; ++j) {
                int n = j;
                c[n] = c[n] + p[j];
            }
            int n = bestCluster;
            this.memberCount.data[n] = this.memberCount.data[n] + 1;
            this.labels.data[i] = bestCluster;
            this.sumDistance += this.bestDistance;
        }
    }

    protected int findBestMatch(double[] p) {
        int bestCluster = -1;
        this.bestDistance = Double.MAX_VALUE;
        for (int j = 0; j < this.clusters.size; ++j) {
            double d = StandardKMeans_F64.distanceSq(p, (double[])this.clusters.get(j));
            if (!(d < this.bestDistance)) continue;
            this.bestDistance = d;
            bestCluster = j;
        }
        return bestCluster;
    }

    protected void updateClusterCenters() {
        for (int i = 0; i < this.clusters.size; ++i) {
            double mc = this.memberCount.get(i);
            double[] w = (double[])this.workClusters.get(i);
            double[] c = (double[])this.clusters.get(i);
            for (int j = 0; j < w.length; ++j) {
                c[j] = w[j] / mc;
            }
        }
    }

    protected static double distanceSq(double[] a, double[] b) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double d = a[i] - b[i];
            sum += d * d;
        }
        return sum;
    }

    public GrowQueue_I32 getPointLabels() {
        return this.labels;
    }

    public FastQueue<double[]> getClusterMeans() {
        return this.bestClusters;
    }

    @Override
    public AssignCluster<double[]> getAssignment() {
        ArrayList<double[]> list = new ArrayList<double[]>();
        list.addAll(this.bestClusters.toList());
        return new AssignKMeans_F64(list);
    }

    @Override
    public double getDistanceMeasure() {
        return this.sumDistance;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

