/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.gmm;

import java.util.List;
import org.ddogleg.clustering.gmm.GaussianGmm_F64;
import org.ddogleg.struct.FastQueue;
import org.ejml.LinearSolverSafe;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.dense.row.mult.VectorVectorMult_DDRM;
import org.ejml.interfaces.decomposition.CholeskyDecomposition_F64;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class GaussianLikelihoodManager {
    List<GaussianGmm_F64> mixtures;
    FastQueue<Likelihood> precomputes;
    LinearSolverDense<DMatrixRMaj> solver;
    DMatrixRMaj diff;

    public GaussianLikelihoodManager(int pointDimension, List<GaussianGmm_F64> mixtures) {
        this.mixtures = mixtures;
        this.solver = LinearSolverFactory_DDRM.symmPosDef(pointDimension);
        this.solver = new LinearSolverSafe<DMatrixRMaj>(this.solver);
        this.precomputes = new FastQueue<Likelihood>(() -> new Likelihood(pointDimension));
        this.diff = new DMatrixRMaj(pointDimension, 1);
    }

    public void precomputeAll() {
        this.precomputes.resize(this.mixtures.size());
        for (int i = 0; i < this.precomputes.size; ++i) {
            ((Likelihood)this.precomputes.get(i)).setGaussian(this.mixtures.get(i));
        }
    }

    public Likelihood getLikelihood(int which) {
        return (Likelihood)this.precomputes.get(which);
    }

    public class Likelihood {
        public GaussianGmm_F64 gaussian;
        public DMatrixRMaj invCov;
        public double leftSide;
        public double chisq;
        public boolean valid = false;

        public Likelihood(int N) {
            this.invCov = new DMatrixRMaj(N, N);
        }

        public void setGaussian(GaussianGmm_F64 gaussian) {
            this.gaussian = gaussian;
            if (!GaussianLikelihoodManager.this.solver.setA(gaussian.covariance)) {
                this.valid = false;
                return;
            }
            this.valid = true;
            GaussianLikelihoodManager.this.solver.invert(this.invCov);
            CholeskyDecomposition_F64 decomposition = (CholeskyDecomposition_F64)GaussianLikelihoodManager.this.solver.getDecomposition();
            double det = decomposition.computeDeterminant().real;
            this.leftSide = 1.0 / Math.sqrt(det);
        }

        public double likelihood(double[] point) {
            if (!this.valid) {
                return 0.0;
            }
            int N = this.gaussian.mean.numRows;
            for (int i = 0; i < N; ++i) {
                GaussianLikelihoodManager.this.diff.data[i] = point[i] - this.gaussian.mean.data[i];
            }
            this.chisq = VectorVectorMult_DDRM.innerProdA(GaussianLikelihoodManager.this.diff, this.invCov, GaussianLikelihoodManager.this.diff);
            return this.leftSide * Math.exp(-0.5 * this.chisq);
        }

        public double getChisq() {
            return this.chisq;
        }
    }
}

