/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.se;

import georegression.struct.GeoTuple2D_F32;
import georegression.struct.point.Vector2D_F32;
import georegression.struct.se.SpecialEuclidean;

public class Se2_F32
implements SpecialEuclidean<Se2_F32> {
    public Vector2D_F32 T = new Vector2D_F32();
    public float c;
    public float s;

    public Se2_F32(GeoTuple2D_F32 T, float yaw) {
        this(T.getX(), T.getY(), yaw);
    }

    public Se2_F32(float x, float y, float yaw) {
        this.set(x, y, yaw);
    }

    public Se2_F32(float x, float y, float cosYaw, float sinYaw) {
        this.set(x, y, cosYaw, sinYaw);
    }

    public Se2_F32() {
        this.c = 1.0f;
    }

    public void set(float x, float y, float yaw) {
        this.T.set(x, y);
        this.c = (float)Math.cos(yaw);
        this.s = (float)Math.sin(yaw);
    }

    public void set(float x, float y, float cosYaw, float sinYaw) {
        this.T.set(x, y);
        this.c = cosYaw;
        this.s = sinYaw;
    }

    @Override
    public void set(Se2_F32 target) {
        this.T.set(target.T);
        this.c = target.c;
        this.s = target.s;
    }

    public float getX() {
        return this.T.getX();
    }

    public void setX(float x) {
        this.T.setX(x);
    }

    public float getY() {
        return this.T.getY();
    }

    public void setY(float y) {
        this.T.setY(y);
    }

    public Vector2D_F32 getTranslation() {
        return this.T;
    }

    public void setTranslation(Vector2D_F32 tran) {
        this.T = tran;
    }

    public void setTranslation(float x, float y) {
        this.T.set(x, y);
    }

    public float getYaw() {
        return (float)Math.atan2(this.s, this.c);
    }

    public void setYaw(float yaw) {
        this.c = (float)Math.cos(yaw);
        this.s = (float)Math.sin(yaw);
    }

    public float getCosineYaw() {
        return this.c;
    }

    public float getSineYaw() {
        return this.s;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Se2_F32 createInstance() {
        return new Se2_F32();
    }

    @Override
    public Se2_F32 concat(Se2_F32 second, Se2_F32 result) {
        if (result == null) {
            result = new Se2_F32();
        }
        result.setYaw(this.getYaw() + second.getYaw());
        result.T.x = second.T.x + second.c * this.T.x - second.s * this.T.y;
        result.T.y = second.T.y + second.s * this.T.x + second.c * this.T.y;
        return result;
    }

    @Override
    public Se2_F32 invert(Se2_F32 inverse) {
        if (inverse == null) {
            inverse = new Se2_F32();
        }
        float x = -this.T.x;
        float y = -this.T.y;
        inverse.s = -this.s;
        inverse.c = this.c;
        inverse.T.x = this.c * x + this.s * y;
        inverse.T.y = -this.s * x + this.c * y;
        return inverse;
    }

    @Override
    public void reset() {
        this.c = 1.0f;
        this.s = 0.0f;
        this.T.set(0.0f, 0.0f);
    }

    public Se2_F32 copy() {
        return new Se2_F32(this.T.x, this.T.y, this.c, this.s);
    }

    public String toString() {
        return "Se2( x = " + this.T.x + " y = " + this.T.y + " yaw = " + this.getYaw() + " )";
    }

    public void print() {
        System.out.println(this);
    }
}

