/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.line;

import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.io.Serializable;

public class LineParametric2D_I32
implements Serializable {
    public Point2D_I32 p = new Point2D_I32();
    public int slopeX;
    public int slopeY;

    public LineParametric2D_I32(int x_0, int y_0, int slopeX, int slopeY) {
        this.p.set(x_0, y_0);
        this.slopeX = slopeX;
        this.slopeY = slopeY;
    }

    public LineParametric2D_I32(Point2D_I32 p, int slopeX, int slopeY) {
        this.setPoint(p);
        this.setSlope(slopeX, slopeY);
    }

    public LineParametric2D_I32() {
    }

    public void set(LineParametric2D_I32 line) {
        this.p.set(line.p);
        this.slopeX = line.slopeX;
        this.slopeY = line.slopeY;
    }

    public void setPoint(Point2D_I32 pt) {
        this.p.set(pt);
    }

    public void setPoint(int x, int y) {
        this.p.x = x;
        this.p.y = y;
    }

    public void setSlope(int slopeX, int slopeY) {
        this.slopeX = slopeX;
        this.slopeY = slopeY;
    }

    public Point2D_F64 getPointOnLine(double t) {
        return new Point2D_F64((double)this.slopeX * t + (double)this.p.x, (double)this.slopeY * t + (double)this.p.y);
    }

    public Point2D_I32 getPoint() {
        return this.p;
    }

    public final int getSlopeX() {
        return this.slopeX;
    }

    public final int getSlopeY() {
        return this.slopeY;
    }

    public final int getX() {
        return this.p.x;
    }

    public final int getY() {
        return this.p.y;
    }

    public Point2D_I32 getP() {
        return this.p;
    }

    public void setP(Point2D_I32 p) {
        this.p = p;
    }

    public LineParametric2D_I32 copy() {
        return new LineParametric2D_I32(this.p, this.slopeX, this.slopeY);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " P( " + this.p.x + " " + this.p.y + " ) Slope( " + this.slopeX + " " + this.slopeY + " )";
    }
}

