/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.homography;

import georegression.struct.Matrix3x3_F32;
import georegression.struct.homography.Homography;
import javax.annotation.Nullable;
import org.ejml.data.FMatrixRMaj;
import org.ejml.ops.ConvertFMatrixStruct;

public class Homography2D_F32
extends Matrix3x3_F32
implements Homography<Homography2D_F32> {
    public Homography2D_F32(float a11, float a12, float a13, float a21, float a22, float a23, float a31, float a32, float a33) {
        this.a11 = a11;
        this.a12 = a12;
        this.a13 = a13;
        this.a21 = a21;
        this.a22 = a22;
        this.a23 = a23;
        this.a31 = a31;
        this.a32 = a32;
        this.a33 = a33;
    }

    public Homography2D_F32(Homography2D_F32 a) {
        this.set(a);
    }

    public Homography2D_F32() {
        this.reset();
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Homography2D_F32 createInstance() {
        return new Homography2D_F32();
    }

    @Override
    public void set(Homography2D_F32 target) {
        super.set(target);
    }

    @Override
    public Homography2D_F32 concat(Homography2D_F32 second, Homography2D_F32 ret) {
        if (ret == null) {
            ret = new Homography2D_F32();
        }
        ret.a11 = second.a11 * this.a11 + second.a12 * this.a21 + second.a13 * this.a31;
        ret.a12 = second.a11 * this.a12 + second.a12 * this.a22 + second.a13 * this.a32;
        ret.a13 = second.a11 * this.a13 + second.a12 * this.a23 + second.a13 * this.a33;
        ret.a21 = second.a21 * this.a11 + second.a22 * this.a21 + second.a23 * this.a31;
        ret.a22 = second.a21 * this.a12 + second.a22 * this.a22 + second.a23 * this.a32;
        ret.a23 = second.a21 * this.a13 + second.a22 * this.a23 + second.a23 * this.a33;
        ret.a31 = second.a31 * this.a11 + second.a32 * this.a21 + second.a33 * this.a31;
        ret.a32 = second.a31 * this.a12 + second.a32 * this.a22 + second.a33 * this.a32;
        ret.a33 = second.a31 * this.a13 + second.a32 * this.a23 + second.a33 * this.a33;
        return ret;
    }

    @Override
    public Homography2D_F32 invert(Homography2D_F32 ret) {
        if (ret == null) {
            ret = new Homography2D_F32();
        }
        float m11 = this.a22 * this.a33 - this.a23 * this.a32;
        float m12 = -(this.a21 * this.a33 - this.a23 * this.a31);
        float m13 = this.a21 * this.a32 - this.a22 * this.a31;
        float m21 = -(this.a12 * this.a33 - this.a13 * this.a32);
        float m22 = this.a11 * this.a33 - this.a13 * this.a31;
        float m23 = -(this.a11 * this.a32 - this.a12 * this.a31);
        float m31 = this.a12 * this.a23 - this.a13 * this.a22;
        float m32 = -(this.a11 * this.a23 - this.a13 * this.a21);
        float m33 = this.a11 * this.a22 - this.a12 * this.a21;
        float det = this.a11 * m11 + this.a12 * m12 + this.a13 * m13;
        ret.a11 = m11 / det;
        ret.a12 = m21 / det;
        ret.a13 = m31 / det;
        ret.a21 = m12 / det;
        ret.a22 = m22 / det;
        ret.a23 = m32 / det;
        ret.a31 = m13 / det;
        ret.a32 = m23 / det;
        ret.a33 = m33 / det;
        return ret;
    }

    @Override
    public void reset() {
        this.a33 = 1.0f;
        this.a22 = 1.0f;
        this.a11 = 1.0f;
        this.a32 = 0.0f;
        this.a31 = 0.0f;
        this.a23 = 0.0f;
        this.a21 = 0.0f;
        this.a13 = 0.0f;
        this.a12 = 0.0f;
    }

    public FMatrixRMaj ddrm() {
        return this.ddrm(null);
    }

    public FMatrixRMaj ddrm(@Nullable FMatrixRMaj output) {
        if (output == null) {
            output = new FMatrixRMaj(3, 3);
        }
        ConvertFMatrixStruct.convert(this, output);
        return output;
    }

    public Homography2D_F32 copy() {
        return new Homography2D_F32(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.format("[ %5.2fe %5.2fe %5.2fe ; %5.2fe %5.2fe %5.2fe ; %5.2fe %5.2fe %5.2fe ]", Float.valueOf(this.a11), Float.valueOf(this.a12), Float.valueOf(this.a13), Float.valueOf(this.a21), Float.valueOf(this.a22), Float.valueOf(this.a23), Float.valueOf(this.a31), Float.valueOf(this.a32), Float.valueOf(this.a33));
    }
}

