/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.curve;

import georegression.struct.curve.PolynomialCurve_F64;
import org.ejml.FancyPrint;

public class PolynomialCubic1D_F64
implements PolynomialCurve_F64 {
    public double a;
    public double b;
    public double c;
    public double d;

    public PolynomialCubic1D_F64() {
    }

    public PolynomialCubic1D_F64(double a, double b, double c, double d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public double evaluate(double t) {
        return this.a + this.b * t + this.c * t * t + this.d * t * t * t;
    }

    public void set(double a, double b, double c, double d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public void set(PolynomialCubic1D_F64 src) {
        this.a = src.a;
        this.b = src.b;
        this.c = src.c;
        this.d = src.d;
    }

    public String toString() {
        FancyPrint fp = new FancyPrint();
        return "PolynomialCubic1D_F64{a=" + fp.s(this.a) + ", b=" + fp.s(this.b) + ", c=" + fp.s(this.c) + ", d=" + fp.s(this.d) + '}';
    }

    @Override
    public double get(int coefficient) {
        switch (coefficient) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.d;
            }
        }
        throw new IllegalArgumentException("Coefficient out of range. " + coefficient);
    }

    @Override
    public void set(int coefficient, double value) {
        switch (coefficient) {
            case 0: {
                this.a = value;
                return;
            }
            case 1: {
                this.b = value;
                return;
            }
            case 2: {
                this.c = value;
                return;
            }
            case 3: {
                this.d = value;
                return;
            }
        }
        throw new IllegalArgumentException("Coefficient out of range. " + coefficient);
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    public int degree() {
        return 3;
    }
}

