/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct;

import georegression.struct.GeoTuple_F32;
import java.text.DecimalFormat;
import java.util.Objects;
import org.ejml.UtilEjml;

public abstract class GeoTuple2D_F32<T extends GeoTuple2D_F32>
extends GeoTuple_F32<T> {
    public float x;
    public float y;

    public GeoTuple2D_F32(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public GeoTuple2D_F32() {
    }

    protected void _set(GeoTuple2D_F32 a) {
        this.x = a.x;
        this.y = a.y;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public boolean isIdentical(float x, float y) {
        return this.x == x && this.y == y;
    }

    public boolean isIdentical(float x, float y, float tol) {
        return Math.abs(this.x - x) <= tol && Math.abs(this.y - y) <= tol;
    }

    @Override
    public boolean isIdentical(T t, float tol) {
        return Math.abs(this.x - ((GeoTuple2D_F32)t).x) <= tol && Math.abs(this.y - ((GeoTuple2D_F32)t).y) <= tol;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void plusIP(GeoTuple2D_F32 a) {
        this.x += a.x;
        this.y += a.y;
    }

    public T plus(GeoTuple2D_F32 a) {
        GeoTuple2D_F32 ret = (GeoTuple2D_F32)this.createNewInstance();
        ret.x = this.x + a.x;
        ret.y = this.y + a.y;
        return (T)ret;
    }

    public void timesIP(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
    }

    public void scale(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
    }

    public T times(float scalar) {
        GeoTuple2D_F32 ret = (GeoTuple2D_F32)this.createNewInstance();
        ret.x = this.x * scalar;
        ret.y = this.y * scalar;
        return (T)ret;
    }

    public float distance(float x, float y) {
        float dx = x - this.x;
        float dy = y - this.y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public float distance2(float x, float y) {
        float dx = x - this.x;
        float dy = y - this.y;
        return dx * dx + dy * dy;
    }

    @Override
    public float distance(T t) {
        float dx = ((GeoTuple2D_F32)t).x - this.x;
        float dy = ((GeoTuple2D_F32)t).y - this.y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public float distance2(T t) {
        float dx = ((GeoTuple2D_F32)t).x - this.x;
        float dy = ((GeoTuple2D_F32)t).y - this.y;
        return dx * dx + dy * dy;
    }

    @Override
    public float getIdx(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IllegalArgumentException("Invalid index");
    }

    @Override
    public void setIdx(int index, float value) {
        switch (index) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid index");
            }
        }
    }

    @Override
    public float norm() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @Override
    public float normSq() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    public void print() {
        System.out.println(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoTuple2D_F32 p = (GeoTuple2D_F32)obj;
        return Float.compare(this.x, p.x) == 0 && Float.compare(this.y, p.y) == 0;
    }

    public boolean isNaN() {
        return Float.isNaN(this.x) || Float.isNaN(this.y);
    }

    protected String toString(String name) {
        DecimalFormat format = new DecimalFormat("#");
        String sx = UtilEjml.fancyString(this.x, format, 11, 4);
        String sy = UtilEjml.fancyString(this.y, format, 11, 4);
        return name + "( " + sx + " " + sy + " )";
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y));
    }
}

