/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.geometry.GeometryMath_F64;
import georegression.misc.GrlConstants;
import georegression.struct.line.LineParametric3D_F64;
import georegression.struct.line.LineSegment3D_F64;
import georegression.struct.plane.PlaneGeneral3D_F64;
import georegression.struct.plane.PlaneNormal3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.shapes.Box3D_F64;
import georegression.struct.shapes.BoxLength3D_F64;
import georegression.struct.shapes.Sphere3D_F64;
import georegression.struct.shapes.Triangle3D_F64;
import org.ddogleg.struct.FastAccess;

public class Intersection3D_F64 {
    public static boolean intersect(PlaneNormal3D_F64 plane, LineParametric3D_F64 line, Point3D_F64 intersection) {
        double dx = plane.p.x - line.p.x;
        double dy = plane.p.y - line.p.y;
        double dz = plane.p.z - line.p.z;
        double top = dx * plane.n.x + dy * plane.n.y + dz * plane.n.z;
        double bottom = line.slope.dot(plane.n);
        if (bottom == 0.0) {
            return false;
        }
        double d = top / bottom;
        intersection.x = line.p.x + d * line.slope.x;
        intersection.y = line.p.y + d * line.slope.y;
        intersection.z = line.p.z + d * line.slope.z;
        return true;
    }

    public static boolean intersect(PlaneGeneral3D_F64 plane, LineParametric3D_F64 line, Point3D_F64 intersection) {
        double top = plane.D - plane.A * line.p.x - plane.B * line.p.y - plane.C * line.p.z;
        double bottom = plane.A * line.slope.x + plane.B * line.slope.y + plane.C * line.slope.z;
        if (bottom == 0.0) {
            return false;
        }
        double d = top / bottom;
        intersection.x = line.p.x + d * line.slope.x;
        intersection.y = line.p.y + d * line.slope.y;
        intersection.z = line.p.z + d * line.slope.z;
        return true;
    }

    public static boolean intersect(PlaneGeneral3D_F64 a, PlaneGeneral3D_F64 b, LineParametric3D_F64 line) {
        GeometryMath_F64.cross(a.A, a.B, a.C, b.A, b.B, b.C, line.slope);
        if (line.slope.normSq() == 0.0) {
            return false;
        }
        double n2 = a.A * a.A + a.B * a.B + a.C * a.C;
        double closestX = a.A * a.D / n2;
        double closestY = a.B * a.D / n2;
        double closestZ = a.C * a.D / n2;
        double slopeX = a.B * line.slope.z - a.C * line.slope.y;
        double slopeY = a.C * line.slope.x - a.A * line.slope.z;
        double slopeZ = a.A * line.slope.y - a.B * line.slope.x;
        double top = b.D - b.A * closestX - b.B * closestY - b.C * closestZ;
        double bottom = b.A * slopeX + b.B * slopeY + b.C * slopeZ;
        double d = top / bottom;
        line.p.x = closestX + d * slopeX;
        line.p.y = closestY + d * slopeY;
        line.p.z = closestZ + d * slopeZ;
        return true;
    }

    public static int intersect(Triangle3D_F64 T, LineSegment3D_F64 R, Point3D_F64 output) {
        return Intersection3D_F64.intersect(T, R, output, new Vector3D_F64(), new Vector3D_F64(), new Vector3D_F64(), new Vector3D_F64(), new Vector3D_F64());
    }

    public static int intersect(Triangle3D_F64 T, LineSegment3D_F64 R, Point3D_F64 output, Vector3D_F64 u, Vector3D_F64 v, Vector3D_F64 n, Vector3D_F64 dir, Vector3D_F64 w0) {
        u.minus(T.v1, T.v0);
        v.minus(T.v2, T.v0);
        n.cross(u, v);
        if (n.normSq() == 0.0) {
            return -1;
        }
        dir.minus(R.b, R.a);
        w0.minus(R.a, T.v0);
        double a = -n.dot(w0);
        double b = n.dot(dir);
        if (Math.abs(b) < GrlConstants.EPS) {
            if (a == 0.0) {
                return 2;
            }
            return 0;
        }
        double r = a / b;
        if (r < 0.0) {
            return 0;
        }
        if (r > 1.0) {
            return 0;
        }
        output.x = R.a.x + r * dir.x;
        output.y = R.a.y + r * dir.y;
        output.z = R.a.z + r * dir.z;
        if (Intersection3D_F64.containedPlane(T.v0, output, u, v, w0)) {
            return 1;
        }
        return 0;
    }

    public static int intersect(Triangle3D_F64 T, LineParametric3D_F64 R, Point3D_F64 output) {
        return Intersection3D_F64.intersect(T, R, output, new Vector3D_F64(), new Vector3D_F64(), new Vector3D_F64(), new Vector3D_F64());
    }

    public static int intersect(Triangle3D_F64 T, LineParametric3D_F64 R, Point3D_F64 output, Vector3D_F64 u, Vector3D_F64 v, Vector3D_F64 n, Vector3D_F64 w0) {
        u.minus(T.v1, T.v0);
        v.minus(T.v2, T.v0);
        n.cross(u, v);
        if (n.normSq() == 0.0) {
            return -1;
        }
        Vector3D_F64 dir = R.slope;
        w0.minus(R.p, T.v0);
        double a = -n.dot(w0);
        double b = n.dot(dir);
        if (Math.abs(b) < GrlConstants.EPS) {
            if (a == 0.0) {
                return 2;
            }
            return 0;
        }
        double r = a / b;
        output.x = R.p.x + r * dir.x;
        output.y = R.p.y + r * dir.y;
        output.z = R.p.z + r * dir.z;
        if (Intersection3D_F64.containedPlane(T.v0, output, u, v, w0)) {
            if (r >= 0.0) {
                return 1;
            }
            return 3;
        }
        return 0;
    }

    public static int intersectConvex(FastAccess<Point3D_F64> polygon, LineParametric3D_F64 line, Point3D_F64 output, Vector3D_F64 n, Vector3D_F64 u, Vector3D_F64 v, Vector3D_F64 w0) {
        if (polygon.size < 3) {
            throw new IllegalArgumentException("There must be 3 or more points");
        }
        Point3D_F64 v0 = polygon.get(0);
        Point3D_F64 v1 = polygon.get(1);
        Point3D_F64 v2 = polygon.get(2);
        u.minus(v1, v0);
        v.minus(v2, v0);
        n.cross(u, v);
        if (n.normSq() == 0.0) {
            return -1;
        }
        Vector3D_F64 dir = line.slope;
        w0.minus(line.p, v0);
        double a = -n.dot(w0);
        double b = n.dot(dir);
        if (Math.abs(b) < GrlConstants.EPS) {
            if (a == 0.0) {
                return 2;
            }
            return 0;
        }
        double r = a / b;
        output.x = line.p.x + r * dir.x;
        output.y = line.p.y + r * dir.y;
        output.z = line.p.z + r * dir.z;
        for (int i = 2; i < polygon.size; ++i) {
            if (Intersection3D_F64.containedPlane(v0, output, u, v, w0)) {
                if (r >= 0.0) {
                    return 1;
                }
                return 3;
            }
            if (i >= polygon.size - 1) continue;
            u.minus(polygon.get(i), v0);
            v.minus(polygon.get(i + 1), v0);
        }
        return 0;
    }

    public static int intersectConvex(FastAccess<Point3D_F64> polygon, LineParametric3D_F64 line, Point3D_F64 output) {
        return Intersection3D_F64.intersectConvex(polygon, line, output, new Vector3D_F64(), new Vector3D_F64(), new Vector3D_F64(), new Vector3D_F64());
    }

    private static boolean containedPlane(Point3D_F64 T_v0, Point3D_F64 output, Vector3D_F64 u, Vector3D_F64 v, Vector3D_F64 w0) {
        double uu = u.dot(u);
        double uv = u.dot(v);
        double vv = v.dot(v);
        w0.minus(output, T_v0);
        double wu = w0.dot(u);
        double wv = w0.dot(v);
        double D2 = uv * uv - uu * vv;
        double s = (uv * wv - vv * wu) / D2;
        if (s < 0.0 || s > 1.0) {
            return false;
        }
        double t = (uv * wu - uu * wv) / D2;
        return !(t < 0.0) && !(s + t > 1.0);
    }

    public static boolean contained(BoxLength3D_F64 box, Point3D_F64 point) {
        return box.p.x <= point.x && point.x < box.p.x + box.lengthX && box.p.y <= point.y && point.y < box.p.y + box.lengthY && box.p.z <= point.z && point.z < box.p.z + box.lengthZ;
    }

    public static boolean contained(Box3D_F64 box, Point3D_F64 point) {
        return box.p0.x <= point.x && point.x < box.p1.x && box.p0.y <= point.y && point.y < box.p1.y && box.p0.z <= point.z && point.z < box.p1.z;
    }

    public static boolean contained2(Box3D_F64 box, Point3D_F64 point) {
        return box.p0.x <= point.x && point.x <= box.p1.x && box.p0.y <= point.y && point.y <= box.p1.y && box.p0.z <= point.z && point.z <= box.p1.z;
    }

    public static boolean contained(Box3D_F64 boxA, Box3D_F64 boxB) {
        return boxA.p0.x <= boxB.p0.x && boxA.p1.x >= boxB.p1.x && boxA.p0.y <= boxB.p0.y && boxA.p1.y >= boxB.p1.y && boxA.p0.z <= boxB.p0.z && boxA.p1.z >= boxB.p1.z;
    }

    public static boolean intersect(Box3D_F64 boxA, Box3D_F64 boxB) {
        return Intersection3D_F64.intersect(boxA.p0.x, boxB.p0.x, boxA.p1.x, boxB.p1.x) && Intersection3D_F64.intersect(boxA.p0.y, boxB.p0.y, boxA.p1.y, boxB.p1.y) && Intersection3D_F64.intersect(boxA.p0.z, boxB.p0.z, boxA.p1.z, boxB.p1.z);
    }

    protected static boolean intersect(double a0, double b0, double a1, double b1) {
        if (a0 <= b0) {
            return b0 < a1;
        }
        return a0 < b1;
    }

    public static boolean intersect(LineParametric3D_F64 line, Sphere3D_F64 sphere, Point3D_F64 a, Point3D_F64 b) {
        double XX;
        double C;
        double A;
        double r2 = sphere.radius * sphere.radius;
        double PP = GeometryMath_F64.dot(line.p, line.p);
        double PV = GeometryMath_F64.dot(line.p, line.slope);
        double PX = GeometryMath_F64.dot(line.p, sphere.center);
        double VV = GeometryMath_F64.dot(line.slope, line.slope);
        double VX = GeometryMath_F64.dot(line.slope, sphere.center);
        double B = 2.0 * (PV - VX);
        double inner = B * B - 4.0 * (A = VV) * (C = PP + (XX = GeometryMath_F64.dot(sphere.center, sphere.center)) - 2.0 * PX - r2);
        if (inner < 0.0) {
            return false;
        }
        double sqrt = Math.sqrt(inner);
        double t0 = (-B + sqrt) / (2.0 * A);
        double t1 = (-B - sqrt) / (2.0 * A);
        line.setPointOnLine(t0, a);
        line.setPointOnLine(t1, b);
        return true;
    }
}

