/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.fitting.curves.ClosestPointEllipseAngle_F32;
import georegression.misc.GrlConstants;
import georegression.struct.curve.EllipseRotated_F32;
import georegression.struct.line.LineGeneral2D_F32;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import georegression.struct.point.Point2D_F32;

public class ClosestPoint2D_F32 {
    public static Point2D_F32 closestPoint(LineGeneral2D_F32 line, Point2D_F32 p, Point2D_F32 output) {
        if (output == null) {
            output = new Point2D_F32();
        }
        float AA = line.A * line.A;
        float AB = line.A * line.B;
        float BB = line.B * line.B;
        output.y = AA * p.y - AB * p.x - line.B * line.C;
        output.y /= AA + BB;
        output.x = BB * p.x - AB * p.y - line.A * line.C;
        output.x /= AA + BB;
        return output;
    }

    public static Point2D_F32 closestPoint(LineParametric2D_F32 line, Point2D_F32 p, Point2D_F32 output) {
        if (output == null) {
            output = new Point2D_F32();
        }
        float t = ClosestPoint2D_F32.closestPointT(line, p);
        output.x = line.p.x + line.slope.x * t;
        output.y = line.p.y + line.slope.y * t;
        return output;
    }

    public static float closestPointT(LineParametric2D_F32 line, Point2D_F32 p) {
        float t = line.slope.x * (p.x - line.p.x) + line.slope.y * (p.y - line.p.y);
        return t /= line.slope.x * line.slope.x + line.slope.y * line.slope.y;
    }

    public static float closestPointT(LineParametric2D_F32 line, Point2D_F32 p, float scale) {
        float sx = line.slope.x / scale;
        float sy = line.slope.y / scale;
        float t = sx * (p.x - line.p.x) + sy * (p.y - line.p.y);
        return t /= sx * sx + sy * sy;
    }

    public static float closestPointT(LineParametric2D_F32 line, float x, float y) {
        float t = line.slope.x * (x - line.p.x) + line.slope.y * (y - line.p.y);
        return t /= line.slope.x * line.slope.x + line.slope.y * line.slope.y;
    }

    public static float closestPointT(LineParametric2D_F32 line, float x, float y, float scale) {
        float sx = line.slope.x / scale;
        float sy = line.slope.y / scale;
        float t = sx * (x - line.p.x) + sy * (y - line.p.y);
        return t /= sx * sx + sy * sy;
    }

    public static Point2D_F32 closestPoint(LineSegment2D_F32 line, Point2D_F32 p, Point2D_F32 output) {
        if (output == null) {
            output = new Point2D_F32();
        }
        float slopeX = line.b.x - line.a.x;
        float slopeY = line.b.y - line.a.y;
        float t = slopeX * (p.x - line.a.x) + slopeY * (p.y - line.a.y);
        if ((t /= slopeX * slopeX + slopeY * slopeY) < 0.0f) {
            t = 0.0f;
        } else if (t > 1.0f) {
            t = 1.0f;
        }
        output.x = line.a.x + slopeX * t;
        output.y = line.a.y + slopeY * t;
        return output;
    }

    public static Point2D_F32 closestPoint(EllipseRotated_F32 ellipse, Point2D_F32 p) {
        ClosestPointEllipseAngle_F32 alg = new ClosestPointEllipseAngle_F32(GrlConstants.TEST_F32, 30);
        alg.setEllipse(ellipse);
        alg.process(p);
        return alg.getClosest();
    }
}

