/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry.algs;

import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import org.ddogleg.sorting.QuickSortComparator;
import org.ddogleg.struct.FastArray;

public class AndrewMonotoneConvexHull_F64 {
    QuickSortComparator<Point2D_F64> sorter;
    FastArray<Point2D_F64> work = new FastArray<Point2D_F64>(Point2D_F64.class);

    public AndrewMonotoneConvexHull_F64() {
        this.sorter = new QuickSortComparator((a, b) -> {
            if (a.x < b.x) {
                return -1;
            }
            if (a.x > b.x) {
                return 1;
            }
            if (a.y < b.y) {
                return -1;
            }
            if (a.y > b.y) {
                return 1;
            }
            return 0;
        });
    }

    public void process(Point2D_F64[] input, int length, Polygon2D_F64 hull) {
        int i;
        if (length == 2) {
            hull.vertexes.resize(length);
            for (int i2 = 0; i2 < length; ++i2) {
                hull.get(i2).set(input[i2]);
            }
            return;
        }
        this.sorter.sort((Point2D_F64[])input, length);
        this.work.reset();
        for (int i3 = 0; i3 < length; ++i3) {
            Point2D_F64 p = input[i3];
            while (this.work.size() >= 2 && AndrewMonotoneConvexHull_F64.subtractThenCross(p, (Point2D_F64)this.work.getTail(0), (Point2D_F64)this.work.getTail(1)) >= 0.0) {
                this.work.removeTail();
            }
            this.work.add(p);
        }
        this.work.removeTail();
        int minSize = this.work.size + 2;
        for (i = length - 1; i >= 0; --i) {
            Point2D_F64 p = input[i];
            while (this.work.size() >= minSize && AndrewMonotoneConvexHull_F64.subtractThenCross(p, (Point2D_F64)this.work.getTail(0), (Point2D_F64)this.work.getTail(1)) >= 0.0) {
                this.work.removeTail();
            }
            this.work.add(p);
        }
        this.work.removeTail();
        hull.vertexes.resize(this.work.size);
        for (i = 0; i < this.work.size(); ++i) {
            ((Point2D_F64[])hull.vertexes.data)[i].set((Point2D_F64)this.work.get(i));
        }
    }

    private static double subtractThenCross(Point2D_F64 a, Point2D_F64 b, Point2D_F64 c) {
        double x0 = b.x - a.x;
        double y0 = b.y - a.y;
        double x1 = c.x - a.x;
        double y1 = c.y - a.y;
        return x0 * y1 - y0 * x1;
    }
}

