/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.line.LineParametric3D_F32;
import georegression.struct.line.LineSegment3D_F32;
import georegression.struct.point.Point3D_F32;

public class UtilLine3D_F32 {
    public static LineParametric3D_F32 convert(LineSegment3D_F32 line, LineParametric3D_F32 output) {
        if (output == null) {
            output = new LineParametric3D_F32();
        }
        output.p.set(line.a);
        output.slope.x = line.b.x - line.a.x;
        output.slope.y = line.b.y - line.a.y;
        output.slope.z = line.b.z - line.a.z;
        return output;
    }

    public static float computeT(LineParametric3D_F32 line, Point3D_F32 pointOnLine) {
        float dx = pointOnLine.x - line.p.x;
        float dy = pointOnLine.y - line.p.y;
        float dz = pointOnLine.z - line.p.z;
        float adx = Math.abs(dx);
        float ady = Math.abs(dy);
        float adz = Math.abs(dz);
        float t = adx > ady ? (adx > adz ? dx / line.slope.x : dz / line.slope.z) : (ady > adz ? dy / line.slope.y : dz / line.slope.z);
        return t;
    }
}

