/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.sphere;

import georegression.fitting.sphere.CodecSphere3D_F32;
import georegression.struct.GeoTuple_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.shapes.Sphere3D_F32;
import java.util.List;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.data.DMatrixRMaj;

public class SphereToPointSignedDistanceJacobian_F32
implements FunctionNtoMxN<DMatrixRMaj> {
    private Sphere3D_F32 sphere = new Sphere3D_F32();
    private List<Point3D_F32> points;
    private CodecSphere3D_F32 codec = new CodecSphere3D_F32();

    public void setPoints(List<Point3D_F32> points) {
        this.points = points;
    }

    @Override
    public int getNumOfInputsN() {
        return 4;
    }

    @Override
    public int getNumOfOutputsM() {
        return this.points.size();
    }

    @Override
    public void process(double[] input, DMatrixRMaj output) {
        this.codec.decode(input, this.sphere);
        int index = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            Point3D_F32 p = this.points.get(i);
            float euclidean = this.sphere.center.distance((GeoTuple_F32)p);
            output.data[index++] = (this.sphere.center.x - p.x) / euclidean;
            output.data[index++] = (this.sphere.center.y - p.y) / euclidean;
            output.data[index++] = (this.sphere.center.z - p.z) / euclidean;
            output.data[index++] = -1.0;
        }
    }

    @Override
    public DMatrixRMaj declareMatrixMxN() {
        return new DMatrixRMaj(this.getNumOfOutputsM(), this.getNumOfInputsN());
    }
}

